/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.util.Configurator;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSettingsParser
extends DefaultHandler {
    private Configurator configurator;
    private List configuratorTags = Arrays.asList("resolvers", "namespaces", "parsers", "latest-strategies", "conflict-managers", "outputters", "version-matchers", "statuses", "circular-dependency-strategies", "triggers", "lock-strategies", "caches");
    private IvySettings ivy;
    private String defaultResolver;
    private String defaultCM;
    private String defaultLatest;
    private String defaultCacheManager;
    private String defaultCircular;
    private String defaultLock;
    private String currentConfiguratorTag;
    private URL settings;
    private boolean deprecatedMessagePrinted = false;

    public XmlSettingsParser(IvySettings ivy) {
        this.ivy = ivy;
    }

    public void parse(URL settings) throws ParseException, IOException {
        this.configurator = new Configurator();
        Map typeDefs = this.ivy.getTypeDefs();
        Iterator iter = typeDefs.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.configurator.typeDef(name, (Class)typeDefs.get(name));
        }
        this.doParse(settings);
    }

    private void doParse(URL settingsUrl) throws IOException, ParseException {
        this.settings = settingsUrl;
        InputStream stream = null;
        try {
            stream = URLHandlerRegistry.getDefault().openStream(settingsUrl);
            SAXParserFactory.newInstance().newSAXParser().parse(stream, (DefaultHandler)this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            ParseException pe = new ParseException("failed to load settings from " + settingsUrl + ": " + e.getMessage(), 0);
            pe.initCause(e);
            throw pe;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void parse(Configurator configurator, URL configuration) throws IOException, ParseException {
        this.configurator = configurator;
        this.doParse(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
        block78: {
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (int i = 0; i < att.getLength(); ++i) {
                attributes.put(att.getQName(i), this.ivy.substitute(att.getValue(i)));
            }
            try {
                if ("ivyconf".equals(qName)) {
                    this.deprecatedMessagePrinted = true;
                    Message.deprecated("'ivyconf' element is deprecated, use 'ivysettings' instead (" + this.settings + ")");
                }
                if (this.configurator.getCurrent() != null) {
                    if ("macrodef".equals(this.currentConfiguratorTag) && this.configurator.getTypeDef(qName) != null) {
                        String name = (String)attributes.get("name");
                        if (name == null) {
                            attributes.put("name", "@{name}");
                        } else if (this.configurator.isTopLevelMacroRecord() && name.indexOf("@{name}") != -1) {
                            attributes.put("name", name);
                        } else {
                            attributes.put("name", "@{name}-" + name);
                        }
                    }
                    if (attributes.get("ref") != null) {
                        if (attributes.size() != 1) {
                            throw new IllegalArgumentException("ref attribute should be the only one ! found " + attributes.size() + " in " + qName);
                        }
                        String name = (String)attributes.get("ref");
                        Object child = null;
                        if ("resolvers".equals(this.currentConfiguratorTag)) {
                            child = this.ivy.getResolver(name);
                            if (child == null) {
                                throw new IllegalArgumentException("unknown resolver " + name + ": resolver should be defined before being referenced");
                            }
                        } else if ("latest-strategies".equals(this.currentConfiguratorTag)) {
                            child = this.ivy.getLatestStrategy(name);
                            if (child == null) {
                                throw new IllegalArgumentException("unknown latest strategy " + name + ": latest strategy should be defined before being referenced");
                            }
                        } else if ("conflict-managers".equals(this.currentConfiguratorTag) && (child = this.ivy.getConflictManager(name)) == null) {
                            throw new IllegalArgumentException("unknown conflict manager " + name + ": conflict manager should be defined before being referenced");
                        }
                        if (child == null) {
                            throw new IllegalArgumentException("bad reference " + name);
                        }
                        this.configurator.addChild(qName, child);
                    } else {
                        this.configurator.startCreateChild(qName);
                        Iterator iter = attributes.keySet().iterator();
                        while (iter.hasNext()) {
                            String attName = (String)iter.next();
                            this.configurator.setAttribute(attName, (String)attributes.get(attName));
                        }
                    }
                    break block78;
                }
                if ("classpath".equals(qName)) {
                    String urlStr = (String)attributes.get("url");
                    URL url = null;
                    if (urlStr == null) {
                        String file = (String)attributes.get("file");
                        if (file == null) {
                            throw new IllegalArgumentException("either url or file should be given for classpath element");
                        }
                        url = new File(file).toURI().toURL();
                    } else {
                        url = new URL(urlStr);
                    }
                    this.ivy.addClasspathURL(url);
                    break block78;
                }
                if ("typedef".equals(qName)) {
                    String name = (String)attributes.get("name");
                    String className = (String)attributes.get("classname");
                    Class clazz = this.ivy.typeDef(name, className);
                    this.configurator.typeDef(name, clazz);
                    break block78;
                }
                if ("property".equals(qName)) {
                    String name = (String)attributes.get("name");
                    String value = (String)attributes.get("value");
                    String override = (String)attributes.get("override");
                    if (name == null) {
                        throw new IllegalArgumentException("missing attribute name on property tag");
                    }
                    if (value == null) {
                        throw new IllegalArgumentException("missing attribute value on property tag");
                    }
                    this.ivy.setVariable(name, value, override == null ? true : Boolean.valueOf(override));
                    break block78;
                }
                if ("properties".equals(qName)) {
                    String propFilePath = (String)attributes.get("file");
                    String environmentPrefix = (String)attributes.get("environment");
                    if (propFilePath != null) {
                        String override = (String)attributes.get("override");
                        try {
                            Message.verbose("loading properties: " + propFilePath);
                            this.ivy.loadProperties(new File(propFilePath), override == null ? true : Boolean.valueOf(override));
                            break block78;
                        }
                        catch (Exception fileEx) {
                            Message.verbose("failed to load properties as file: trying as url: " + propFilePath);
                            try {
                                this.ivy.loadProperties(new URL(propFilePath), override == null ? true : Boolean.valueOf(override));
                                break block78;
                            }
                            catch (Exception urlEx) {
                                throw new IllegalArgumentException("unable to load properties from " + propFilePath + ". Tried both as an url and a file, with no success. File exception: " + fileEx + ". URL exception: " + urlEx);
                            }
                        }
                    }
                    if (environmentPrefix != null) {
                        this.ivy.getVariableContainer().setEnvironmentPrefix(environmentPrefix);
                        break block78;
                    }
                    throw new IllegalArgumentException("Didn't find a 'file' or 'environment' attribute on the 'properties' element");
                }
                if ("include".equals(qName)) {
                    IvyVariableContainer variables = (IvyVariableContainer)this.ivy.getVariableContainer().clone();
                    try {
                        String propFilePath = (String)attributes.get("file");
                        URL settingsURL = null;
                        if (propFilePath == null) {
                            propFilePath = (String)attributes.get("url");
                            if (propFilePath == null) {
                                Message.error("bad include tag: specify file or url to include");
                                return;
                            }
                            Message.verbose("including url: " + propFilePath);
                            settingsURL = new URL(propFilePath);
                            this.ivy.setSettingsVariables(settingsURL);
                        } else {
                            File incFile = new File(propFilePath);
                            if (!incFile.exists()) {
                                Message.error("impossible to include " + incFile + ": file does not exist");
                                return;
                            }
                            Message.verbose("including file: " + propFilePath);
                            this.ivy.setSettingsVariables(incFile);
                            settingsURL = incFile.toURI().toURL();
                        }
                        new XmlSettingsParser(this.ivy).parse(this.configurator, settingsURL);
                        break block78;
                    }
                    finally {
                        this.ivy.setVariableContainer(variables);
                    }
                }
                if ("settings".equals(qName) || "conf".equals(qName)) {
                    String cacheArtPattern;
                    String cacheIvyPattern;
                    String useRemoteConfig;
                    String up2d;
                    String validate;
                    String defaultBranch;
                    String cache;
                    if ("conf".equals(qName) && !this.deprecatedMessagePrinted) {
                        Message.deprecated("'conf' is deprecated, use 'settings' instead (" + this.settings + ")");
                    }
                    if ((cache = (String)attributes.get("defaultCache")) != null) {
                        Message.deprecated("'defaultCache' is deprecated, use 'caches[@defaultCacheDir]' instead (" + this.settings + ")");
                        this.ivy.setDefaultCache(new File(cache));
                    }
                    if ((defaultBranch = (String)attributes.get("defaultBranch")) != null) {
                        this.ivy.setDefaultBranch(defaultBranch);
                    }
                    if ((validate = (String)attributes.get("validate")) != null) {
                        this.ivy.setValidate(Boolean.valueOf(validate));
                    }
                    if ((up2d = (String)attributes.get("checkUpToDate")) != null) {
                        Message.deprecated("'checkUpToDate' is deprecated, use 'caches[@checkUpToDate]' instead (" + this.settings + ")");
                        this.ivy.setCheckUpToDate(Boolean.valueOf(up2d));
                    }
                    if ((useRemoteConfig = (String)attributes.get("useRemoteConfig")) != null) {
                        this.ivy.setUseRemoteConfig(Boolean.valueOf(useRemoteConfig));
                    }
                    if ((cacheIvyPattern = (String)attributes.get("cacheIvyPattern")) != null) {
                        Message.deprecated("'cacheIvyPattern' is deprecated, use 'caches[@ivyPattern]' instead (" + this.settings + ")");
                        this.ivy.setDefaultCacheIvyPattern(cacheIvyPattern);
                    }
                    if ((cacheArtPattern = (String)attributes.get("cacheArtifactPattern")) != null) {
                        Message.deprecated("'cacheArtifactPattern' is deprecated, use 'caches[@artifactPattern]' instead (" + this.settings + ")");
                        this.ivy.setDefaultCacheArtifactPattern(cacheArtPattern);
                    }
                    this.defaultResolver = (String)attributes.get("defaultResolver");
                    this.defaultCM = (String)attributes.get("defaultConflictManager");
                    this.defaultLatest = (String)attributes.get("defaultLatestStrategy");
                    this.defaultCircular = (String)attributes.get("circularDependencyStrategy");
                } else if ("caches".equals(qName)) {
                    String repositoryDir;
                    String cacheArtPattern;
                    String cacheIvyPattern;
                    String useOrigin;
                    String resolutionDir;
                    String up2d;
                    this.currentConfiguratorTag = qName;
                    this.configurator.setRoot(this.ivy);
                    this.defaultLock = (String)attributes.get("lockStrategy");
                    this.defaultCacheManager = (String)attributes.get("default");
                    String cache = (String)attributes.get("defaultCacheDir");
                    if (cache != null) {
                        this.ivy.setDefaultCache(new File(cache));
                    }
                    if ((up2d = (String)attributes.get("checkUpToDate")) != null) {
                        this.ivy.setCheckUpToDate(Boolean.valueOf(up2d));
                    }
                    if ((resolutionDir = (String)attributes.get("resolutionCacheDir")) != null) {
                        this.ivy.setDefaultResolutionCacheBasedir(resolutionDir);
                    }
                    if ((useOrigin = (String)attributes.get("useOrigin")) != null) {
                        this.ivy.setDefaultUseOrigin(Boolean.valueOf(useOrigin));
                    }
                    if ((cacheIvyPattern = (String)attributes.get("ivyPattern")) != null) {
                        this.ivy.setDefaultCacheIvyPattern(cacheIvyPattern);
                    }
                    if ((cacheArtPattern = (String)attributes.get("artifactPattern")) != null) {
                        this.ivy.setDefaultCacheArtifactPattern(cacheArtPattern);
                    }
                    if ((repositoryDir = (String)attributes.get("repositoryCacheDir")) != null) {
                        this.ivy.setDefaultRepositoryCacheBasedir(repositoryDir);
                    }
                } else if ("version-matchers".equals(qName)) {
                    this.currentConfiguratorTag = qName;
                    this.configurator.setRoot(this.ivy);
                    if ("true".equals((String)attributes.get("usedefaults"))) {
                        this.ivy.configureDefaultVersionMatcher();
                    }
                } else if ("statuses".equals(qName)) {
                    this.currentConfiguratorTag = qName;
                    StatusManager m = new StatusManager();
                    String defaultStatus = (String)attributes.get("default");
                    if (defaultStatus != null) {
                        m.setDefaultStatus(defaultStatus);
                    }
                    this.ivy.setStatusManager(m);
                    this.configurator.setRoot(m);
                } else if (this.configuratorTags.contains(qName)) {
                    this.currentConfiguratorTag = qName;
                    this.configurator.setRoot(this.ivy);
                } else if ("macrodef".equals(qName)) {
                    this.currentConfiguratorTag = qName;
                    Configurator.MacroDef macrodef = this.configurator.startMacroDef((String)attributes.get("name"));
                    macrodef.addAttribute("name", null);
                } else if ("module".equals(qName)) {
                    attributes.put("module", (String)attributes.remove("name"));
                    String resolver = (String)attributes.remove("resolver");
                    String branch = (String)attributes.remove("branch");
                    String cm = (String)attributes.remove("conflict-manager");
                    String matcher = (String)attributes.remove("matcher");
                    matcher = matcher == null ? "exactOrRegexp" : matcher;
                    this.ivy.addModuleConfiguration(attributes, this.ivy.getMatcher(matcher), resolver, branch, cm);
                }
            }
            catch (ParseException ex) {
                throw new SAXException("problem in config file: " + ex.getMessage(), ex);
            }
            catch (IOException ex) {
                throw new SAXException("io problem while parsing config file: " + ex.getMessage(), ex);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.configurator.getCurrent() != null) {
            if (this.configuratorTags.contains(qName) && this.configurator.getDepth() == 1) {
                this.configurator.clear();
                this.currentConfiguratorTag = null;
            } else if ("macrodef".equals(qName) && this.configurator.getDepth() == 1) {
                this.configurator.endMacroDef();
                this.currentConfiguratorTag = null;
            } else {
                this.configurator.endCreateChild();
            }
        }
    }

    public void endDocument() throws SAXException {
        Object strategy;
        if (this.defaultResolver != null) {
            this.ivy.setDefaultResolver(this.ivy.substitute(this.defaultResolver));
        }
        if (this.defaultCM != null) {
            ConflictManager conflictManager = this.ivy.getConflictManager(this.defaultCM);
            if (conflictManager == null) {
                throw new IllegalArgumentException("unknown conflict manager " + this.ivy.substitute(this.defaultCM));
            }
            this.ivy.setDefaultConflictManager(conflictManager);
        }
        if (this.defaultLatest != null) {
            LatestStrategy latestStrategy = this.ivy.getLatestStrategy(this.ivy.substitute(this.defaultLatest));
            if (latestStrategy == null) {
                throw new IllegalArgumentException("unknown latest strategy " + this.ivy.substitute(this.defaultLatest));
            }
            this.ivy.setDefaultLatestStrategy(latestStrategy);
        }
        if (this.defaultCacheManager != null) {
            RepositoryCacheManager cache = this.ivy.getRepositoryCacheManager(this.ivy.substitute(this.defaultCacheManager));
            if (cache == null) {
                throw new IllegalArgumentException("unknown cache manager " + this.ivy.substitute(this.defaultCacheManager));
            }
            this.ivy.setDefaultRepositoryCacheManager(cache);
        }
        if (this.defaultCircular != null) {
            strategy = this.ivy.getCircularDependencyStrategy(this.ivy.substitute(this.defaultCircular));
            if (strategy == null) {
                throw new IllegalArgumentException("unknown circular dependency strategy " + this.ivy.substitute(this.defaultCircular));
            }
            this.ivy.setCircularDependencyStrategy((CircularDependencyStrategy)strategy);
        }
        if (this.defaultLock != null) {
            strategy = this.ivy.getLockStrategy(this.ivy.substitute(this.defaultLock));
            if (strategy == null) {
                throw new IllegalArgumentException("unknown lock strategy " + this.ivy.substitute(this.defaultLock));
            }
            this.ivy.setDefaultLockStrategy((LockStrategy)strategy);
        }
    }
}

