/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.taskdefs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;

public class PythonTask
extends Task {
    private static final String TEMPFILE_PROPERTY = "python.script.tempfile";
    private String iText;
    private String outputProperty;
    private String resultProperty;
    private String script;
    private File dir;
    private File output;
    private boolean iFailonerror;
    private Commandline cmdl = new Commandline();

    public PythonTask() {
        this.setTaskName("python");
    }

    public void setOutputProperty(String propertyname) {
        this.outputProperty = propertyname;
    }

    public void setResultProperty(String propertyname) {
        this.resultProperty = propertyname;
    }

    public void addText(String text) {
        this.iText = this.getProject().replaceProperties(text);
    }

    public void setScript(String scriptname) {
        this.script = scriptname;
    }

    public void setFailonerror(boolean failonerror) {
        this.iFailonerror = failonerror;
    }

    public void setOutput(File outputname) {
        this.output = outputname;
    }

    public void setDir(File dirname) {
        this.dir = dirname;
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.script != null) {
            ExecTask execTask = new ExecTask();
            execTask.setProject(this.getProject());
            execTask.setTaskName("python");
            execTask.setExecutable("python");
            execTask.setFailonerror(true);
            Commandline.Argument scriptArg = this.cmdl.createArgument(true);
            scriptArg.setValue(this.script);
            execTask.setCommand(this.cmdl);
            execTask.setOutputproperty(this.outputProperty);
            execTask.setResultProperty(this.resultProperty);
            execTask.setDir(this.dir);
            execTask.setOutput(this.output);
            try {
                execTask.execute();
            }
            catch (BuildException t) {
                if (this.iFailonerror) {
                    throw new BuildException(t.getMessage());
                }
                this.log(t.getMessage(), 0);
            }
        } else {
            File tempfile = null;
            try {
                tempfile = File.createTempFile("helium", null);
                PrintWriter out = new PrintWriter(new FileWriter(tempfile));
                out.write(this.iText);
                out.close();
                ExecTask execTask = new ExecTask();
                execTask.setProject(this.getProject());
                execTask.setTaskName("python");
                execTask.setExecutable("python");
                execTask.setFailonerror(this.iFailonerror);
                Commandline.Argument scriptArg = execTask.createArg();
                scriptArg.setValue(tempfile.getAbsolutePath());
                execTask.setOutputproperty(this.outputProperty);
                execTask.setResultProperty(this.resultProperty);
                execTask.setDir(this.dir);
                execTask.setOutput(this.output);
                execTask.execute();
                boolean fileDeleted = tempfile.delete();
                if (!fileDeleted && this.iFailonerror) {
                    throw new BuildException("Could not delete script file!");
                }
            }
            catch (IOException e) {
                if (this.iFailonerror) {
                    throw new BuildException(e.getMessage());
                }
                this.log("Error while running python task " + e.getMessage());
            }
            finally {
                if (tempfile != null) {
                    tempfile.delete();
                }
            }
        }
    }
}

