/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.taskdefs;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class AntDependencyTask
extends Task {
    private ArrayList antFileSetList = new ArrayList();
    private String outputFile;

    public AntDependencyTask() {
        this.setTaskName("AntDependencyTask");
    }

    public void addFileset(FileSet set) {
        this.antFileSetList.add(set);
    }

    public void setOutputFile(String path) {
        this.outputFile = path;
    }

    public String classToJar(Class aclass) {
        String name = aclass.getName().replace(".", "/") + ".class";
        for (FileSet fs : this.antFileSetList) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            String[] srcFiles = ds.getIncludedFiles();
            String basedir = ds.getBasedir().getPath();
            for (int i = 0; i < srcFiles.length; ++i) {
                String fileName = basedir + File.separator + srcFiles[i];
                try {
                    JarFile jar = new JarFile(fileName);
                    if (jar.getJarEntry(name) == null) continue;
                    return fileName;
                }
                catch (IOException e) {
                    this.log(e.getMessage(), 4);
                }
            }
        }
        this.log(name + " not found", 4);
        return null;
    }

    public String getJarAttr(JarFile jar, String nameOfAttr) {
        try {
            String attr = jar.getManifest().getMainAttributes().getValue(nameOfAttr);
            if (attr != null) {
                return attr;
            }
            Manifest manifest = jar.getManifest();
            Map<String, Attributes> map = manifest.getEntries();
            for (String entryName : map.keySet()) {
                Attributes attrs = map.get(entryName);
                for (Attributes.Name name : attrs.keySet()) {
                    if (name.toString() != nameOfAttr) continue;
                    return attrs.getValue(name).replace("\"", "");
                }
            }
        }
        catch (IOException e) {
            this.log("Not able to get the JAR file attribute information. " + e.getMessage(), 4);
        }
        return null;
    }

    public HashSet<String> getJarInfo() {
        HashSet<String> classlist = new HashSet<String>();
        for (FileSet fs : this.antFileSetList) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            String[] srcFiles = ds.getIncludedFiles();
            String basedir = ds.getBasedir().getPath();
            for (int i = 0; i < srcFiles.length; ++i) {
                String fileName = basedir + File.separator + srcFiles[i];
                try {
                    String name;
                    JarFile jar = new JarFile(fileName);
                    String vendor = this.getJarAttr(jar, "Implementation-Vendor");
                    String version = this.getJarAttr(jar, "Implementation-Version");
                    if (version == null) {
                        version = this.getJarAttr(jar, "Specification-Version");
                    }
                    String nameandversion = name = this.convertJarName(fileName);
                    if (version != null) {
                        version = version.replace("$", "");
                        if (!this.digitInString(name)) {
                            nameandversion = name + " " + version;
                        }
                    }
                    if (vendor == null) {
                        vendor = "";
                    }
                    classlist.add(name + " [style=filled,shape=record,label=\"" + nameandversion + "|" + vendor + "\"];");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return classlist;
    }

    public void findLicense(String name, JarFile jar) {
        block10: {
            try {
                ZipEntry entry = jar.getEntry("META-INF/LICENSE");
                if (entry == null) {
                    entry = jar.getEntry("META-INF/LICENSE.txt");
                }
                if (entry != null) {
                    this.log("File in " + name + " in jar file ", 4);
                    byte[] data = new byte[1024];
                    jar.getInputStream(entry).read(data);
                    for (String line : new String(data).split("\n")) {
                        if (!line.contains("License") && !line.contains("LICENSE ") && !line.contains("Copyright")) continue;
                        this.log("Replace License information with * " + line.replace("*", "").trim(), 2);
                        break block10;
                    }
                    break block10;
                }
                String mavenUrl = "http://repo2.maven.org/maven2/";
                Enumeration<JarEntry> jarfiles = jar.entries();
                boolean found = false;
                block3: while (!found && jarfiles.hasMoreElements()) {
                    ZipEntry file = jarfiles.nextElement();
                    if (!file.isDirectory()) continue;
                    String filename = file.getName();
                    String[] split = file.getName().split("/");
                    String end = split[split.length - 1];
                    String specialfilename = filename + end;
                    URL url = new URL(mavenUrl + filename + end + "/maven-metadata.xml");
                    if (end.equals("apache")) continue;
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    if (connection.getResponseCode() != 200) {
                        filename = filename.replace(end, name.replace(".jar", ""));
                        end = name.replace(".jar", "");
                        specialfilename = filename;
                        url = new URL(mavenUrl + filename + "maven-metadata.xml");
                        connection = (HttpURLConnection)url.openConnection();
                    }
                    if (connection.getResponseCode() != 200) continue;
                    SAXReader xmlReader = new SAXReader();
                    Document antDoc = xmlReader.read(url.openStream());
                    List versions = antDoc.selectNodes("//versioning/versions/version");
                    Collections.reverse(versions);
                    for (Object tmpversion : versions) {
                        String version = ((Element)tmpversion).getText();
                        URL url2 = new URL(mavenUrl + specialfilename + "/" + version + "/" + end + "-" + version + ".pom");
                        HttpURLConnection connection2 = (HttpURLConnection)url2.openConnection();
                        if (connection2.getResponseCode() != 200) continue;
                        DataInputStream din = new DataInputStream(url2.openStream());
                        StringBuffer sb = new StringBuffer();
                        String line = null;
                        while ((line = din.readLine()) != null) {
                            line = line.replace("xmlns=\"http://maven.apache.org/POM/4.0.0\"", "");
                            sb.append(line + "\n");
                        }
                        xmlReader = new SAXReader();
                        Document antDoc2 = xmlReader.read((InputStream)new ByteArrayInputStream(new String(sb).getBytes()));
                        String license = antDoc2.valueOf("/project/licenses/license/name");
                        if (license.equals("")) continue;
                        found = true;
                        continue block3;
                    }
                }
                if (!found) {
                    this.log(name + " not found in " + jar, 2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean digitInString(String s) {
        int j = s.length() - 1;
        return j >= 0 && Character.isDigit(s.charAt(j));
    }

    public String convertJarName(String jar) {
        return new File(jar).getName().replace(".jar", "").replace("-", "_").replace(".", "_");
    }

    public final void execute() {
        try {
            Project project = this.getProject();
            Hashtable taskdefs = project.getTaskDefinitions();
            HashSet<String> classlist = new HashSet<String>();
            Enumeration taskdefsenum = taskdefs.keys();
            while (taskdefsenum.hasMoreElements()) {
                String key = (String)taskdefsenum.nextElement();
                Class value = (Class)taskdefs.get(key);
                if (key.contains("nokia") || value.toString().contains("org.apache.tools.ant")) continue;
                String name = value.getPackage().getName();
                String vendor = value.getPackage().getImplementationVendor();
                name = this.classToJar(value);
                if (name == null) continue;
                name = this.convertJarName(name);
                classlist.add("helium_ant -> \"" + name + "\";");
                if (vendor == null) {
                    vendor = "";
                }
                classlist.add(name + " [style=filled,shape=record,label=\"" + name + "|" + vendor + "\"];");
            }
            classlist.add("helium_ant -> nokia_ant;");
            classlist.addAll(this.getJarInfo());
            BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF8"));
            for (String value : classlist) {
                output.write(value + "\n");
            }
            ((Writer)output).close();
        }
        catch (Exception e) {
            this.log("Exception occured while getting the ANT task dependency information. " + e.getMessage(), 4);
        }
    }
}

