/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentHashSet<E>
extends AbstractSet<E>
implements Serializable {
    private final ConcurrentMap<E, Object> map;
    private transient Set<E> keySet;
    private static final Object PRESENT = new Object();

    public ConcurrentHashSet() {
        this.map = new ConcurrentHashMap<E, Object>();
        this.keySet = this.map.keySet();
    }

    public ConcurrentHashSet(int initialCapacity) {
        this.map = new ConcurrentHashMap<E, Object>(initialCapacity);
        this.keySet = this.map.keySet();
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.map = new ConcurrentHashMap<E, Object>(initialCapacity, loadFactor, concurrencyLevel);
        this.keySet = this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.keySet.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.keySet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.keySet.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.keySet.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.keySet.retainAll(c);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.keySet).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.keySet).hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.keySet = this.map.keySet();
    }
}

