/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFClassLoader;
import org.apache.bsf.util.BSFEventProcessor;
import org.apache.bsf.util.BSFEventProcessorReturningEventInfos;
import org.apache.bsf.util.Bean;
import org.apache.bsf.util.MethodUtils;
import org.apache.bsf.util.ReflectionUtils;

public class EngineUtils {
    static BSFClassLoader bsfCL;
    static boolean bMethodHasSetAccessible;
    static /* synthetic */ Class class$java$lang$reflect$Method;

    public static void addEventListener(Object bean, String eventSetName, String filter, BSFEngine engine, BSFManager manager, String source, int lineNo, int columnNo, Object script) throws BSFException {
        BSFEventProcessor ep = new BSFEventProcessor(engine, manager, filter, source, lineNo, columnNo, script);
        try {
            ReflectionUtils.addEventListener(bean, eventSetName, ep);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BSFException(500, "ouch while adding event listener: " + e, e);
        }
    }

    public static void addEventListenerReturningEventInfos(Object bean, String eventSetName, String filter, BSFEngine engine, BSFManager manager, String source, int lineNo, int columnNo, Object script, Object dataFromScriptingEngine) throws BSFException {
        BSFEventProcessorReturningEventInfos ep = new BSFEventProcessorReturningEventInfos(engine, manager, filter, source, lineNo, columnNo, script, dataFromScriptingEngine);
        try {
            ReflectionUtils.addEventListener(bean, eventSetName, ep);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BSFException(500, "ouch while adding event listener: " + e, e);
        }
    }

    public static Object callBeanMethod(Object bean, String methodName, Object[] args) throws BSFException {
        Class[] argTypes = null;
        if (args != null) {
            argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i] == null ? null : args[i].getClass();
            }
        }
        boolean isStaticOnly = false;
        Class<?> beanClass = bean instanceof Class ? (Class<?>)bean : bean.getClass();
        try {
            Method m;
            try {
                m = MethodUtils.getMethod(beanClass, methodName, argTypes, isStaticOnly);
            }
            catch (NoSuchMethodException e) {
                try {
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i] instanceof Number) {
                            if (args[i] instanceof Byte) {
                                argTypes[i] = Byte.TYPE;
                                continue;
                            }
                            if (args[i] instanceof Integer) {
                                argTypes[i] = Integer.TYPE;
                                continue;
                            }
                            if (args[i] instanceof Long) {
                                argTypes[i] = Long.TYPE;
                                continue;
                            }
                            if (args[i] instanceof Float) {
                                argTypes[i] = Float.TYPE;
                                continue;
                            }
                            if (args[i] instanceof Double) {
                                argTypes[i] = Double.TYPE;
                                continue;
                            }
                            if (!(args[i] instanceof Short)) continue;
                            argTypes[i] = Short.TYPE;
                            continue;
                        }
                        if (args[i] instanceof Boolean) {
                            argTypes[i] = Boolean.TYPE;
                            continue;
                        }
                        if (!(args[i] instanceof Character)) continue;
                        argTypes[i] = Character.TYPE;
                    }
                    m = MethodUtils.getMethod(beanClass, methodName, argTypes, isStaticOnly);
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            try {
                return m.invoke(bean, args);
            }
            catch (Exception e) {
                if (e instanceof IllegalAccessException && bMethodHasSetAccessible && Modifier.isPublic(m.getModifiers())) {
                    m.setAccessible(true);
                    return m.invoke(bean, args);
                }
                throw e;
            }
        }
        catch (Exception e) {
            Throwable t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : null;
            throw new BSFException(500, "method invocation failed: " + e + (t == null ? "" : " target exception: " + t), t);
        }
    }

    public static Object createBean(String className, Object[] args) throws BSFException {
        Class[] argTypes = null;
        if (args != null) {
            argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i] != null ? args[i].getClass() : null;
            }
        }
        try {
            try {
                Bean obj = ReflectionUtils.createBean(null, className, argTypes, args);
                return obj.value;
            }
            catch (NoSuchMethodException me) {
                try {
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i] instanceof Number) {
                            argTypes[i] = Byte.TYPE;
                            continue;
                        }
                        if (args[i] instanceof Boolean) {
                            argTypes[i] = Boolean.TYPE;
                            continue;
                        }
                        if (!(args[i] instanceof Character)) continue;
                        argTypes[i] = Character.TYPE;
                    }
                    Bean obj = ReflectionUtils.createBean(null, className, argTypes, args);
                    return obj.value;
                }
                catch (Exception e) {
                    throw me;
                }
            }
        }
        catch (Exception e) {
            throw new BSFException(500, e.getMessage(), e);
        }
    }

    public static String getTypeSignatureString(Class cl) {
        if (cl.isPrimitive()) {
            if (cl == Boolean.TYPE) {
                return "Z";
            }
            if (cl == Byte.TYPE) {
                return "B";
            }
            if (cl == Character.TYPE) {
                return "C";
            }
            if (cl == Short.TYPE) {
                return "S";
            }
            if (cl == Integer.TYPE) {
                return "I";
            }
            if (cl == Long.TYPE) {
                return "J";
            }
            if (cl == Float.TYPE) {
                return "F";
            }
            if (cl == Double.TYPE) {
                return "D";
            }
            return "V";
        }
        StringBuffer sb = new StringBuffer("L");
        sb.append(cl.getName());
        sb.append(";");
        return sb.toString().replace('.', '/');
    }

    public static Class loadClass(BSFManager mgr, String name) throws BSFException {
        ClassLoader classLoader = mgr.getClassLoader();
        try {
            return classLoader == null ? Thread.currentThread().getContextClassLoader().loadClass(name) : classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                if (bsfCL == null) {
                    bsfCL = new BSFClassLoader();
                }
                bsfCL.setTempDir(mgr.getTempDir());
                return bsfCL.loadClass(name);
            }
            catch (ClassNotFoundException e2) {
                throw new BSFException(500, "unable to load class '" + name + "':" + e, e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        bMethodHasSetAccessible = false;
        Class mc = class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = EngineUtils.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method;
        Class[] arg = new Class[]{Boolean.TYPE};
        try {
            mc.getMethod("setAccessible", arg);
            bMethodHasSetAccessible = true;
        }
        catch (Exception e) {
            bMethodHasSetAccessible = false;
        }
    }
}

