/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.report.IItemAttribute;
import java.util.Comparator;

public interface ItemComparator
extends Comparator {
    public static final ItemComparator NULL_COMPARATOR = new Factory.NullComparator();

    public static abstract class Factory {
        public static ItemComparator create(int[] attributeIDsWithDir, int unitsID) {
            if (attributeIDsWithDir == null) {
                throw new IllegalArgumentException("null input: attributeIDsWithDir");
            }
            if (attributeIDsWithDir.length == 0) {
                return NULL_COMPARATOR;
            }
            Comparator[] comparators = new Comparator[attributeIDsWithDir.length >> 1];
            for (int a = 0; a < attributeIDsWithDir.length; a += 2) {
                int attributeID = attributeIDsWithDir[a];
                Comparator comparator = IItemAttribute.Factory.getAttribute(attributeID, unitsID).comparator();
                comparators[a >> 1] = attributeIDsWithDir[a + 1] < 0 ? new ReverseComparator(comparator) : comparator;
            }
            return new CompositeComparator(comparators);
        }

        private static final class CompositeComparator
        implements ItemComparator {
            private final Comparator[] m_comparators;

            public int compare(Object l, Object g) {
                for (int c = 0; c < this.m_comparators.length; ++c) {
                    int diff = this.m_comparators[c].compare(l, g);
                    if (diff == 0) continue;
                    return diff;
                }
                return 0;
            }

            CompositeComparator(Comparator[] comparators) {
                this.m_comparators = comparators;
            }
        }

        private static final class ReverseComparator
        implements ItemComparator {
            private final Comparator m_comparator;

            public int compare(Object l, Object g) {
                return this.m_comparator.compare(g, l);
            }

            ReverseComparator(Comparator comparator) {
                this.m_comparator = comparator;
            }
        }

        private static final class NullComparator
        implements ItemComparator {
            private NullComparator() {
            }

            public int compare(Object l, Object g) {
                return 0;
            }
        }
    }
}

