/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.checks.AbstractCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.dom4j.Element;

public class CheckTargetName
extends AbstractCheck {
    @Override
    public void run(Element node) {
        if (node.getName().equals("target")) {
            String target = node.attributeValue("name");
            this.checkTargetName(target);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkTargetName(String targetName) {
        if (targetName != null && !targetName.isEmpty()) {
            try {
                Pattern p1 = Pattern.compile(this.getPattern());
                Matcher m1 = p1.matcher(targetName);
                if (m1.matches()) return;
                this.log("INVALID Target Name: " + targetName);
                return;
            }
            catch (Exception e) {
                throw new BuildException("Not able to match the target name for " + targetName);
            }
        } else {
            this.log("Target name not specified!");
        }
    }
}

