/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.install;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.ivy.core.install.InstallEngineSettings;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.publish.PublishEngine;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.search.SearchEngine;
import org.apache.ivy.plugins.conflict.NoConflictManager;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;

public class InstallEngine {
    private InstallEngineSettings settings;
    private ResolveEngine resolveEngine;
    private PublishEngine publishEngine;
    private SearchEngine searchEngine;

    public InstallEngine(InstallEngineSettings settings, SearchEngine searchEngine, ResolveEngine resolveEngine, PublishEngine publishEngine) {
        this.settings = settings;
        this.searchEngine = searchEngine;
        this.resolveEngine = resolveEngine;
        this.publishEngine = publishEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveReport install(ModuleRevisionId mrid, String from, String to, boolean transitive, boolean validate, boolean overwrite, Filter artifactFilter, String matcherName) throws IOException {
        if (artifactFilter == null) {
            artifactFilter = FilterHelper.NO_FILTER;
        }
        DependencyResolver fromResolver = this.settings.getResolver(from);
        DependencyResolver toResolver = this.settings.getResolver(to);
        if (fromResolver == null) {
            throw new IllegalArgumentException("unknown resolver " + from + ". Available resolvers are: " + this.settings.getResolverNames());
        }
        if (toResolver == null) {
            throw new IllegalArgumentException("unknown resolver " + to + ". Available resolvers are: " + this.settings.getResolverNames());
        }
        PatternMatcher matcher = this.settings.getMatcher(matcherName);
        if (matcher == null) {
            throw new IllegalArgumentException("unknown matcher " + matcherName + ". Available matchers are: " + this.settings.getMatcherNames());
        }
        Message.info(":: installing " + mrid + " ::");
        DependencyResolver oldDicator = this.resolveEngine.getDictatorResolver();
        boolean log = this.settings.logNotConvertedExclusionRule();
        try {
            this.settings.setLogNotConvertedExclusionRule(true);
            this.resolveEngine.setDictatorResolver(fromResolver);
            DefaultModuleDescriptor md = new DefaultModuleDescriptor(ModuleRevisionId.newInstance("apache", "ivy-install", "1.0"), this.settings.getStatusManager().getDefaultStatus(), new Date());
            String resolveId = ResolveOptions.getDefaultResolveId(md);
            md.addConfiguration(new Configuration("default"));
            md.addConflictManager(new ModuleId("*", "*"), ExactPatternMatcher.INSTANCE, new NoConflictManager());
            if (MatcherHelper.isExact(matcher, mrid)) {
                DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(md, mrid, false, false, transitive);
                dd.addDependencyConfiguration("default", "*");
                md.addDependency(dd);
            } else {
                Collection mrids = this.searchEngine.findModuleRevisionIds(fromResolver, mrid, matcher);
                Iterator iter = mrids.iterator();
                while (iter.hasNext()) {
                    ModuleRevisionId foundMrid = (ModuleRevisionId)iter.next();
                    Message.info("\tfound " + foundMrid + " to install: adding to the list");
                    DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(md, foundMrid, false, false, transitive);
                    dd.addDependencyConfiguration("default", "*");
                    md.addDependency(dd);
                }
            }
            ResolveReport report = new ResolveReport(md, resolveId);
            Message.info(":: resolving dependencies ::");
            ResolveOptions options = new ResolveOptions().setResolveId(resolveId).setConfs(new String[]{"default"}).setValidate(validate);
            IvyNode[] dependencies = this.resolveEngine.getDependencies(md, options, report);
            report.setDependencies(Arrays.asList(dependencies), artifactFilter);
            Message.info(":: downloading artifacts to cache ::");
            this.resolveEngine.downloadArtifacts(report, artifactFilter, new DownloadOptions());
            Message.info(":: installing in " + to + " ::");
            for (int i = 0; i < dependencies.length; ++i) {
                ModuleDescriptor depmd = dependencies[i].getDescriptor();
                if (depmd == null) continue;
                ModuleRevisionId depMrid = depmd.getModuleRevisionId();
                Message.verbose("installing " + depMrid);
                boolean successfullyPublished = false;
                try {
                    toResolver.beginPublishTransaction(depMrid, overwrite);
                    ArtifactDownloadReport[] artifacts = report.getArtifactsReports(depMrid);
                    for (int j = 0; j < artifacts.length; ++j) {
                        if (artifacts[j].getLocalFile() == null) continue;
                        toResolver.publish(artifacts[j].getArtifact(), artifacts[j].getLocalFile(), overwrite);
                    }
                    File localIvyFile = dependencies[i].getModuleRevision().getReport().getLocalFile();
                    toResolver.publish(depmd.getMetadataArtifact(), localIvyFile, overwrite);
                    toResolver.commitPublishTransaction();
                    successfullyPublished = true;
                    continue;
                }
                finally {
                    if (!successfullyPublished) {
                        toResolver.abortPublishTransaction();
                    }
                }
            }
            Message.info(":: install resolution report ::");
            this.resolveEngine.outputReport(report, this.settings.getResolutionCacheManager(), options);
            ResolveReport resolveReport = report;
            return resolveReport;
        }
        finally {
            this.resolveEngine.setDictatorResolver(oldDicator);
            this.settings.setLogNotConvertedExclusionRule(log);
        }
    }
}

