/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.checktools;

import com.nokia.helium.checktools.CheckToolException;
import java.util.Locale;

public final class OSResolver {
    public static final String FAMILY_WINDOWS = "windows";
    public static final String FAMILY_9X = "win9x";
    public static final String FAMILY_NT = "winnt";
    public static final String FAMILY_MAC = "mac";
    public static final String FAMILY_UNIX = "unix";
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String PATH_SEP = System.getProperty("path.separator");

    private OSResolver() {
    }

    public static String getCommand(String cmd) {
        StringBuffer buffer = new StringBuffer();
        if (OSResolver.isOs(FAMILY_WINDOWS)) {
            if (!OSResolver.isOs(FAMILY_9X)) {
                buffer.append("cmd /c ");
            } else {
                buffer.append("command /c ");
            }
        }
        buffer.append(cmd);
        return buffer.toString();
    }

    public static boolean isOs(String family) {
        boolean retValue = false;
        if (family != null) {
            boolean isWindows = OS_NAME.indexOf(FAMILY_WINDOWS) > -1;
            boolean is9x = false;
            boolean isNT = false;
            if (isWindows) {
                is9x = OS_NAME.indexOf("95") >= 0 || OS_NAME.indexOf("98") >= 0 || OS_NAME.indexOf("me") >= 0 || OS_NAME.indexOf("ce") >= 0;
                boolean bl = isNT = !is9x;
            }
            if (family.equals(FAMILY_WINDOWS)) {
                retValue = isWindows;
            } else if (family.equals(FAMILY_9X)) {
                retValue = isWindows && is9x;
            } else if (family.equals(FAMILY_NT)) {
                retValue = isWindows && isNT;
            } else if (family.equals(FAMILY_MAC)) {
                retValue = OS_NAME.indexOf(FAMILY_MAC) > -1;
            } else if (family.equals(FAMILY_UNIX)) {
                retValue = PATH_SEP.equals(":") && (!OSResolver.isOs(FAMILY_MAC) || OS_NAME.endsWith("x"));
            } else {
                throw new CheckToolException("Don't know how to detect os family \"" + family + "\"");
            }
        }
        return retValue;
    }
}

