/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;

class JavadocTag {
    private final int mLineNo;
    private int mColumnNo;
    private final String mArg1;
    private final JavadocTagInfo mTagInfo;

    JavadocTag(int aLine, int aColumn, String aTag, String aArg1) {
        this.mLineNo = aLine;
        this.mColumnNo = aColumn;
        this.mArg1 = aArg1;
        this.mTagInfo = JavadocTagInfo.fromName(aTag);
    }

    JavadocTag(int aLine, int aColumn, String aTag) {
        this(aLine, aColumn, aTag, null);
    }

    String getTagName() {
        return this.mTagInfo.getName();
    }

    String getArg1() {
        return this.mArg1;
    }

    int getLineNo() {
        return this.mLineNo;
    }

    int getColumnNo() {
        return this.mColumnNo;
    }

    public String toString() {
        return "{Tag = '" + this.getTagName() + "', lineNo = " + this.getLineNo() + ", columnNo=" + this.mColumnNo + ", Arg1 = '" + this.getArg1() + "'}";
    }

    boolean isAuthorTag() {
        return JavadocTagInfo.AUTHOR.equals((Object)this.mTagInfo);
    }

    boolean isReturnTag() {
        return JavadocTagInfo.RETURN.equals((Object)this.mTagInfo);
    }

    boolean isParamTag() {
        return JavadocTagInfo.PARAM.equals((Object)this.mTagInfo);
    }

    boolean isThrowsTag() {
        return JavadocTagInfo.THROWS.equals((Object)this.mTagInfo) || JavadocTagInfo.EXCEPTION.equals((Object)this.mTagInfo);
    }

    boolean isSeeOrInheritDocTag() {
        return JavadocTagInfo.SEE.equals((Object)this.mTagInfo) || this.isInheritDocTag();
    }

    boolean isInheritDocTag() {
        return JavadocTagInfo.INHERIT_DOC.equals((Object)this.mTagInfo);
    }
}

