/*
* Copyright (c) 2007-2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  
*
*/
package com.nokia.helium.imaker.tests;

import static org.junit.Assert.assertArrayEquals;

import java.io.File;

import org.junit.Test;

import com.nokia.helium.imaker.HelpConfigStreamConsumer;

/**
 * Test the HelpTargetStreamConsumer.
 *
 */
public class TestHelpConfigStreamConsumer {

    /**
     * Checking if the consumer is parsing correctly the output. 
     */
    @Test
    public void introspectConfiguration() {
        HelpConfigStreamConsumer consumer = new HelpConfigStreamConsumer();
        consumer.consumeLine("iMaker 09.24.01, 10-Jun-2009.");
        consumer.consumeLine("Finding available configuration file(s):");
        consumer.consumeLine("/epoc32/rom/config/platform/product/image_conf_product.mk");
        consumer.consumeLine("/epoc32/rom/config/platform/product/image_conf_product_ui.mk");
        consumer.consumeLine("X:/epoc32/rom/config/platform/product/image_conf_product.mk");
        consumer.consumeLine("X:/epoc32/rom/config/platform/product/image_conf_product_ui.mk");
        consumer.consumeLine("");
        
        // Verifying string output
        String[] expected = new String[4];
        expected[0] = "/epoc32/rom/config/platform/product/image_conf_product.mk";
        expected[1] = "/epoc32/rom/config/platform/product/image_conf_product_ui.mk";
        expected[2] = "X:/epoc32/rom/config/platform/product/image_conf_product.mk";
        expected[3] = "X:/epoc32/rom/config/platform/product/image_conf_product_ui.mk";
        assertArrayEquals(expected, consumer.getConfigurations().toArray(new String[4]));

        // Verifying the file output
        File[] expectedFile = new File[4];
        if (new File("/epoc32/rom/config/platform/product/image_conf_product.mk").isAbsolute()) {
            // Unix like os
            expectedFile[0] = new File("/epoc32/rom/config/platform/product/image_conf_product.mk");
            expectedFile[1] = new File("/epoc32/rom/config/platform/product/image_conf_product_ui.mk");
            expectedFile[2] = new File(new File("."), "X:/epoc32/rom/config/platform/product/image_conf_product.mk");
            expectedFile[3] = new File(new File("."), "X:/epoc32/rom/config/platform/product/image_conf_product_ui.mk");
        } else {
            // Windows like os
            expectedFile[0] = new File(new File("."), "/epoc32/rom/config/platform/product/image_conf_product.mk");
            expectedFile[1] = new File(new File("."), "/epoc32/rom/config/platform/product/image_conf_product_ui.mk");
            expectedFile[2] = new File("X:/epoc32/rom/config/platform/product/image_conf_product.mk");
            expectedFile[3] = new File("X:/epoc32/rom/config/platform/product/image_conf_product_ui.mk");
        }
        assertArrayEquals(expectedFile, consumer.getConfigurations(new File(".")).toArray(new File[4]));
    }
}

