/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api.creator;

import info.bliki.api.creator.ImageData;
import info.bliki.api.creator.TopicData;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;

public class WikiDB {
    private final PreparedStatement fSelectContent;
    private final PreparedStatement fInsertTopic;
    private final PreparedStatement fUpdateTopicContent;
    private final PreparedStatement fSelectImage;
    private final PreparedStatement fInsertImage;
    private static PreparedStatement fUpdateImage;
    private Connection fConnection;

    public WikiDB(String directory, String databasename) throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        Properties properties = new Properties();
        properties.put("user", "user1");
        properties.put("password", "user1");
        String jdbcUrl = directory.charAt(directory.length() - 1) == '/' ? "jdbc:derby:" + directory + databasename + ";create=true" : "jdbc:derby:" + directory + "/" + databasename + ";create=true";
        this.fConnection = DriverManager.getConnection(jdbcUrl, properties);
        this.createTableIfItDoesntExist();
        this.fSelectContent = this.fConnection.prepareStatement("SELECT version_content FROM topic WHERE topic_name = ?");
        this.fInsertTopic = this.fConnection.prepareStatement("INSERT INTO topic (topic_name, version_content) VALUES (?,?)");
        this.fUpdateTopicContent = this.fConnection.prepareStatement("UPDATE topic SET version_content = ?  WHERE topic_name = ?");
        this.fSelectImage = this.fConnection.prepareStatement("SELECT image_url, image_filename FROM image WHERE image_name = ?");
        this.fInsertImage = this.fConnection.prepareStatement("INSERT INTO image (image_name, image_url, image_filename) VALUES (?,?, ?)");
        fUpdateImage = this.fConnection.prepareStatement("UPDATE image SET image_url = ?,  image_filename = ? WHERE image_name = ?");
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
        this.fSelectContent.close();
        this.fInsertTopic.close();
        this.fUpdateTopicContent.close();
        this.fSelectImage.close();
        this.fInsertImage.close();
        fUpdateImage.close();
        this.fConnection.close();
    }

    public TopicData selectTopic(String name) throws Exception {
        TopicData topicData = new TopicData(name);
        this.fSelectContent.setString(1, name);
        ResultSet resultSet = this.fSelectContent.executeQuery();
        try {
            if (resultSet.next()) {
                topicData.setContent(resultSet.getString(1));
                TopicData topicData2 = topicData;
                return topicData2;
            }
        }
        finally {
            resultSet.close();
        }
        return null;
    }

    public void insertTopic(TopicData topic) throws Exception {
        this.fInsertTopic.setString(1, topic.getName());
        this.fInsertTopic.setString(2, topic.getContent());
        this.fInsertTopic.execute();
    }

    public void updateTopic(TopicData topic) throws Exception {
        this.fUpdateTopicContent.setString(1, topic.getContent());
        this.fUpdateTopicContent.setString(2, topic.getName());
        this.fUpdateTopicContent.execute();
    }

    public ImageData selectImage(String imageName) throws Exception {
        ImageData imageData = new ImageData(imageName);
        this.fSelectImage.setString(1, imageName);
        ResultSet resultSet = this.fSelectImage.executeQuery();
        try {
            if (resultSet.next()) {
                imageData.setUrl(resultSet.getString(1));
                imageData.setFilename(resultSet.getString(2));
                ImageData imageData2 = imageData;
                return imageData2;
            }
        }
        finally {
            resultSet.close();
        }
        return null;
    }

    public void insertImage(ImageData imageData) throws Exception {
        this.fInsertImage.setString(1, imageData.getName());
        this.fInsertImage.setString(2, imageData.getUrl());
        this.fInsertImage.setString(3, imageData.getFilename());
        this.fInsertImage.execute();
    }

    public void updateImage(ImageData imageData) throws Exception {
        this.fUpdateTopicContent.setString(1, imageData.getUrl());
        this.fUpdateTopicContent.setString(2, imageData.getFilename());
        this.fUpdateTopicContent.setString(3, imageData.getName());
        this.fUpdateTopicContent.execute();
    }

    private void createTableIfItDoesntExist() throws Exception {
        Statement statement;
        ResultSet resultSet = this.fConnection.getMetaData().getTables("%", "%", "%", new String[]{"TABLE"});
        boolean shouldCreateTableTopic = true;
        boolean shouldCreateTableImage = true;
        String tableName = null;
        while (resultSet.next() && shouldCreateTableTopic) {
            tableName = resultSet.getString("TABLE_NAME");
            if (tableName.equalsIgnoreCase("topic")) {
                shouldCreateTableTopic = false;
                continue;
            }
            if (!tableName.equalsIgnoreCase("image")) continue;
            shouldCreateTableImage = false;
        }
        resultSet.close();
        if (shouldCreateTableTopic) {
            System.out.println("Creating Table topic...");
            statement = this.fConnection.createStatement();
            statement.execute("CREATE TABLE topic (topic_id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), topic_name VARCHAR(256) NOT NULL,  version_content CLOB,  CONSTRAINT PK_Topic PRIMARY KEY (topic_id)  ) ");
            statement.execute("CREATE INDEX indx_topic ON topic(topic_name)");
            statement.close();
        }
        if (shouldCreateTableImage) {
            System.out.println("Creating Table image...");
            statement = this.fConnection.createStatement();
            statement.execute("CREATE TABLE image (image_id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), image_name VARCHAR(256) NOT NULL,  image_url VARCHAR(1024) NOT NULL,  image_filename VARCHAR(1024) NOT NULL,  CONSTRAINT PK_Image PRIMARY KEY (image_id)  ) ");
            statement.execute("CREATE INDEX indx_image ON image(image_name)");
            statement.close();
        }
    }
}

