/*
 * Decompiled with CFR 0.152.
 */
package se.jtech.ant.xpath;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import se.jtech.ant.xpath.Namespace;
import se.jtech.ant.xpath.Xpath;
import se.jtech.xml.ConfigurableNamespaceContext;

public final class XPathEvaluatorTask
extends Task {
    private File xmlFile;
    private ConfigurableNamespaceContext namespaceContext = null;
    private List xpaths = null;

    public void setXmlFile(File xmlFile) {
        this.xmlFile = xmlFile;
        this.log("Set XML file: " + xmlFile.getAbsolutePath());
    }

    public synchronized void addConfiguredXpath(Xpath xpath) {
        if (this.xpaths == null) {
            this.xpaths = new ArrayList();
        }
        this.xpaths.add(xpath);
    }

    public synchronized void addConfiguredNamespace(Namespace namespace) {
        if (this.namespaceContext == null) {
            this.namespaceContext = new ConfigurableNamespaceContext();
        }
        this.namespaceContext.addNamespace(namespace.getUri(), namespace.getPrefix());
        this.log("Added namespace: uri='" + namespace.getUri() + "'; prefix='" + namespace.getPrefix() + "'");
    }

    public void execute() throws BuildException {
        Document xmlDoc;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setValidating(false);
        docFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            xmlDoc = builder.parse(this.xmlFile);
        }
        catch (Exception e) {
            throw new BuildException("Could not parse XML file '" + this.xmlFile.getAbsolutePath() + "'.", (Throwable)e);
        }
        this.log("Parsed XML file: " + this.xmlFile.getAbsolutePath());
        XPathFactory xpathFactory = XPathFactory.newInstance();
        this.log("Evaluating " + this.xpaths.size() + " XPath(s)...");
        Iterator i = this.xpaths.iterator();
        while (i.hasNext()) {
            Boolean valid;
            Xpath xpath = (Xpath)i.next();
            XPath xp = xpathFactory.newXPath();
            xp.setNamespaceContext(this.namespaceContext);
            this.log("Evaluting XPath '" + xpath + "'...");
            try {
                valid = (Boolean)xp.evaluate(xpath.getExpression(), xmlDoc, XPathConstants.BOOLEAN);
            }
            catch (XPathExpressionException e) {
                throw new BuildException("Could not evaluate XPath '" + xpath + "'.", (Throwable)e);
            }
            if (valid.booleanValue()) continue;
            throw new BuildException("XPath '" + xpath + "' did not evaluate to 'true'.");
        }
    }
}

