#! /usr/bin/env bash
# This file contains the complete sequence of commands
# CodeSourcery used to build this version of Sourcery G++.
# 
# For each free or open-source component of Sourcery G++, the
# source code provided includes all of the configuration
# scripts and makefiles for that component, including any and
# all modifications made by CodeSourcery.  From this list of
# commands, you can see every configuration option used by
# CodeSourcery during the build process.
# 
# This file is provided as a guideline for users who wish to
# modify and rebuild a free or open-source component of
# Sourcery G++ from source. For a number of reasons, though,
# you may not be able to successfully run this script directly
# on your system. Certain aspects of the CodeSourcery build
# environment (such as directory names) are included in these
# commands. CodeSourcery uses Canadian cross compilers so you
# may need to modify various configuration options and paths
# if you are building natively. This sequence of commands
# includes those used to build proprietary components of
# Sourcery G++ for which source code is not provided.
# 
# Please note that Sourcery G++ support covers only your use
# of the original, validated binaries provided as part of
# Sourcery G++ -- and specifically does not cover either the
# process of rebuilding a component or the use of any binaries
# you may build.  In addition, if you rebuild any component,
# you must not use the --with-pkgversion and --with-bugurl
# configuration options that embed CodeSourcery trademarks in
# the resulting binary; see the "CodeSourcery Trademarks"
# section in the Sourcery G++ Software License Agreement.
set -e
inform_fd=2 
exec < /dev/null

check_status() {
    local status="$?"
    if [ "$status" -ne 0 ]; then
	return "$status"
    fi
}

check_pipe() {
    local -a status=("${PIPESTATUS[@]}")
    local limit=$1
    local ix
    
    if [ -z "$limit" ] ; then
	limit="${#status[@]}"
    fi
    for ((ix=0; ix != $limit ; ix++)); do
	if [ "${status[$ix]}" != "0" ] ; then
	    return "${status[$ix]}"
	fi
    done
}

error () {
    echo "$script: error: $@" >& $inform_fd
    exit 1
}

warning () {
    echo "$script: warning: $@" >& $inform_fd
}

verbose () {
    if $gnu_verbose; then
	echo "$script: $@" >& $inform_fd
    fi
}

copy_dir() {
    mkdir -p "$2"

    (cd "$1" && tar cf - .) | (cd "$2" && tar xf -)
    check_pipe
}

copy_dir_clean() {
    mkdir -p "$2"
    (cd "$1" && tar cf - \
	--exclude=CVS --exclude=.svn --exclude=.pc \
	--exclude="*~" --exclude=".#*" \
	--exclude="*.orig" --exclude="*.rej" \
	.) | (cd "$2" && tar xf -)
    check_pipe
}

update_dir_clean() {
    mkdir -p "$2"


    (cd "$1" && tar cf - \
	--exclude=CVS --exclude=.svn --exclude=.pc \
	--exclude="*~" --exclude=".#*" \
	--exclude="*.orig" --exclude="*.rej" \
	--after-date="$3" \
	. 2> /dev/null) | (cd "$2" && tar xf -)
    check_pipe
}

copy_dir_exclude() {
    local source="$1"
    local dest="$2"
    local excl="$3"
    shift 3
    mkdir -p "$dest"
    (cd "$source" && tar cfX - "$excl" "$@") | (cd "$dest" && tar xf -)
    check_pipe
}

copy_dir_only() {
    local source="$1"
    local dest="$2"
    shift 2
    mkdir -p "$dest"
    (cd "$source" && tar cf - "$@") | (cd "$dest" && tar xf -)
    check_pipe
}

clean_environment() {
    local env_var_list
    local var




    unset BASH_ENV CDPATH POSIXLY_CORRECT TMOUT

    env_var_list=$(export | \
	grep '^declare -x ' | \
	sed -e 's/^declare -x //' -e 's/=.*//')

    for var in $env_var_list; do
	case $var in
	    CSL_SCRIPTDIR|HOME|LOGNAME|PWD|SHELL|SHLVL|SSH_*|TERM|USER)


		;;
	    LD_LIBRARY_PATH|PATH| \
		QMTEST_CLASS_PATH| \
		FLEXLM_NO_CKOUT_INSTALL_LIC|LM_APP_DISABLE_CACHE_READ)


		;;
	    *_LICENSE_FILE)












		if [ "" ]; then
		    local license_file_envvar
		    license_file_envvar=

		    if [ "$var" != "$license_file_envvar" ]; then
			export -n "$var" || true
		    fi
		else
		    export -n "$var" || true
		fi
		;;
	    *)

		export -n "$var" || true
		;;
	esac
    done


    export LANG=C
    export LC_ALL=C


    export CVS_RSH=ssh



    export SHELL=$BASH
    export CONFIG_SHELL=$BASH
}

pushenv() {
    pushenv_level=$(($pushenv_level + 1))
    eval pushenv_vars_${pushenv_level}=
}


pushenv_level=0
pushenv_vars_0=



pushenvvar() {
    local pushenv_var="$1"
    local pushenv_newval="$2"
    eval local pushenv_oldval=\"\$$pushenv_var\"
    eval local pushenv_oldset=\"\${$pushenv_var+set}\"
    local pushenv_save_var=saved_${pushenv_level}_${pushenv_var}
    local pushenv_savep_var=savedp_${pushenv_level}_${pushenv_var}
    eval local pushenv_save_set=\"\${$pushenv_savep_var+set}\"
    if [ "$pushenv_save_set" = "set" ]; then
	error "Pushing $pushenv_var more than once at level $pushenv_level"
    fi
    if [ "$pushenv_oldset" = "set" ]; then
	eval $pushenv_save_var=\"\$pushenv_oldval\"
    else
	unset $pushenv_save_var
    fi
    eval $pushenv_savep_var=1
    eval export $pushenv_var=\"\$pushenv_newval\"
    local pushenv_list_var=pushenv_vars_${pushenv_level}
    eval $pushenv_list_var=\"\$$pushenv_list_var \$pushenv_var\"
}

prependenvvar() {
    local pushenv_var="$1"
    local pushenv_newval="$2"
    eval local pushenv_oldval=\"\$$pushenv_var\"
    pushenvvar "$pushenv_var" "$pushenv_newval$pushenv_oldval"
}

popenv() {
    local pushenv_var=
    eval local pushenv_vars=\"\$pushenv_vars_${pushenv_level}\"
    for pushenv_var in $pushenv_vars; do
	local pushenv_save_var=saved_${pushenv_level}_${pushenv_var}
	local pushenv_savep_var=savedp_${pushenv_level}_${pushenv_var}
	eval local pushenv_save_val=\"\$$pushenv_save_var\"
	eval local pushenv_save_set=\"\${$pushenv_save_var+set}\"
	unset $pushenv_save_var
	unset $pushenv_savep_var
	if [ "$pushenv_save_set" = "set" ]; then
	    eval export $pushenv_var=\"\$pushenv_save_val\"
	else
	    unset $pushenv_var
	fi
    done
    unset pushenv_vars_${pushenv_level}
    if [ "$pushenv_level" = "0" ]; then
	error "Popping environment level 0"
    else
	pushenv_level=$(($pushenv_level - 1))
    fi
}

prepend_path() {
    if $(eval "test -n \"\$$1\""); then
	prependenvvar "$1" "$2:"
    else
	prependenvvar "$1" "$2"
    fi
}
pushenvvar CSL_SCRIPTDIR /scratch/joseph/symbian/trunk/src/scripts-trunk
pushenvvar PATH /usr/local/tools/gcc-3.4.0/bin:/bin:/usr/bin
pushenvvar LD_LIBRARY_PATH /usr/local/tools/gcc-3.4.0/lib64:/usr/local/tools/gcc-3.4.0/lib
pushenvvar QMTEST_CLASS_PATH QMTEST_CLASS_PATH
clean_environment
# task [001/039] /init/dirs
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
mkdir -p /scratch/joseph/symbian/trunk/obj
mkdir -p /scratch/joseph/symbian/trunk/install
mkdir -p /scratch/joseph/symbian/trunk/pkg
mkdir -p /scratch/joseph/symbian/trunk/logs
mkdir -p /scratch/joseph/symbian/trunk/install/share/doc/symbian-preprocessor-i686-pc-linux-gnu/html
mkdir -p /scratch/joseph/symbian/trunk/install/share/doc/symbian-preprocessor-i686-pc-linux-gnu/pdf
popenv

# task [002/039] /init/cleanup
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
rm -f /scratch/joseph/symbian/trunk/pkg/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.src.tar.bz2 /scratch/joseph/symbian/trunk/pkg/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup.tar.bz2
popenv

# task [003/039] /init/source_package/binutils
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
rm -f /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu/binutils-4.3-1.tar.bz2
mkdir -p /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu
pushd /scratch/joseph/symbian/trunk/src
tar cf /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu/binutils-4.3-1.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' binutils-2.18.50
popd
popenv

# task [004/039] /init/source_package/gcc
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
rm -f /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu/gcc-4.3-1.tar.bz2
mkdir -p /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu
pushd /scratch/joseph/symbian/trunk/src
tar cf /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu/gcc-4.3-1.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' gcc-4.3
popd
popenv

# task [005/039] /init/source_package/gmp
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
rm -f /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu/gmp-4.3-1.tar.bz2
mkdir -p /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu
pushd /scratch/joseph/symbian/trunk/src
tar cf /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu/gmp-4.3-1.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' gmp-mirror
popd
popenv

# task [006/039] /init/source_package/mpfr
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
rm -f /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu/mpfr-4.3-1.tar.bz2
mkdir -p /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu
pushd /scratch/joseph/symbian/trunk/src
tar cf /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu/mpfr-4.3-1.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' mpfr-mirror
popd
popenv

# task [007/039] /init/source_package/csl_tests
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
rm -f /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup/csl_tests-4.3-1.tar.bz2
mkdir -p /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup
pushd /scratch/joseph/symbian/trunk/src
tar cf /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup/csl_tests-4.3-1.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' csl-tests-trunk
popd
popenv

# task [008/039] /init/source_package/dejagnu_boards
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
rm -f /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup/dejagnu_boards-4.3-1.tar.bz2
mkdir -p /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup
pushd /scratch/joseph/symbian/trunk/src
tar cf /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup/dejagnu_boards-4.3-1.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' dejagnu-boards-trunk
popd
popenv

# task [009/039] /init/source_package/scripts
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
rm -f /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup/scripts-4.3-1.tar.bz2
mkdir -p /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup
pushd /scratch/joseph/symbian/trunk/src
tar cf /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup/scripts-4.3-1.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' scripts-trunk
popd
popenv

# task [010/039] /init/source_package/xfails
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
rm -f /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup/xfails-4.3-1.tar.bz2
mkdir -p /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup
pushd /scratch/joseph/symbian/trunk/src
tar cf /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup/xfails-4.3-1.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' xfails-trunk
popd
popenv

# task [011/039] /init/source_package/portal
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
rm -f /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup/portal-4.3-1.tar.bz2
mkdir -p /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup
pushd /scratch/joseph/symbian/trunk/src
tar cf /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup/portal-4.3-1.tar.bz2 --bzip2 --owner=0 --group=0 --exclude=CVS --exclude=.svn --exclude=.pc '--exclude=*~' '--exclude=.#*' '--exclude=*.orig' '--exclude=*.rej' portal-trunk
popd
popenv

# task [012/039] /i686-pc-linux-gnu/host_cleanup
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
popenv

# task [013/039] /i686-pc-linux-gnu/gmp/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushenvvar CFLAGS '-g -O2'
rm -rf /scratch/joseph/symbian/trunk/obj/gmp-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
mkdir -p /scratch/joseph/symbian/trunk/obj/gmp-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
pushd /scratch/joseph/symbian/trunk/obj/gmp-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
/scratch/joseph/symbian/trunk/src/gmp-mirror/configure --build=i686-pc-linux-gnu --target=i686-pc-linux-gnu --prefix=/scratch/joseph/symbian/trunk/obj/host-libs-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr --disable-shared --host=i686-pc-linux-gnu --disable-nls
popd
popenv
popenv

# task [014/039] /i686-pc-linux-gnu/gmp/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushenvvar CFLAGS '-g -O2'
pushd /scratch/joseph/symbian/trunk/obj/gmp-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
make -j4
popd
popenv
popenv

# task [015/039] /i686-pc-linux-gnu/gmp/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushenvvar CFLAGS '-g -O2'
pushd /scratch/joseph/symbian/trunk/obj/gmp-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
make install
popd
popenv
popenv

# task [016/039] /i686-pc-linux-gnu/gmp/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushenvvar CFLAGS '-g -O2'
pushd /scratch/joseph/symbian/trunk/obj/gmp-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
make check
popd
popenv
popenv

# task [017/039] /i686-pc-linux-gnu/mpfr/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
rm -rf /scratch/joseph/symbian/trunk/obj/mpfr-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
mkdir -p /scratch/joseph/symbian/trunk/obj/mpfr-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
pushd /scratch/joseph/symbian/trunk/obj/mpfr-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
/scratch/joseph/symbian/trunk/src/mpfr-mirror/configure --build=i686-pc-linux-gnu --target=i686-pc-linux-gnu --prefix=/scratch/joseph/symbian/trunk/obj/host-libs-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr --disable-shared --host=i686-pc-linux-gnu --disable-nls --with-gmp=/scratch/joseph/symbian/trunk/obj/host-libs-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr
popd
popenv
popenv

# task [018/039] /i686-pc-linux-gnu/mpfr/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushd /scratch/joseph/symbian/trunk/obj/mpfr-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
make -j4
popd
popenv
popenv

# task [019/039] /i686-pc-linux-gnu/mpfr/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushd /scratch/joseph/symbian/trunk/obj/mpfr-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
make install
popd
popenv
popenv

# task [020/039] /i686-pc-linux-gnu/mpfr/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushd /scratch/joseph/symbian/trunk/obj/mpfr-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
make check
popd
popenv
popenv

# task [021/039] /i686-pc-linux-gnu/toolchain/binutils/copy
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
rm -rf /scratch/joseph/symbian/trunk/obj/binutils-src-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
copy_dir_clean /scratch/joseph/symbian/trunk/src/binutils-2.18.50 /scratch/joseph/symbian/trunk/obj/binutils-src-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
chmod -R u+w /scratch/joseph/symbian/trunk/obj/binutils-src-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
touch /scratch/joseph/symbian/trunk/obj/binutils-src-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/.gnu-stamp
popenv
popenv

# task [022/039] /i686-pc-linux-gnu/toolchain/binutils/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
rm -rf /scratch/joseph/symbian/trunk/obj/binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
mkdir -p /scratch/joseph/symbian/trunk/obj/binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
pushd /scratch/joseph/symbian/trunk/obj/binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
/scratch/joseph/symbian/trunk/obj/binutils-src-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/configure --build=i686-pc-linux-gnu --target=i686-pc-linux-gnu --prefix=/opt/codesourcery --host=i686-pc-linux-gnu '--with-pkgversion=Symbian Preprocessor 4.3-1' --with-bugurl=https://support.codesourcery.com/GNUToolchain/ --disable-nls
popd
popenv
popenv

# task [023/039] /i686-pc-linux-gnu/toolchain/binutils/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushd /scratch/joseph/symbian/trunk/obj/binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
make -j4
popd
popenv
popenv

# task [024/039] /i686-pc-linux-gnu/toolchain/binutils/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushd /scratch/joseph/symbian/trunk/obj/binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
make install prefix=/scratch/joseph/symbian/trunk/install exec_prefix=/scratch/joseph/symbian/trunk/install libdir=/scratch/joseph/symbian/trunk/install/lib htmldir=/scratch/joseph/symbian/trunk/install/share/doc/symbian-preprocessor-i686-pc-linux-gnu/html pdfdir=/scratch/joseph/symbian/trunk/install/share/doc/symbian-preprocessor-i686-pc-linux-gnu/pdf infodir=/scratch/joseph/symbian/trunk/install/share/doc/symbian-preprocessor-i686-pc-linux-gnu/info mandir=/scratch/joseph/symbian/trunk/install/share/doc/symbian-preprocessor-i686-pc-linux-gnu/man datadir=/scratch/joseph/symbian/trunk/install/share
popd
popenv
popenv

# task [025/039] /i686-pc-linux-gnu/toolchain/binutils/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushd /scratch/joseph/symbian/trunk/install
rm lib/libiberty.a
popd
copy_dir_clean /scratch/joseph/symbian/trunk/src/binutils-2.18.50/include /scratch/joseph/symbian/trunk/obj/host-binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr/include
chmod -R u+w /scratch/joseph/symbian/trunk/obj/host-binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr/include
mkdir -p /scratch/joseph/symbian/trunk/obj/host-binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr/lib
cp /scratch/joseph/symbian/trunk/obj/binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/libiberty/libiberty.a /scratch/joseph/symbian/trunk/obj/host-binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr/lib
cp /scratch/joseph/symbian/trunk/obj/binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/bfd/.libs/libbfd.a /scratch/joseph/symbian/trunk/obj/host-binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr/lib
cp /scratch/joseph/symbian/trunk/obj/binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/bfd/bfd.h /scratch/joseph/symbian/trunk/obj/host-binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr/include
cp /scratch/joseph/symbian/trunk/src/binutils-2.18.50/bfd/elf-bfd.h /scratch/joseph/symbian/trunk/obj/host-binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr/include
cp /scratch/joseph/symbian/trunk/obj/binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/opcodes/.libs/libopcodes.a /scratch/joseph/symbian/trunk/obj/host-binutils-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr/lib
pushd /scratch/joseph/symbian/trunk/install/bin
popd
pushd /scratch/joseph/symbian/trunk/install/bin
ln addr2line i686-pc-linux-gnu-addr2line
ln ar i686-pc-linux-gnu-ar
ln as i686-pc-linux-gnu-as
ln c++filt i686-pc-linux-gnu-c++filt
ln gprof i686-pc-linux-gnu-gprof
ln ld i686-pc-linux-gnu-ld
ln nm i686-pc-linux-gnu-nm
ln objcopy i686-pc-linux-gnu-objcopy
ln objdump i686-pc-linux-gnu-objdump
ln ranlib i686-pc-linux-gnu-ranlib
ln readelf i686-pc-linux-gnu-readelf
ln size i686-pc-linux-gnu-size
ln strings i686-pc-linux-gnu-strings
ln strip i686-pc-linux-gnu-strip
popd
popenv
popenv

# task [026/039] /i686-pc-linux-gnu/toolchain/gcc_final/configure
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushenvvar AR_FOR_TARGET i686-pc-linux-gnu-ar
pushenvvar NM_FOR_TARGET i686-pc-linux-gnu-nm
pushenvvar OBJDUMP_FOR_TARET i686-pc-linux-gnu-objdump
pushenvvar STRIP_FOR_TARGET i686-pc-linux-gnu-strip
rm -rf /scratch/joseph/symbian/trunk/obj/gcc-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
mkdir -p /scratch/joseph/symbian/trunk/obj/gcc-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
pushd /scratch/joseph/symbian/trunk/obj/gcc-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
/scratch/joseph/symbian/trunk/src/gcc-4.3/configure --build=i686-pc-linux-gnu --host=i686-pc-linux-gnu --target=i686-pc-linux-gnu --enable-threads --disable-libmudflap --disable-libssp --disable-libgomp --disable-libstdcxx-pch --disable-bootstrap --with-gnu-as --with-gnu-ld --enable-languages=c --enable-shared '--with-pkgversion=Symbian Preprocessor 4.3-1' --with-bugurl=https://support.codesourcery.com/GNUToolchain/ --disable-nls --prefix=/opt/codesourcery --with-gmp=/scratch/joseph/symbian/trunk/obj/host-libs-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr --with-mpfr=/scratch/joseph/symbian/trunk/obj/host-libs-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu/usr --with-build-time-tools=/scratch/joseph/symbian/trunk/install/i686-pc-linux-gnu/bin --with-build-time-tools=/scratch/joseph/symbian/trunk/install/i686-pc-linux-gnu/bin
popd
popenv
popenv

# task [027/039] /i686-pc-linux-gnu/toolchain/gcc_final/build
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushenvvar AR_FOR_TARGET i686-pc-linux-gnu-ar
pushenvvar NM_FOR_TARGET i686-pc-linux-gnu-nm
pushenvvar OBJDUMP_FOR_TARET i686-pc-linux-gnu-objdump
pushenvvar STRIP_FOR_TARGET i686-pc-linux-gnu-strip
pushd /scratch/joseph/symbian/trunk/obj/gcc-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
make -j4
popd
popenv
popenv

# task [028/039] /i686-pc-linux-gnu/toolchain/gcc_final/install
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushenvvar AR_FOR_TARGET i686-pc-linux-gnu-ar
pushenvvar NM_FOR_TARGET i686-pc-linux-gnu-nm
pushenvvar OBJDUMP_FOR_TARET i686-pc-linux-gnu-objdump
pushenvvar STRIP_FOR_TARGET i686-pc-linux-gnu-strip
pushd /scratch/joseph/symbian/trunk/obj/gcc-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu
make prefix=/scratch/joseph/symbian/trunk/install exec_prefix=/scratch/joseph/symbian/trunk/install libdir=/scratch/joseph/symbian/trunk/install/lib htmldir=/scratch/joseph/symbian/trunk/install/share/doc/symbian-preprocessor-i686-pc-linux-gnu/html pdfdir=/scratch/joseph/symbian/trunk/install/share/doc/symbian-preprocessor-i686-pc-linux-gnu/pdf infodir=/scratch/joseph/symbian/trunk/install/share/doc/symbian-preprocessor-i686-pc-linux-gnu/info mandir=/scratch/joseph/symbian/trunk/install/share/doc/symbian-preprocessor-i686-pc-linux-gnu/man install
popd
popenv
popenv

# task [029/039] /i686-pc-linux-gnu/toolchain/gcc_final/postinstall
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushenv
pushenvvar AR_FOR_TARGET i686-pc-linux-gnu-ar
pushenvvar NM_FOR_TARGET i686-pc-linux-gnu-nm
pushenvvar OBJDUMP_FOR_TARET i686-pc-linux-gnu-objdump
pushenvvar STRIP_FOR_TARGET i686-pc-linux-gnu-strip
pushd /scratch/joseph/symbian/trunk/install
rm lib/libiberty.a
rm bin/gccbug
popd
pushd /scratch/joseph/symbian/trunk/install/bin
popd
pushd /scratch/joseph/symbian/trunk/install/bin
ln cpp i686-pc-linux-gnu-cpp
ln gcov i686-pc-linux-gnu-gcov
popd
popenv
popenv

# task [030/039] /i686-pc-linux-gnu/finalize_libc_installation
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
popenv

# task [031/039] /i686-pc-linux-gnu/pretidy_installation
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushd /scratch/joseph/symbian/trunk/install
popd
popenv

# task [032/039] /i686-pc-linux-gnu/remove_libtool_archives
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
find /scratch/joseph/symbian/trunk/install -name '*.la' -exec rm '{}' ';'
popenv

# task [033/039] /i686-pc-linux-gnu/remove_fixed_headers
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
pushd /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/include-fixed
rm -f ./slang/slang.h
rm -f ./bits/string2.h
rm -f ./openssl/bn.h
rm -f ./linux/a.out.h
rm -f ./sys/stat.h
rm -f ./sys/sysmacros.h
rm -f ./root/usr/X11R6/include/X11/Xos_r.h
rm -f ./root/usr/X11R6/include/X11/Xosdefs.h
rm -f ./root/usr/X11R6/include/X11/Xos.h
rm -f ./features.h
rm -f ./libdevmapper.h
rm -f ./zutil.h
rm -f ./X11
rmdir ./slang ./bits ./openssl ./linux ./sys ./root/usr/X11R6/include/X11
rmdir ./root/usr/X11R6/include
rmdir ./root/usr/X11R6
rmdir ./root/usr
rmdir ./root
sed -i -e 's|/bin/bash|sh|g' /scratch/joseph/symbian/trunk/install/libexec/gcc/i686-pc-linux-gnu/4.3.0/install-tools/mkheaders
mkdir -p /scratch/joseph/symbian/trunk/install/share
cat > /scratch/joseph/symbian/trunk/install/share/postinst-symbian-preprocessor-i686-pc-linux-gnu.sh <<'EOF0'
#! /bin/sh
dir=`dirname "$0"`
dir=`cd "$dir/.." && pwd`
EOF0
chmod a+x /scratch/joseph/symbian/trunk/install/share/postinst-symbian-preprocessor-i686-pc-linux-gnu.sh
mkdir -p /scratch/joseph/symbian/trunk/install/share
cat > /scratch/joseph/symbian/trunk/install/share/postinst-symbian-preprocessor-i686-pc-linux-gnu.sh <<'EOF0'
#! /bin/sh
dir=`dirname "$0"`
dir=`cd "$dir/.." && pwd`
$dir/libexec/gcc/i686-pc-linux-gnu/4.3.0/install-tools/mkheaders "$dir"
EOF0
popd
popenv

# task [034/039] /i686-pc-linux-gnu/strip_host_objects
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/addr2line
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/ar
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/as
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/c++filt
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/cpp
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/gcc
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/gcov
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/gprof
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-addr2line
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-ar
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-as
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-c++filt
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-cpp
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-gcc
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-gcc-4.3.0
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-gcov
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-gprof
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-ld
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-nm
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-objcopy
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-objdump
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-ranlib
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-readelf
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-size
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-strings
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/i686-pc-linux-gnu-strip
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/ld
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/nm
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/objcopy
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/objdump
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/ranlib
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/readelf
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/size
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/strings
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/bin/strip
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/i686-pc-linux-gnu/bin/ar
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/i686-pc-linux-gnu/bin/as
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/i686-pc-linux-gnu/bin/ld
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/i686-pc-linux-gnu/bin/nm
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/i686-pc-linux-gnu/bin/objcopy
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/i686-pc-linux-gnu/bin/objdump
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/i686-pc-linux-gnu/bin/ranlib
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/i686-pc-linux-gnu/bin/strip
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/libexec/gcc/i686-pc-linux-gnu/4.3.0/cc1
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/libexec/gcc/i686-pc-linux-gnu/4.3.0/collect2
/usr/local/tools/gcc-3.4.0/bin/i686-pc-linux-gnu-strip /scratch/joseph/symbian/trunk/install/libexec/gcc/i686-pc-linux-gnu/4.3.0/install-tools/fixincl
popenv

# task [035/039] /i686-pc-linux-gnu/strip_target_objects
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
i686-pc-linux-gnu-objcopy -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc -R .comment -R .note /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/libgcc_eh.a || true
i686-pc-linux-gnu-objcopy -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc -R .comment -R .note /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/libgcc.a || true
i686-pc-linux-gnu-objcopy -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc -R .comment -R .note /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/libgcov.a || true
i686-pc-linux-gnu-objcopy -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc -R .comment -R .note /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/crtbegin.o || true
i686-pc-linux-gnu-objcopy -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc -R .comment -R .note /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/crtbeginS.o || true
i686-pc-linux-gnu-objcopy -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc -R .comment -R .note /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/crtbeginT.o || true
i686-pc-linux-gnu-objcopy -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc -R .comment -R .note /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/crtend.o || true
i686-pc-linux-gnu-objcopy -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc -R .comment -R .note /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/crtendS.o || true
i686-pc-linux-gnu-objcopy -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc -R .comment -R .note /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/crtprec32.o || true
i686-pc-linux-gnu-objcopy -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc -R .comment -R .note /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/crtprec64.o || true
i686-pc-linux-gnu-objcopy -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc -R .comment -R .note /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/crtprec80.o || true
i686-pc-linux-gnu-objcopy -R .debug_info -R .debug_aranges -R .debug_pubnames -R .debug_abbrev -R .debug_line -R .debug_str -R .debug_ranges -R .debug_loc -R .comment -R .note /scratch/joseph/symbian/trunk/install/lib/gcc/i686-pc-linux-gnu/4.3.0/crtfastmath.o || true
popenv

# task [036/039] /i686-pc-linux-gnu/package_tbz2
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
pushenvvar CC i686-pc-linux-gnu-gcc
prepend_path PATH /scratch/joseph/symbian/trunk/install/bin
rm -f /scratch/joseph/symbian/trunk/pkg/symbian-preprocessor-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu.tar.bz2
pushd /scratch/joseph/symbian/trunk/obj
rm -f symbian-preprocessor-4.3
ln -s /scratch/joseph/symbian/trunk/install symbian-preprocessor-4.3
tar cjf /scratch/joseph/symbian/trunk/pkg/symbian-preprocessor-4.3-1-i686-pc-linux-gnu-i686-pc-linux-gnu.tar.bz2 --owner=0 --group=0 --exclude=host-i686-pc-linux-gnu symbian-preprocessor-4.3/bin symbian-preprocessor-4.3/i686-pc-linux-gnu symbian-preprocessor-4.3/include symbian-preprocessor-4.3/lib symbian-preprocessor-4.3/libexec symbian-preprocessor-4.3/share
rm -f symbian-preprocessor-4.3
popd
popenv

# task [037/039] /fini/build_summary
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
cat > /scratch/joseph/symbian/trunk/obj/gnu-4.3-1-i686-pc-linux-gnu.txt <<'EOF0'
Version Information
===================

Version:           4.3-1
Host(s):           i686-pc-linux-gnu
Target:            i686-pc-linux-gnu

Build Information
=================

Build date:             20071205
Build machine:          cugel.codesourcery.com
Build operating system: Red Hat Enterprise Linux ES release 4 (Nahant Update 5)
Build uname:            Linux cugel.codesourcery.com 2.6.9-55.0.2.ELsmp #1 SMP Tue Jun 12 17:58:20 EDT 2007 x86_64 unknown unknown GNU/Linux
Build user:             joseph

EOF0
popenv

# task [038/039] /fini/backup_package
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
mkdir -p /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup
pushd /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu
tar cjf /scratch/joseph/symbian/trunk/pkg/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup.tar.bz2 --owner=0 --group=0 symbian-preprocessor-4.3-1-i686-pc-linux-gnu.backup
popd
popenv

# task [039/039] /fini/source_package
pushenv
pushenvvar CC_FOR_BUILD i686-pc-linux-gnu-gcc
mkdir -p /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu
cp /scratch/joseph/symbian/trunk/obj/gnu-4.3-1-i686-pc-linux-gnu.txt /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu
cp /scratch/joseph/symbian/trunk/logs/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.sh /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu/symbian-preprocessor-4.3-1-i686-pc-linux-gnu
pushd /scratch/joseph/symbian/trunk/obj/pkg-4.3-1-i686-pc-linux-gnu
tar cjf /scratch/joseph/symbian/trunk/pkg/symbian-preprocessor-4.3-1-i686-pc-linux-gnu.src.tar.bz2 --owner=0 --group=0 symbian-preprocessor-4.3-1-i686-pc-linux-gnu
popd
/scratch/joseph/symbian/trunk/src/scripts-trunk/gnu-test -i /scratch/joseph/symbian/trunk/install -l /scratch/joseph/symbian/trunk/logs -o /scratch/joseph/symbian/trunk/obj -p /scratch/joseph/symbian/trunk/pkg -s /scratch/joseph/symbian/trunk/src -T /scratch/joseph/symbian/trunk/testlogs -T /scratch/joseph/symbian/trunk/obj/testlogs-4.3-1-i686-pc-linux-gnu symbian-preprocessor-trunk.cfg
copy_dir /scratch/joseph/symbian/trunk/obj/testlogs-4.3-1-i686-pc-linux-gnu /scratch/joseph/symbian/trunk/testlogs
/scratch/joseph/symbian/trunk/src/scripts-trunk/gnu-test-package -i /scratch/joseph/symbian/trunk/install -l /scratch/joseph/symbian/trunk/logs -o /scratch/joseph/symbian/trunk/obj -p /scratch/joseph/symbian/trunk/pkg -s /scratch/joseph/symbian/trunk/src -T /scratch/joseph/symbian/trunk/testlogs -T /scratch/joseph/symbian/trunk/obj/testlogs-4.3-1-i686-pc-linux-gnu symbian-preprocessor-trunk.cfg
