/* 
 * make_pvm.c -- 
 * 
 * Author	  : Jean Labrousse
 * Created On      : Tue Sep 28 13:19:17 1999
 * Last Modified By: Jean Labrousse
 * Last Modified On: Tue Feb 15 11:43:01 2000
 * Update Count    : 187
 * Status	  : Unknown, Use with caution!
 *
 *
 * ==================== RCS ====================
 * $Author: jlabrous $
 * $Log: make_pvm.c,v $
 * Revision 1.7  2005/03/01 20:08:37  jlabrous
 * *** empty log message ***
 *
 * Revision 1.6  2005/02/28 21:31:14  jlabrous
 * *** empty log message ***
 *
 * Revision 1.5  2005/02/13 22:27:50  jlabrous
 * *** empty log message ***
 *
 * Revision 1.1.1.1  2005/01/10 23:52:09  jean
 *
 *
 * Revision 1.3  2002/08/19 20:17:00  jlabrous
 * add nice support
 * change PVMMAKE_ARCH and PVMMAKE_HOST by HOST_LIST variable according to pvm_config
 * update README.pvm
 *
 * Revision 1.2  2002/08/07 22:18:40  jlabrous
 * With jobserver
 *
 * Revision 1.1  2002/08/01 06:16:04  labrous1
 * Initial revision
 *
 * ==================== RCS ====================
 */

#include <stdio.h>
#include <unistd.h>
#include <pvm3.h>
#include <signal.h>
#include <sys/wait.h>
#include <limits.h>
#include <alloca.h>
#include <stdlib.h>

#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>


#include "pvm_message.h"

#include "config.h"

int tid,ptid,makelevel0;

int debug = 1;

int stat_loc=0;
int loopend =0;
int son=0;
int priority=0;

char env_slave_tid[256];

#define IOBUFFERFLUSH (PVMGMAKE_IOBUFFERSIZE - PVMGMAKE_IOBUFFERSIZE/4)

struct sigaction new_action, old_action;
void child(sig)
int sig;
{
  wait(&stat_loc); 
  son = 0;
  loopend = 1; 
}


void sighandler(sig) 
int sig;
{
  if (son) {
    sigaction (sig, &new_action, NULL);
    kill (son,sig);
  } 
}



/*
 * PVM GNU Make io buffer for use in sending command output back
 *
 */

typedef struct
{
       char *buf;
       int size;
       int level;
       int type;
} pvmgmake_iobuffer;

#ifndef FDOUT
#  define FDOUT 5  
#endif
/*
  mygets with a fd and not a FILE*
*/
static int mygets(pvmgmake_iobuffer *iob, int fd){
       int pos;
       char c;
       int ret;

       for(pos = 0; pos < iob->size; pos++) {
	       ret = read(fd, &c, 1);
	       if ( ret == 1){
		       if (c == '\n') { /* end of line */
				       iob->buf[pos] = 0;
				       return pos;
		       } else if (c == '\r'){
				       /* forget it*/
		       } else {
				       iob->buf[pos] = c;
		       }
	       } else { /* cant read -> eof or error */
		       iob->buf[pos] = 0;
		       return ret;
	       }
       }
       /* line to long */
       iob->buf[pos-1] = 0;

       iob->level = pos;
       return pos;

}


/*
 * Allocate a new pvm gmake io buffer.
 *
 * This is a simple mechanism for an auto-expanding buffer for
 * reading from a file and then sending/recieving pvm io operations.
 * type is the pvmgmake operation type:  pvmMakeStdout or pvmMakeStderr
 *
 * */
pvmgmake_iobuffer *buf_new(int type)
{
       pvmgmake_iobuffer *b;

       if (type != pvmMakeStdout && type != pvmMakeStderr && type != pvmMakeDepend)
       {
	       errno = EINVAL;
	       return NULL;
       }

       b = malloc(sizeof(pvmgmake_iobuffer));
       if (!b) return NULL;

       b->buf = malloc(PVMGMAKE_IOBUFFERSIZE);
       if (!b->buf)
       {
	       free(b);
	       return NULL;
       }

       b->size = PVMGMAKE_IOBUFFERSIZE;
       b->type = type;
       b->level = 0;

       return b;
}

/* Buffered read, expanding buffer. */
int buf_flush(pvmgmake_iobuffer *iob)
{
	if (iob->level > 0) 
	{
		pvm_initsend( PvmDataDefault );
		iob->buf[iob->level] = 0;
		pvm_pkstr(iob->buf);
		pvm_send(makelevel0 , iob->type );
		iob->level = 0;
	}
}

int buf_read(pvmgmake_iobuffer *iob, int file_handle)
{
	int lg;
       
	if (iob->level >= (iob->size >> 2)) 
	{
		char *new_iobuffer = realloc(iob->buf, iob->size + PVMGMAKE_IOBUFFERSIZE);
		if ( new_iobuffer )
		{
			iob->buf = new_iobuffer;
			iob->size += PVMGMAKE_IOBUFFERSIZE;
		}
		else /* No memory for a larger buffer - must send it */
		{
			buf_flush(iob);
		}
	}

	lg = read(file_handle,iob->buf + iob->level, iob->size - iob->level);
	if (lg > 0)
		iob->level += lg;

	return lg;
}

int buf_free(pvmgmake_iobuffer **iob)
{
       if (iob)
       {
	       if (*iob)
	       {
		       free((*iob)->buf);
		       free((*iob));
		       *iob = NULL;
	       }
       }
}

int main (int argc, char **argv, char **envp)
{
       char buffer[2048];

       int std_out[2];
       int std_err[2];

       int tmplog;
       #ifdef  ENABLE_AUTODEPEND
       int autodepend_fd[2];
       #endif
       int argv_max,env_max;
       int i,lg,ret;

       char **argv_target;
       char **envp_target;

       if (argc < 2) exit(-1);

       pvm_setopt(PvmAutoErr,2);

       /* Communicate directly with parent. */
       pvm_setopt(PvmRoute, PvmRouteDirect);
       pvm_setopt(PvmDebugMask, 1 & 2 & 4 & 8 & 16 & 32 );

       tid = pvm_mytid();

       ptid = atoi(argv[1]);


       if ((argc == 3) && !strcmp(argv[2],"-d")) debug = 1;

       if (debug) {
	       pvm_initsend( PvmDataDefault );
	       pvm_catchout(stdout);
	       printf("Slave:MyTid is t%x\n",tid);
       }

       if (ptid != 0) { /* for a make slave */
	       pvm_initsend( PvmDataDefault );
	       pvm_pkint(&tid, 1, 1);
	       pvm_send(ptid , pvmMakeSlotAck );
       } else { /* for the make master */
	       ptid = pvm_parent();
       }

       if (debug) printf("Slave: BEFORE got pvmMakeMng %x\n",ptid);
       if (debug) printf("I work for t%x\n",ptid);

       pvm_recv( ptid, pvmMakeMng );

       if (debug) printf("Slave: got pvmMakeMng %x\n",ptid);
       /*
	 cwd
       */
       pvm_upkstr(buffer);
       chdir (buffer);

       /*
	 priority
       */
       pvm_upkint (&priority, 1, 1);

       /*
	 argv
       */

       pvm_upkint (&argv_max, 1, 1);
       argv_target = (char**) alloca((argv_max + 1) *sizeof(char*));
       for (i = 0 ; i < argv_max; i++) {
	       int argv_size;
	       pvm_upkint (&argv_size, 1, 1);
	       argv_target[i] = (char*) alloca ((argv_size +1) * sizeof (char));
	       pvm_upkstr(argv_target[i]);
	       /* if (debug) printf("Slave: %x Command: %s\n",ptid,argv_target[i]); */
       }
       argv_target[i] = NULL;

       #ifndef PVM_EXPORT_ONLY
       /*
	 envp
       */

       pvm_upkint (&env_max, 1, 1);

       for (i = 0 ; i < env_max; i++) {
	       char *env;
	       int env_size;
	       pvm_upkint (&env_size, 1, 1);
	       env = (char*) alloca ((env_size +1) * sizeof (char));
	       pvm_upkstr(env);

	       if (!strncmp(env,"MAKELEVEL0=",11))
		       makelevel0 = atoi(&env[11]);

	       putenv(env);
       }
       #endif

       sprintf(env_slave_tid,"PVMMAKE_TID=%d",tid);
       putenv(env_slave_tid);

       pipe(std_out);
       pipe(std_err);
       #ifdef  ENABLE_AUTODEPEND
       pipe(autodepend_fd);
       #endif

       /* Connect signal handler for child signals */
       new_action.sa_handler = child;
       sigemptyset (&new_action.sa_mask);
       new_action.sa_flags = 0;
       sigaction (SIGCHLD, &new_action, NULL);
       /* Handle all other signals ourselves */
       new_action.sa_handler = sighandler;
       sigemptyset (&new_action.sa_mask);
       new_action.sa_flags = 0;
       for (i=0; i < NSIG  ;i++ ) {
	       if (i != SIGCHLD)
		       sigaction (i, &new_action, NULL);
       }

       /*  signal(SIGCHLD,child);
	 for (i=0; i < NSIG  ;i++ ) {
	   if (i != SIGCHLD)
	     signal(i,sighandler);
	  }
       */

       if (debug) printf("Slave: about to fork: %x\n",tid);
       son = fork();
       if (son == 0) {
	       int ret;

	       close(std_out[0]);
	       dup2(std_out[1],1);
	       close(std_out[1]);

	       close(std_err[0]);
	       dup2(std_err[1],2);
	       close(std_err[1]);

	       #ifdef  ENABLE_AUTODEPEND
	       close(autodepend_fd[0]);
	       dup2(autodepend_fd[1],FDOUT);
	       close(autodepend_fd[1]);
	       #endif

	       nice(priority);

	       ret = execvp(argv_target[0],argv_target);
	       perror(argv_target[0]);
	       exit(ret);
       } else {
	       fd_set fd_inputs,wfd_inputs;
	       int max;
	       int lg,selret;

	       pvmgmake_iobuffer *stdout_buffer = buf_new(pvmMakeStdout);
	       pvmgmake_iobuffer *stderr_buffer = buf_new(pvmMakeStderr);
	       pvmgmake_iobuffer *depend_buffer = buf_new(pvmMakeDepend);

	       if (!stdout_buffer || !stderr_buffer || !depend_buffer )
	       {
		       fprintf(stderr,"IO buffer allocation failed\n");
		       pvm_catchout(0);
		       pvm_exit( );
		       return(-1);
	       }

	       close(std_out[1]);
	       close(std_err[1]);
	       #ifdef  ENABLE_AUTODEPEND
	       close(autodepend_fd[1]);
	       #endif

	       max = std_out[0];
	       if (max < std_err[0]) max = std_err[0];
	       #ifdef  ENABLE_AUTODEPEND
	       if (max < autodepend_fd[0]) max = autodepend_fd[0];
	       #endif
	       FD_ZERO(&fd_inputs);

	       FD_SET(std_out[0],&fd_inputs);
	       FD_SET(std_err[0],&fd_inputs);
	       #ifdef  ENABLE_AUTODEPEND
	       FD_SET(autodepend_fd[0],&fd_inputs);
	       #endif
	       if (debug) printf("Slave: output piping: %x\n",tid);

	       for(;loopend == 0;) {
			fflush(stdout);
			fflush(stderr);
			wfd_inputs = fd_inputs;
			selret = select(max+1,&wfd_inputs,NULL,NULL,NULL);

			if (FD_ISSET(std_out[0],&wfd_inputs)){
			 	       buf_read(stdout_buffer, std_out[0]);
			}
			if (FD_ISSET(std_err[0],&wfd_inputs)){
				       buf_read(stderr_buffer, std_err[0]);
			}
			#ifdef  ENABLE_AUTODEPEND
			if (FD_ISSET(autodepend_fd[0],&wfd_inputs)){
			 	       if (mygets (depend_buffer, autodepend_fd[0]) != NULL) {
			 		       pvm_initsend( PvmDataDefault );
			 		       pvm_pkstr(depend_buffer->buf);
			 		       pvm_send(ptid , pvmMakeDepend );
			 	       }
			}
	       #endif
	       }

	       /* empty the stdout buffer and anything the process has left over */
	       for (;buf_read(stdout_buffer, std_out[0]););
	       buf_flush(stdout_buffer);

	       /* empty the stderr buffer and any remaining output from the process */
	       for (;buf_read(stderr_buffer, std_err[0]););
	       buf_flush(stderr_buffer);

	       #ifdef  ENABLE_AUTODEPEND
	       while(mygets (depend_buffer,autodepend_fd[0]) != NULL) {
		       pvm_initsend( PvmDataDefault );
		       pvm_pkstr(depend_buffer->buf);
		       pvm_send(ptid, pvmMakeDepend );
	       }
	       #endif

	       fflush(stdout);
	       fflush(stderr);
	       /* sync(); try to ensure that the maketask output is returned properly. */
	       pvm_initsend( PvmDataDefault );
	       pvm_pkint(&stat_loc, 1, 1);
	       pvm_send(ptid , pvmMakeEndTask );

	       if (stdout_buffer) buf_free(&stdout_buffer);
	       if (stderr_buffer) buf_free(&stderr_buffer);
	       if (depend_buffer) buf_free(&depend_buffer);
	}
       if (debug) printf("Bye ret = %d\n",stat_loc);
       pvm_catchout(0);
       pvm_exit( );
       return(0);
}
