/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;

public class MetaDataDb {
    private static Logger log = Logger.getLogger(MetaDataDb.class);
    private static final String DRIVER_CLASS_NAME = "org.sqlite.JDBC";
    private static final String URL_PREFIX = "jdbc:sqlite:/";
    private static final int LOG_ENTRY_CACHE_LIMIT = 500;
    private static final int DB_SCHEMA_VERSION = 1;
    private static final String[] INIT_TABLES = new String[]{"CREATE TABLE schema (version INTEGER default 1)", "CREATE TABLE metadata (priority_id INTEGER, component_id INTEGER, line_number INTEGER, data TEXT, logpath_id INTEGER)", "CREATE TABLE component (id INTEGER PRIMARY KEY,component TEXT, logPath_id INTEGER, UNIQUE (logPath_id,component))", "CREATE TABLE priority (id INTEGER PRIMARY KEY,priority TEXT)", "CREATE TABLE logfiles (id INTEGER PRIMARY KEY, path TEXT)", "CREATE TABLE componenttime (cid INTEGER PRIMARY KEY, time DOUBLE default 0, UNIQUE (cid))"};
    private static final String INSERT_METADATA_ENTRY = "INSERT INTO metadata VALUES(?, ?, ?, ?, ?)";
    private static final String INSERT_LOGENTRY = "INSERT or IGNORE INTO logfiles VALUES(?, ?)";
    private static final String INSERT_PRIORITYENTRY = "INSERT INTO priority VALUES(?, ?)";
    private static final String INSERT_COMPONENTENTRY = "INSERT or IGNORE INTO component VALUES(?, ?, ?) ";
    private static final String INSERT_COMPONENT_TIME = "INSERT or IGNORE INTO componenttime VALUES(?, ?)";
    private String dbPath;
    private String url;
    private boolean statementsInitialized;
    private Connection connection;
    private Connection readConnection;
    private PreparedStatement insertMetaDataEntryStmt;
    private PreparedStatement insertLogEntryStmt;
    private PreparedStatement insertComponentStmt;
    private PreparedStatement insertComponentTimeStmt;
    private int entryCacheSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaDataDb(String databasePath) {
        this.dbPath = databasePath;
        this.url = URL_PREFIX + this.dbPath;
        try {
            Class.forName(DRIVER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("JDBC Driver could not be found");
        }
        Class<MetaDataDb> clazz = MetaDataDb.class;
        synchronized (MetaDataDb.class) {
            boolean initializeDatabase = false;
            File dbFile = new File(this.dbPath);
            if (!dbFile.exists()) {
                initializeDatabase = true;
            } else {
                try {
                    log.debug((Object)"checking for schema version of db");
                    this.initializeConnection();
                    Statement stmt = this.connection.createStatement();
                    ResultSet rs = stmt.executeQuery("select version from schema");
                    int version = -1;
                    if (rs.next()) {
                        version = rs.getInt(1);
                    }
                    rs.close();
                    stmt.close();
                    log.debug((Object)("schema version of db:" + version));
                    if (version != 1) {
                        log.debug((Object)"Schema Not matched deleting db file");
                        dbFile.delete();
                        initializeDatabase = true;
                    }
                    this.finalizeConnection();
                }
                catch (SQLException ex) {
                    try {
                        this.finalizeConnection();
                    }
                    catch (SQLException ex1) {
                        throw new BuildException("Exception while finalizing Metadata database. ", (Throwable)ex1);
                    }
                    log.debug((Object)"Exception checking schema for db", (Throwable)ex);
                    dbFile.delete();
                    initializeDatabase = true;
                }
            }
            try {
                this.initializeConnection();
                this.connection.setAutoCommit(false);
                if (initializeDatabase) {
                    Statement statement = this.connection.createStatement();
                    for (int i = 0; i < INIT_TABLES.length; ++i) {
                        statement.addBatch(INIT_TABLES[i]);
                    }
                    Priority[] priorityValues = Priority.values();
                    for (int i = 0; i < priorityValues.length; ++i) {
                        statement.addBatch("INSERT INTO priority (priority) VALUES (\"" + (Object)((Object)priorityValues[i]) + "\")");
                    }
                    statement.addBatch("INSERT INTO schema (version) VALUES (\"1 \")");
                    statement.addBatch("create unique index logfile_unique_1 on logfiles (path)");
                    int[] returnCodes = statement.executeBatch();
                    this.connection.commit();
                    this.connection.setAutoCommit(false);
                    statement.close();
                    this.finalizeConnection();
                }
            }
            catch (SQLException e) {
                throw new BuildException("Problem while initializing Metadata database. ", (Throwable)e);
            }
            return;
        }
    }

    public void initializeConnection() throws SQLException {
        new File(this.dbPath).getParentFile().mkdirs();
        this.connection = DriverManager.getConnection(this.url);
    }

    public void finalizeStatements() throws SQLException {
        if (this.statementsInitialized) {
            if (this.entryCacheSize > 0) {
                this.entryCacheSize = 0;
                this.writeLogDataToDB();
            }
            this.insertLogEntryStmt.close();
            this.insertComponentStmt.close();
            this.insertMetaDataEntryStmt.close();
        }
    }

    private void finalizeConnection() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeDB() {
        try {
            Class<MetaDataDb> clazz = MetaDataDb.class;
            synchronized (MetaDataDb.class) {
                this.finalizeStatements();
                this.finalizeConnection();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (SQLException ex) {
            log.debug((Object)"Exception while finalizing the Metadata database. ", (Throwable)ex);
        }
        {
            return;
        }
    }

    public Map<String, List<String>> getIndexMap(String query) {
        LinkedHashMap<String, List<String>> indexMap = new LinkedHashMap<String, List<String>>();
        try {
            this.initializeConnection();
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    ArrayList<String> dataList = new ArrayList<String>();
                    String key = null;
                    for (int i = 1; i <= numberOfColumns; ++i) {
                        String data = null;
                        int type = rsmd.getColumnType(i);
                        data = type == 4 ? "" + rs.getInt(i) : (type == 8 ? "" + rs.getDouble(i) : rs.getString(i));
                        if (i == 1) {
                            key = data;
                            continue;
                        }
                        dataList.add(data);
                    }
                    indexMap.put(key, dataList);
                }
            }
            stmt.close();
            this.finalizeConnection();
        }
        catch (Exception ex) {
            log.debug((Object)"Warning: Exception while getting the index map", (Throwable)ex);
        }
        return indexMap;
    }

    public List<Map<String, Object>> getRecords(String query) {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        try {
            this.initializeConnection();
            Statement stmt = this.connection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int numberOfColumns = rsmd.getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>();
            for (int i = 1; i <= numberOfColumns; ++i) {
                columnNames.add(rsmd.getColumnName(i));
            }
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    LinkedHashMap<String, Object> recordMap = new LinkedHashMap<String, Object>();
                    for (int i = 1; i <= numberOfColumns; ++i) {
                        Object data;
                        int type = rsmd.getColumnType(i);
                        String columnName = (String)columnNames.get(i - 1);
                        if (type == 4) {
                            data = new Integer(rs.getInt(i));
                            recordMap.put(columnName, data);
                            continue;
                        }
                        data = rs.getString(i);
                        recordMap.put(columnName, data);
                    }
                    rowList.add(recordMap);
                }
            }
            stmt.close();
            this.finalizeConnection();
        }
        catch (Exception ex) {
            log.warn((Object)"Warning: Exception while getting the record details", (Throwable)ex);
        }
        return rowList;
    }

    public List<Map<String, Object>> getRecords(String query, int recordLimit, int offsetValue) {
        String updatedQuery = query + " limit " + recordLimit + " offset " + offsetValue + ";";
        return this.getRecords(updatedQuery);
    }

    private void updateIndexTables(LogEntry entry) throws SQLException {
        this.connection.setAutoCommit(false);
        this.insertLogEntryStmt.setNull(1, 4);
        this.insertLogEntryStmt.setString(2, entry.getLogPath());
        this.insertLogEntryStmt.addBatch();
        this.insertLogEntryStmt.executeBatch();
        this.connection.commit();
        this.readConnection = DriverManager.getConnection(this.url);
        this.readConnection.setAutoCommit(false);
        Statement stmt = this.readConnection.createStatement();
        ResultSet rs = stmt.executeQuery("select id from logfiles where path='" + entry.getLogPath().trim() + "'");
        int logPathId = 0;
        if (rs.next()) {
            logPathId = rs.getInt(1);
        }
        stmt.close();
        this.readConnection.close();
        this.insertComponentStmt.setNull(1, 4);
        this.insertComponentStmt.setString(2, entry.getComponent());
        this.insertComponentStmt.setInt(3, logPathId);
        this.insertComponentStmt.addBatch();
        this.insertComponentStmt.executeBatch();
        this.connection.commit();
        this.insertLogEntryStmt.clearBatch();
        this.insertComponentStmt.clearBatch();
    }

    private void writeLogDataToDB() throws SQLException {
        this.insertMetaDataEntryStmt.executeBatch();
        this.connection.commit();
        this.insertMetaDataEntryStmt.clearBatch();
    }

    public void removeLog(String log) throws Exception {
        this.initializeConnection();
        Statement stmt = this.connection.createStatement();
        stmt.executeUpdate("DELETE FROM metadata WHERE logpath_id IN (SELECT id from metadata, logfiles WHERE logfiles.id=metadata.logpath_id and logfiles.path='" + log + "')");
        stmt.close();
    }

    public void removeEntries(List<String> logPathList) throws Exception {
        this.initializeConnection();
        Statement stmt = this.connection.createStatement();
        for (String logPath : logPathList) {
            log.debug((Object)("logpath for delete: " + logPath));
            log.debug((Object)("logpath delete query1 DELETE FROM metadata WHERE logpath_id IN (SELECT id from logfiles WHERE path like '" + logPath + "')"));
            stmt.executeUpdate("DELETE FROM metadata WHERE logpath_id IN (SELECT id from logfiles WHERE path like '%" + logPath + "%')");
            log.debug((Object)("logpath for delete2: DELETE FROM component_time WHERE cid IN (select id from component where logpath_id in (select id from logfiles where path like '%" + logPath + "%'))"));
            stmt.executeUpdate("DELETE FROM componenttime WHERE cid IN (select id from component where logpath_id in (select id from logfiles where path like '%" + logPath + "%'))");
            log.debug((Object)("logpath for delete3: DELETE FROM component WHERE logpath_id IN (select id from logfiles where path like '%" + logPath + "%')"));
            stmt.executeUpdate("DELETE FROM component WHERE logpath_id IN (select id from logfiles where path like '%" + logPath + "%')");
            log.debug((Object)("logpath for delete: DELETE FROM logfiles WHERE path like ('%" + logPath + "%')"));
            stmt.executeUpdate("DELETE FROM logfiles WHERE path like ('%" + logPath + "%')");
        }
        stmt.close();
        this.finalizeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogEntry(LogEntry entry) throws Exception {
        Class<MetaDataDb> clazz = MetaDataDb.class;
        synchronized (MetaDataDb.class) {
            try {
                if (!this.statementsInitialized) {
                    log.debug((Object)"Initializing statements for JDBC");
                    this.initializeConnection();
                    this.insertMetaDataEntryStmt = this.connection.prepareStatement(INSERT_METADATA_ENTRY);
                    this.insertLogEntryStmt = this.connection.prepareStatement(INSERT_LOGENTRY);
                    this.insertComponentStmt = this.connection.prepareStatement(INSERT_COMPONENTENTRY);
                    this.insertComponentTimeStmt = this.connection.prepareStatement(INSERT_COMPONENT_TIME);
                    this.statementsInitialized = true;
                }
                this.connection.setAutoCommit(false);
                this.updateIndexTables(entry);
                double time = entry.getElapsedTime();
                int logPathId = 0;
                int componentId = 0;
                Statement stmt = null;
                ResultSet rs = null;
                if (time != -1.0 || entry.getPriority() != Priority.DEFAULT) {
                    this.readConnection = DriverManager.getConnection(this.url);
                    stmt = this.readConnection.createStatement();
                    rs = stmt.executeQuery("select id from logfiles where path='" + entry.getLogPath().trim() + "'");
                    if (rs.next()) {
                        logPathId = rs.getInt(1);
                    }
                    rs.close();
                    stmt.close();
                    this.insertMetaDataEntryStmt.setInt(5, logPathId);
                    stmt = this.readConnection.createStatement();
                    rs = stmt.executeQuery("select id from component where component='" + entry.getComponent() + "' and logpath_id='" + logPathId + "'");
                    if (rs.next()) {
                        componentId = rs.getInt(1);
                    }
                    rs.close();
                    stmt.close();
                }
                if (time != -1.0) {
                    this.connection.setAutoCommit(false);
                    this.insertComponentTimeStmt.setInt(1, componentId);
                    this.insertComponentTimeStmt.setDouble(2, 0.0);
                    this.insertComponentTimeStmt.addBatch();
                    this.insertComponentTimeStmt.executeBatch();
                    this.connection.commit();
                    this.insertComponentTimeStmt.clearBatch();
                    stmt = this.readConnection.createStatement();
                    stmt.executeUpdate("UPDATE componenttime SET time= (time  + " + time + ") WHERE cid = " + componentId);
                    stmt.close();
                    this.readConnection.close();
                }
                if (entry.getPriority() != Priority.DEFAULT) {
                    this.insertMetaDataEntryStmt.setInt(1, entry.getPriority().getValue());
                    this.insertMetaDataEntryStmt.setInt(2, componentId);
                    this.insertMetaDataEntryStmt.setInt(3, entry.getLineNumber());
                    this.insertMetaDataEntryStmt.setString(4, entry.getText());
                    this.insertMetaDataEntryStmt.addBatch();
                    ++this.entryCacheSize;
                    if (this.entryCacheSize >= 500) {
                        this.writeLogDataToDB();
                        this.entryCacheSize = 0;
                    }
                }
            }
            catch (SQLException ex) {
                throw new BuildException("Exception while writing the records into Metadata DB", (Throwable)ex);
            }
            catch (Exception ex1) {
                throw new BuildException("Exception while writing the records into Metadata DB", (Throwable)ex1);
            }
            return;
        }
    }

    public static class LogEntry {
        private String text;
        private Priority priority;
        private String component;
        private int lineNumber;
        private String logPath;
        private float elapsedTime;

        public LogEntry(String text, Priority priority, String component, String logPath, int lineNumber, float time) {
            this.text = text;
            this.priority = priority;
            this.component = component;
            this.lineNumber = lineNumber;
            this.logPath = logPath;
            this.elapsedTime = time;
        }

        public LogEntry(String text, Priority priority, String component, String logPath, int lineNumber) {
            this(text, priority, component, logPath, lineNumber, -1.0f);
        }

        public LogEntry(String text, String priorityTxt, String component, String logPath, int lineNumber, float time) throws Exception {
            Priority prty = null;
            String prtyText = priorityTxt.trim().toLowerCase();
            if (prtyText.equals("error")) {
                prty = Priority.ERROR;
            } else if (prtyText.equals("warning")) {
                prty = Priority.WARNING;
            } else if (prtyText.equals("fatal")) {
                prty = Priority.FATAL;
            } else if (prtyText.equals("info")) {
                prty = Priority.INFO;
            } else if (prtyText.equals("remark")) {
                prty = Priority.REMARK;
            } else if (prtyText.equals("default")) {
                prty = Priority.DEFAULT;
            } else if (prtyText.equals("critical")) {
                prty = Priority.CRITICAL;
            } else {
                log.debug((Object)("Error: priority " + prtyText + " is not acceptable by metadata and set to Error"));
                prty = Priority.ERROR;
            }
            this.logPath = logPath;
            this.text = text;
            this.priority = prty;
            this.component = component;
            this.lineNumber = lineNumber;
            this.elapsedTime = time;
        }

        public LogEntry(String text, String priorityTxt, String component, String logPath, int lineNumber) throws Exception {
            this(text, priorityTxt, component, logPath, lineNumber, -1.0f);
        }

        public String getLogPath() {
            return this.logPath;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Priority getPriority() {
            return this.priority;
        }

        public double getElapsedTime() {
            return this.elapsedTime;
        }

        public void setPriority(Priority priority) {
            this.priority = priority;
        }

        public String getComponent() {
            return this.component;
        }

        public void setComponent(String component) {
            this.component = component;
        }
    }

    public static enum Priority {
        FATAL(1),
        ERROR(2),
        WARNING(3),
        INFO(4),
        REMARK(5),
        DEFAULT(6),
        CRITICAL(7);

        private final int value;

        private Priority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Priority getPriorityEnum(int i) {
            Priority[] values = Priority.values();
            return i >= 0 && i < values.length ? values[i] : FATAL;
        }
    }
}

