/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.logger.ant.listener;

import com.nokia.helium.logger.ant.listener.AntLogRecorderEntry;
import com.nokia.helium.logger.ant.listener.Handler;
import com.nokia.helium.logger.ant.listener.StatusAndLogListener;
import com.nokia.helium.logger.ant.types.Stage;
import com.nokia.helium.logger.ant.types.StageLogging;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.LogLevel;

public class AntLoggingHandler
implements Handler {
    private static Hashtable recorderEntries = new Hashtable();
    private Boolean append;
    private int loglevel = -1;
    private VerbosityLevelChoices antLogLevel;
    private Map<String, Stage> stagesMapping;
    private Map<String, StageLogging> stageRecordMap;
    private Map<String, StageLogging> defaultRecordMap;
    private Map<Stage, Target> depStartTargetMap;
    private boolean isStagesIntialized;
    private boolean isRecordingStarted;
    private AntLogRecorderEntry recorderEntry;
    private boolean isRecorderEntryRegistered;
    private boolean isDefaultRecorderEntryRegistered;
    private Logger log = Logger.getLogger(AntLoggingHandler.class);
    private boolean isInitDepStartTarget;
    private String currentStageName;

    public AntLoggingHandler() {
        this.antLogLevel = new VerbosityLevelChoices();
        this.stagesMapping = new HashMap<String, Stage>();
        this.stageRecordMap = new HashMap<String, StageLogging>();
        this.defaultRecordMap = new HashMap<String, StageLogging>();
        this.depStartTargetMap = new HashMap<Stage, Target>();
    }

    @Override
    public void handleTargetFinished(BuildEvent event) {
        String stageName = this.getStopStageName(event.getTarget().getName());
        if (stageName != null && this.getIsRecordingStarted()) {
            this.stopStageAntLog(stageName);
            this.startDefaultAntLog();
        }
        this.log.debug((Object)("Finishing target [" + event.getTarget().getName() + "]"));
    }

    @Override
    public void handleTargetStarted(BuildEvent event) {
        if (!this.isDefaultRecorderEntryRegistered) {
            this.log.debug((Object)"Intializing deafult recorder information and registering the recorder");
            this.initDefaultAntLogStage(event);
            this.registerDefaultRecorderEntry();
        }
        if (!this.isStagesIntialized()) {
            this.log.debug((Object)"Intializing stages information");
            this.getStagesInformation(event);
        }
        if (!this.isInitDepStartTarget() && this.isStagesIntialized()) {
            this.log.debug((Object)"Intializing dependent targets stage information.");
            this.initDepStartTarget(event);
        }
        if (!this.isRecorderEntryRegistered && this.isStagesIntialized()) {
            this.log.debug((Object)"Registering recorder entries.");
            this.registerRecorderEntry(event);
        }
        this.log.debug((Object)("Starting target [" + event.getTarget().getName() + "]"));
        String stageName = this.getStartStageName(event.getTarget().getName());
        if (stageName != null && !this.getIsRecordingStarted()) {
            this.stopDefaultAntLog(stageName);
            this.startStageAntLog(stageName);
        }
    }

    @Override
    public void handleBuildStarted(BuildEvent event) {
    }

    @Override
    public void handleBuildFinished(BuildEvent event) {
        String time = this.getDateTime();
        StageLogging stageLogging = this.defaultRecordMap.get("default");
        if (stageLogging != null) {
            File logFile = new File(stageLogging.getDefaultOutput());
            if (logFile.exists()) {
                this.recorderEntry = this.getRecorder(stageLogging.getDefaultOutput(), StatusAndLogListener.getProject());
                this.recorderEntry.addLogMessage("Stopping main Ant logging at " + time + " into " + stageLogging.getDefaultOutput());
                this.recorderEntry.setRecordState(false);
            }
        } else {
            this.log.debug((Object)"Could not find default recorder configuration.");
        }
        this.cleanup();
    }

    public void startStageAntLog(String stageName) {
        String time = this.getDateTime();
        this.log.debug((Object)("Starting stagerecorder for stage [" + stageName + "]"));
        StageLogging startStageLogging = this.stageRecordMap.get(stageName);
        File logFile = new File(startStageLogging.getOutput());
        if (logFile.exists()) {
            this.recorderEntry = this.getRecorder(startStageLogging.getOutput(), StatusAndLogListener.getProject());
            this.recorderEntry.setRecordState(true);
            this.recorderEntry.addLogMessage("Starting logging for stage \"" + stageName + "\" into " + startStageLogging.getOutput() + " at " + time);
            this.isRecordingStarted = true;
            this.currentStageName = stageName;
        }
    }

    public void stopStageAntLog(String stageName) {
        String time = this.getDateTime();
        this.log.debug((Object)("Stopping stagerecorder for stage [" + stageName + "]"));
        StageLogging stopStageLogging = this.stageRecordMap.get(stageName);
        StageLogging defaultStageLogging = this.defaultRecordMap.get("default");
        this.recorderEntry.addLogMessage("Stopping logging for stage \"" + stageName + "\" into " + stopStageLogging.getOutput() + " at " + time);
        this.recorderEntry.addLogMessage("Starting logging into " + defaultStageLogging.getDefaultOutput());
        this.recorderEntry = this.getRecorder(stopStageLogging.getOutput(), StatusAndLogListener.getProject());
        this.recorderEntry.setRecordState(false);
        this.isRecordingStarted = false;
        this.currentStageName = null;
    }

    protected AntLogRecorderEntry getRecorder(String name, Project proj) {
        AntLogRecorderEntry entry;
        Object o = recorderEntries.get(name);
        if (o == null) {
            entry = new AntLogRecorderEntry(name);
            if (this.append == null) {
                entry.openFile(false);
            } else {
                entry.openFile(this.append);
            }
            entry.setProject(proj);
            recorderEntries.put(name, entry);
        } else {
            entry = (AntLogRecorderEntry)o;
        }
        return entry;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setLoglevel(VerbosityLevelChoices level) {
        this.loglevel = level.getLevel();
    }

    private void getStagesInformation(BuildEvent event) {
        this.isStagesIntialized = true;
        Hashtable references = event.getProject().getReferences();
        Enumeration keyEnum = references.keys();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            if (!(references.get(key) instanceof Stage)) continue;
            Stage tempStage = (Stage)((Object)references.get(key));
            this.log.debug((Object)("Found  stage [" + key + "] for recording"));
            if (!this.validateStageTargets(event, tempStage.getStartTarget(), tempStage.getEndTarget())) continue;
            this.log.debug((Object)("Start and end targets are valid for stage [" + key + "]"));
            this.stagesMapping.put(key, (Stage)((Object)references.get(key)));
            this.getStageRecordInformation(event, key, tempStage.getStartTarget(), tempStage.getEndTarget());
        }
    }

    private boolean isStagesIntialized() {
        return this.isStagesIntialized;
    }

    private void getStageRecordInformation(BuildEvent event, String stageKey, String startTarget, String endTarget) {
        Hashtable references = event.getProject().getReferences();
        Enumeration keyEnum = references.keys();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            if (!(references.get(key) instanceof StageLogging)) continue;
            StageLogging tempStageLogging = (StageLogging)((Object)references.get(key));
            if (tempStageLogging.getStageRefID() == null && tempStageLogging.getDefaultOutput() == null) {
                throw new BuildException("stagefefid attribute should be specified for stagerecord [" + key + "]");
            }
            if (tempStageLogging.getStageRefID() == null || !tempStageLogging.getStageRefID().equalsIgnoreCase(stageKey) || tempStageLogging.getDefaultOutput() != null) continue;
            this.log.debug((Object)("stagerecord reference for stage [" + stageKey + "] is [" + tempStageLogging.getStageRefID() + "]"));
            if (tempStageLogging.getOutput() == null) {
                throw new BuildException("output attribute should be specified for stagerecord [" + key + "]");
            }
            this.stageRecordMap.put(stageKey, tempStageLogging);
        }
    }

    private void initDefaultAntLogStage(BuildEvent event) {
        Hashtable references = event.getProject().getReferences();
        Enumeration keyEnum = references.keys();
        while (keyEnum.hasMoreElements()) {
            StageLogging tempStageLogging;
            String key = (String)keyEnum.nextElement();
            if (!(references.get(key) instanceof StageLogging) || (tempStageLogging = (StageLogging)((Object)references.get(key))).getStageRefID() != null || tempStageLogging.getDefaultOutput() == null) continue;
            this.defaultRecordMap.put("default", tempStageLogging);
        }
    }

    private boolean validateStageTargets(BuildEvent event, String startTarget, String endTarget) {
        Hashtable antTargets = event.getProject().getTargets();
        return antTargets.containsKey(startTarget) && antTargets.containsKey(endTarget);
    }

    private String getStartStageName(String targetName) {
        for (Map.Entry<String, Stage> entry : this.stagesMapping.entrySet()) {
            Stage stage = entry.getValue();
            if (stage.getStartTarget().equalsIgnoreCase(targetName)) {
                this.log.debug((Object)("stageName name for target [" + targetName + "] is [" + entry.getKey() + "]"));
                return entry.getKey();
            }
            for (Map.Entry<Stage, Target> depEntry : this.depStartTargetMap.entrySet()) {
                Stage depStage = depEntry.getKey();
                if (!depStage.getStartTarget().equalsIgnoreCase(stage.getStartTarget()) || !depEntry.getValue().getName().equalsIgnoreCase(targetName)) continue;
                this.log.debug((Object)("stageName name for depending target [" + depStage.getStartTarget() + "] is [" + entry.getKey() + "]"));
                return entry.getKey();
            }
        }
        return null;
    }

    private String getStopStageName(String targetName) {
        for (Map.Entry<String, Stage> entry : this.stagesMapping.entrySet()) {
            Stage stage = entry.getValue();
            if (!stage.getEndTarget().equalsIgnoreCase(targetName)) continue;
            this.log.debug((Object)("stageName name for end target [" + targetName + "] is [" + entry.getKey() + "]"));
            return entry.getKey();
        }
        return null;
    }

    private boolean getIsRecordingStarted() {
        return this.isRecordingStarted;
    }

    private void registerRecorderEntry(BuildEvent event) {
        for (Map.Entry<String, StageLogging> entry : this.stageRecordMap.entrySet()) {
            StageLogging stageLogging = entry.getValue();
            File logFile = new File(stageLogging.getOutput());
            if (!logFile.getParentFile().exists()) {
                logFile.getParentFile().mkdirs();
            }
            if (!logFile.getParentFile().exists()) continue;
            this.log.debug((Object)("Registering recorderentry for log file [" + stageLogging.getOutput() + "]"));
            this.setAppend(stageLogging.getAppend());
            this.recorderEntry = this.getRecorder(stageLogging.getOutput(), StatusAndLogListener.getProject());
            this.antLogLevel.setValue(stageLogging.getLogLevel());
            this.setLoglevel(this.antLogLevel);
            this.recorderEntry.setMessageOutputLevel(this.loglevel);
            this.recorderEntry.setEmacsMode(false);
            this.recorderEntry.setRecordState(false);
            this.isRecorderEntryRegistered = true;
        }
    }

    private void registerDefaultRecorderEntry() {
        if (this.defaultRecordMap.size() == 0) {
            throw new BuildException("There is no stagerecord type with defaultoutput attribute set. please set...");
        }
        StageLogging stageLogging = this.defaultRecordMap.get("default");
        File logFile = new File(stageLogging.getDefaultOutput());
        if (!logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdirs();
        }
        if (logFile.getParentFile().exists()) {
            this.log.debug((Object)("Registering recorderentry for log file [" + stageLogging.getDefaultOutput() + "]"));
            this.setAppend(stageLogging.getAppend());
            this.recorderEntry = this.getRecorder(stageLogging.getDefaultOutput(), StatusAndLogListener.getProject());
            this.antLogLevel.setValue(stageLogging.getLogLevel());
            this.setLoglevel(this.antLogLevel);
            this.recorderEntry.setMessageOutputLevel(this.loglevel);
            this.recorderEntry.setEmacsMode(false);
            this.recorderEntry.setRecordState(true);
            String time = this.getDateTime();
            this.recorderEntry.addLogMessage("Starting main Ant logging at " + time + " into " + stageLogging.getDefaultOutput());
            this.isDefaultRecorderEntryRegistered = true;
        }
    }

    private void cleanup() {
        this.log.debug((Object)"Cleaning up recorder entries of stagerecord");
        StatusAndLogListener.getProject().removeBuildListener((BuildListener)this.recorderEntry);
        recorderEntries.clear();
    }

    private boolean isInitDepStartTarget() {
        return this.isInitDepStartTarget;
    }

    private void initDepStartTarget(BuildEvent event) {
        Vector arrayList = null;
        this.isInitDepStartTarget = true;
        for (Map.Entry<String, Stage> entry : this.stagesMapping.entrySet()) {
            Stage stage = entry.getValue();
            arrayList = event.getProject().topoSort(stage.getStartTarget(), event.getProject().getTargets(), false);
            if (arrayList == null || arrayList.size() <= 1) continue;
            this.depStartTargetMap.put(stage, (Target)arrayList.firstElement());
        }
    }

    private String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EE yyyy/MM/dd HH:mm:ss:SS aaa");
        Date date = new Date();
        return dateFormat.format(date);
    }

    private void stopDefaultAntLog(String stageName) {
        String time = this.getDateTime();
        StageLogging defaultStageLogging = this.defaultRecordMap.get("default");
        StageLogging stageLogging = this.stageRecordMap.get(stageName);
        File logFile = new File(defaultStageLogging.getDefaultOutput());
        if (logFile.exists()) {
            this.recorderEntry = this.getRecorder(defaultStageLogging.getDefaultOutput(), StatusAndLogListener.getProject());
            this.recorderEntry.addLogMessage("Stopping logging into " + defaultStageLogging.getDefaultOutput() + " and starting logging for stage \"" + stageName + "\" at " + time);
            this.recorderEntry.addLogMessage("Starting logging into " + stageLogging.getOutput());
            this.recorderEntry.setRecordState(false);
        }
    }

    private void startDefaultAntLog() {
        String time = this.getDateTime();
        StageLogging stageLogging = this.defaultRecordMap.get("default");
        this.recorderEntry = this.getRecorder(stageLogging.getDefaultOutput(), StatusAndLogListener.getProject());
        this.recorderEntry.addLogMessage("Resuming logging into " + stageLogging.getDefaultOutput() + " at " + time);
        this.recorderEntry.setRecordState(true);
    }

    public String getCurrentStageName() {
        return this.currentStageName;
    }

    public void doLoggingAction(String stageName, boolean action, String message, Task task) {
        String fileName;
        String time = this.getDateTime();
        StageLogging stageLogging = null;
        if (stageName.equalsIgnoreCase("default")) {
            stageLogging = this.defaultRecordMap.get(stageName);
            fileName = stageLogging.getDefaultOutput();
        } else {
            stageLogging = this.stageRecordMap.get(stageName);
            fileName = stageLogging.getOutput();
        }
        File logFile = new File(fileName);
        if (logFile.exists()) {
            this.recorderEntry = this.getRecorder(fileName, StatusAndLogListener.getProject());
            this.recorderEntry.addLogMessage(message + " logging into " + fileName + " from " + task.getTaskName() + " task at " + time);
            this.recorderEntry.setRecordState(action);
        }
    }

    public void addRegExp(String regExp) {
        if (!regExp.equals("")) {
            AntLogRecorderEntry recorderEntry;
            File logFile;
            StageLogging stageLogging;
            for (Map.Entry<String, StageLogging> entry : this.defaultRecordMap.entrySet()) {
                stageLogging = entry.getValue();
                logFile = new File(stageLogging.getDefaultOutput());
                if (!logFile.exists()) continue;
                recorderEntry = this.getRecorder(stageLogging.getDefaultOutput(), StatusAndLogListener.getProject());
                recorderEntry.addRegexp(regExp);
            }
            for (Map.Entry<String, StageLogging> entry : this.stageRecordMap.entrySet()) {
                stageLogging = entry.getValue();
                logFile = new File(stageLogging.getOutput());
                if (!logFile.exists()) continue;
                recorderEntry = this.getRecorder(stageLogging.getOutput(), StatusAndLogListener.getProject());
                recorderEntry.addRegexp(regExp);
            }
        }
    }

    public static class VerbosityLevelChoices
    extends LogLevel {
    }
}

