/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.MetaDataInput;
import com.nokia.helium.metadata.ant.types.MetaDataFilter;
import com.nokia.helium.metadata.ant.types.MetaDataFilterSet;
import com.nokia.helium.metadata.db.MetaDataDb;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FileSet;

public abstract class LogMetaDataInput
extends DataType
implements MetaDataInput {
    private static final String DEFAULT_COMPONENT_NAME = "general";
    private static Logger log = Logger.getLogger(LogMetaDataInput.class);
    private Vector<FileSet> fileSetList = new Vector();
    private int currentFileIndex;
    private boolean entryAddedForLog;
    private List<File> fileList;
    private Vector<MetaDataFilterSet> metadataFilterSets = new Vector();
    private Vector<MetaDataFilter> completeFilterList;
    private Iterator<MetaDataDb.LogEntry> metadataInputIterator = new MetaDataInputIterator();
    private List<MetaDataDb.LogEntry> logEntries = new ArrayList<MetaDataDb.LogEntry>();

    public void add(FileSet fileSet) {
        this.fileSetList.add(fileSet);
    }

    public void add(MetaDataFilterSet metadataFilterSet) {
        this.metadataFilterSets.add(metadataFilterSet);
    }

    public MetaDataFilterSet createMetaDataFilterSet() {
        MetaDataFilterSet filterSet = new MetaDataFilterSet();
        this.add(filterSet);
        return filterSet;
    }

    private Vector<MetaDataFilter> getCompleteFilters() throws Exception {
        Vector<MetaDataFilter> allFilter = new Vector<MetaDataFilter>();
        for (MetaDataFilterSet filterSet : this.metadataFilterSets) {
            allFilter.addAll(filterSet.getAllFilters());
        }
        return allFilter;
    }

    private List<File> getFileListFromFileSet() {
        this.fileList = new ArrayList<File>();
        for (FileSet fs : this.fileSetList) {
            String[] includedFiles;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            for (String file : includedFiles = ds.getIncludedFiles()) {
                this.fileList.add(new File(ds.getBasedir(), file));
                log.debug((Object)("includedfiles: " + file));
            }
        }
        log.debug((Object)("fileList.size" + this.fileList.size()));
        return this.fileList;
    }

    private MetaDataDb.LogEntry getEntry() throws Exception {
        if (this.logEntries != null && this.logEntries.size() > 0) {
            return this.logEntries.remove(0);
        }
        throw new Exception("No entries found");
    }

    protected List<File> getFileList() {
        return this.fileList;
    }

    protected File getCurrentFile() {
        List<File> fileList = this.getFileList();
        return fileList.get(this.currentFileIndex);
    }

    boolean isEntryAvailable() throws Exception {
        try {
            int fileListSize = this.getFileList().size();
            while (this.currentFileIndex < fileListSize) {
                boolean entryCreated = false;
                File currentFile = this.getCurrentFile();
                entryCreated = this.isEntryCreated(currentFile);
                if (entryCreated) {
                    if (!this.entryAddedForLog) {
                        this.entryAddedForLog = true;
                    }
                    return entryCreated;
                }
                if (!this.entryAddedForLog) {
                    this.addEntry("default", DEFAULT_COMPONENT_NAME, this.getCurrentFile().toString(), -1, "", -1.0f);
                    ++this.currentFileIndex;
                    return true;
                }
                ++this.currentFileIndex;
            }
        }
        catch (Exception ex1) {
            log.debug((Object)"exception while parsing the stream", (Throwable)ex1);
            throw ex1;
        }
        return false;
    }

    abstract boolean isEntryCreated(File var1) throws Exception;

    protected String getSeverity(String logText) throws Exception {
        try {
            if (this.completeFilterList == null) {
                this.completeFilterList = this.getCompleteFilters();
            }
            for (MetaDataFilter filter : this.completeFilterList) {
                Pattern pattern = filter.getPattern();
                if (!pattern.matcher(logText).matches()) continue;
                return filter.getPriority();
            }
        }
        catch (Exception ex) {
            log.debug((Object)"Exception while getting severity", (Throwable)ex);
            throw ex;
        }
        return null;
    }

    protected void addEntry(String priority, String component, String logPath, int lineNo, String logText) throws Exception {
        this.addEntry(priority, component, logPath, lineNo, logText, -1.0f);
    }

    protected void addEntry(String priority, String component, String logPath, int lineNo, String logText, float elapsedTime) throws Exception {
        File logPathFile = new File(logPath.trim());
        String baseDir = logPathFile.getParent();
        String uniqueLogPath = baseDir + "/" + logPathFile.getName();
        this.logEntries.add(new MetaDataDb.LogEntry(logText, priority, component, uniqueLogPath, lineNo, elapsedTime));
    }

    protected boolean findAndAddEntries(String logTextInfo, String currentComponent, String logPath, int lineNumber) throws Exception {
        return this.findAndAddEntries(logTextInfo, currentComponent, logPath, lineNumber, null);
    }

    protected boolean findAndAddEntries(String logTextInfo, String currentComponent, String logPath, int lineNumber, Statistics stat) throws Exception {
        boolean entryAdded = false;
        String[] logText = logTextInfo.split("\n");
        String severity = null;
        for (int i = 0; i < logText.length; ++i) {
            severity = this.getSeverity(logText[i]);
            if (severity == null) continue;
            if (stat != null) {
                stat.incrementSeverity(severity);
            }
            this.addEntry(severity, currentComponent, logPath, i + lineNumber, logText[i]);
            if (entryAdded) continue;
            entryAdded = true;
        }
        return entryAdded;
    }

    @Override
    public Iterator<MetaDataDb.LogEntry> iterator() {
        return this.metadataInputIterator;
    }

    public class Statistics {
        private Map<String, Integer> statistics = new Hashtable<String, Integer>();

        public void incrementSeverity(String severity) {
            if (this.statistics.get(severity = severity.toLowerCase()) == null) {
                this.statistics.put(severity, new Integer(1));
            } else {
                this.statistics.put(severity, new Integer(this.statistics.get(severity) + 1));
            }
        }

        public int getSeveriry(String severity) {
            if (this.statistics.get(severity = severity.toLowerCase()) == null) {
                return 0;
            }
            return this.statistics.get(severity);
        }
    }

    public class MetaDataInputIterator
    implements Iterator<MetaDataDb.LogEntry> {
        @Override
        public boolean hasNext() {
            if (LogMetaDataInput.this.fileList == null) {
                LogMetaDataInput.this.fileList = LogMetaDataInput.this.getFileListFromFileSet();
                if (LogMetaDataInput.this.fileList.isEmpty()) {
                    throw new BuildException(" No input found.");
                }
            }
            if (LogMetaDataInput.this.logEntries.size() > 0) {
                return true;
            }
            boolean retValue = false;
            try {
                retValue = LogMetaDataInput.this.isEntryAvailable();
            }
            catch (Exception ex) {
                String message = ex.getMessage();
                if (message == null) {
                    message = "";
                }
                throw new BuildException("Exception while analysing errors from the log:\n " + message, (Throwable)ex);
            }
            return retValue;
        }

        @Override
        public void remove() {
        }

        @Override
        public MetaDataDb.LogEntry next() {
            MetaDataDb.LogEntry entry = null;
            try {
                entry = LogMetaDataInput.this.getEntry();
            }
            catch (Exception ex) {
                log.debug((Object)"Exception while getting entry: ", (Throwable)ex);
            }
            return entry;
        }
    }
}

