/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/01/26 21:32:29 $
 * $Revision: 1.4 $
 */

#ifndef __MSL_CALLINGCONV_WIN32_H_
#define __MSL_CALLINGCONV_WIN32_H_

/* These macros are used for defaultlibs.win32.h */
#define _MSL_CALLINGCONV_CDECL		0
#define _MSL_CALLINGCONV_3DCALL		1
#define _MSL_CALLINGCONV_SSECALL	2
#define _MSL_CALLINGCONV_SSE2CALL	3

#ifndef _MSL_CALLINGCONV

	#ifndef _MSL_CDECL
		/* 	If we're here, we're building/using a target-specific library,
			so all functions use the same calling convention.  
			
			We don't build multimedia libraries for single-threaded,
			MS exceptions, or WinSIOUX, so restrict the library to
			a generic __cdecl interface when these are combined.
			This is _possible_, though, so feel free to add new MSL targets
			on your own and modify these tests.
		*/
		#if !__option(mmcalls) || __option(microsoft_exceptions) || _WINSIOUX || !defined(_MT)
			#define _MSL_CDECL			__cdecl
			#define _MSL_CALLINGCONV	_MSL_CALLINGCONV_CDECL
		#else
			#if __option(k63d) && !__option(sse)
				#define _MSL_CDECL			__3dcall
				#define _MSL_CALLINGCONV	_MSL_CALLINGCONV_3DCALL
			/*
			feeling experimental?  modify <defaultlibs.win32.h> accordingly.
			#elif __option(sse2)
				#define _MSL_CDECL			__sse2call
				#define _MSL_CALLINGCONV	_MSL_CALLINGCONV_SSE2CALL
			#elif __option(sse)
				#define _MSL_CDECL			__ssecall
				#define _MSL_CALLINGCONV	_MSL_CALLINGCONV_SSECALL
			*/
			#else
				#define _MSL_CDECL			__cdecl
				#define _MSL_CALLINGCONV	_MSL_CALLINGCONV_CDECL
			#endif
		#endif
	#endif

#endif	/*ifndef _MSL_CALLINGCONV*/

#ifndef _MSL_MATH_CDECL
#define _MSL_MATH_CDECL	_MSL_CDECL
#endif

#endif	/*__MSL_CALLINGCONV_WIN32_H_*/

/* Change record:
 * 020408 EJS Created
 * 020412 EJS Allow override of _MSL_CALLINGCONV
 */
 