/* Metrowerks Standard Library
 * Copyright  1995-2004 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/02/17 17:37:56 $
 * $Revision: 1.20 $
 */

#include <crtl.h>
#include <errno.h>
#include <extras.h>     
#include <direct.h>
#include <fcntl.h>
#include <malloc.h>
#include <io.h>
#include <file_io.h>     			
#include <sysenv_api.h>
#include <timeb.h>
#include <time_api.h>
#include <wstring.h>
#include <wcstoul.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#if _MSL_WIDE_CHAR

int _MSL_CDECL _wcsicoll(const wchar_t *s1, const wchar_t *s2)  _MSL_CANT_THROW
{
	return wcsicmp(s1, s2);
}

int _MSL_CDECL _wcsnicoll(const wchar_t *s1, const wchar_t *s2, __std(size_t) sz) _MSL_CANT_THROW
{
	return wcsnicmp(s1, s2, sz);
}

int _MSL_CDECL _wcsncoll(const wchar_t *s1, const wchar_t *s2, __std(size_t) sz)  _MSL_CANT_THROW
{
	return wcsncmp(s1, s2, sz);
}

wchar_t * _MSL_CDECL _wcsdup (const wchar_t *str) _MSL_CANT_THROW
{
	return wcsdup(str);
}	

wchar_t * _MSL_CDECL _wcsspnp(const wchar_t *s1, const wchar_t *s2) _MSL_CANT_THROW
{
	return wcsspnp(s1,s2);
}

wchar_t * _MSL_CDECL _wcsnset(wchar_t *str, wchar_t wc, size_t n) _MSL_CANT_THROW
{
	return wcsnset(str,wc,n);
}

wchar_t * _MSL_CDECL _wcsset(wchar_t *str, wchar_t wc) _MSL_CANT_THROW
{
	return wcsset(str,wc);
}

wchar_t * _MSL_CDECL _wcslwr (wchar_t *str) _MSL_CANT_THROW
{
	return wcslwr(str);
}

wchar_t * _MSL_CDECL _wcsupr (wchar_t *str) _MSL_CANT_THROW
{
	return wcsupr(str);
}

wchar_t * _MSL_CDECL _wcsrev(wchar_t *str) _MSL_CANT_THROW
{
	return wcsrev(str);
}

wchar_t * _MSL_CDECL _wstrrev(wchar_t * str) _MSL_CANT_THROW
{
	return wstrrev(str);
}

int _MSL_CDECL _wcsnicmp(const wchar_t *s1, const wchar_t *s2, size_t n) _MSL_CANT_THROW
{
    return wcsnicmp(s1, s2, n);
}

int _MSL_CDECL _wcsicmp(const wchar_t *s1, const wchar_t *s2) _MSL_CANT_THROW
{
	return wcsicmp( s1, s2);
}

int _MSL_CDECL _wtoi(const wchar_t *_a) _MSL_CANT_THROW     
{
	return wcstol(_a, NULL, 10);
}

wchar_t* _MSL_CDECL _itow(int val, wchar_t *str, int radix) _MSL_CANT_THROW
{
	return itow(val, str, radix);
}

#endif /* _MSL_WIDE_CHAR */

char * _MSL_CDECL _strdate(char *str) _MSL_CANT_THROW
{
    return strdate(str);
}

int _MSL_CDECL _strnicoll(const char *s1, const char *s2, __std(size_t) sz)  _MSL_CANT_THROW
{
	return strnicmp(s1, s2, sz);
}

int _MSL_CDECL _strncoll(const char *s1, const char *s2, __std(size_t) sz) _MSL_CANT_THROW
{
	return strncmp(s1, s2, sz);
}

int _MSL_CDECL _stricoll(const char *s1, const char *s2) _MSL_CANT_THROW
{
	return stricmp(s1, s2);
}

char * _MSL_CDECL _strlwr (char *string) _MSL_CANT_THROW
{
	return strlwr (string);
}

char * _MSL_CDECL _strdup(const char *str) _MSL_CANT_THROW
{
		return __msl_strdup(str);
}

char * _MSL_CDECL _strspnp(char *s1, const char *s2) _MSL_CANT_THROW
{
	return strspnp(s1,s2);
}

char * _MSL_CDECL _strnset(char *str, int c, size_t n) _MSL_CANT_THROW
{
	return strnset(str,c,n);
} 
 
char * _MSL_CDECL _strset(char *str, int c) _MSL_CANT_THROW
{
	return strset(str, c);
}

char * _MSL_CDECL _strupr(char *str) _MSL_CANT_THROW
{
	return strupr(str);
}

char * _MSL_CDECL _strrev(char * str) _MSL_CANT_THROW
{
	return __msl_strrev(str);
}

int	_MSL_CDECL _strncasecmp(const char *s1, const char *s2, size_t n) _MSL_CANT_THROW
{
	return __msl_strnicmp(s1,s2, n);	
}

int _MSL_CDECL _strcasecmp(const char *s1, const char *s2) _MSL_CANT_THROW
{
	return stricmp(s1,s2);
}

int _MSL_CDECL _strncmpi(const char *s1, const char *s2, size_t n) _MSL_CANT_THROW
{
	return __msl_strnicmp(s1,s2, n);	
}

int _MSL_CDECL _strcmpi(const char *s1, const char *s2) _MSL_CANT_THROW
{
	return stricmp(s1,s2);
}

int _MSL_CDECL _strnicmp(const char *s1, const char *s2, size_t n) _MSL_CANT_THROW
{
    return __msl_strnicmp(s1,s2, n);
}

int _MSL_CDECL _stricmp(const char *s1, const char *s2) _MSL_CANT_THROW
{
	return stricmp(s1,s2);
}

char * _MSL_CDECL _itoa(int val, char *str, int radix)  _MSL_CANT_THROW
{
	return __msl_itoa(val, str, radix);
}

char * _MSL_CDECL _ultoa(unsigned long val, char *str, int radix) _MSL_CANT_THROW
{
	return ultoa(val,str,radix);
}

/* Convert a value as a g format */
#if _MSL_FLOATING_POINT
char * _MSL_CDECL _gcvt(double value, int digits, char *buffer) _MSL_CANT_THROW
{
    return gcvt(value, digits, buffer);
}
#endif

int _MSL_CDECL _heapmin(void) _MSL_CANT_THROW
{							
    return heapmin();
}

int _MSL_CDECL _filelength(int fileno) _MSL_CANT_THROW
{
	return filelength(fileno);
}
	
int _MSL_CDECL _chsize( int handle, long size ) _MSL_CANT_THROW
{
	return chsize(handle, size);
}

int _MSL_CDECL _chdrive(int drive) _MSL_CANT_THROW
{
    char path[3];
    
    if (drive < 1 || drive > 31) {
    	return -1;
    }
    path[0] = (char) ('A' + drive -1);
    path[1] = ':';
    path[2] = 0x00;
    
    if (SetCurrentDirectory(path))
    {
        return 0;
    }
    else
    {
        return -1;
    }
}

unsigned _MSL_CDECL _getdiskfree(unsigned drive, struct _diskfree_t *dfs) _MSL_CANT_THROW
{
	char path[4];
	
	if (drive > 26) 
		return -1;
	else {
		path[0] = (char) (drive + 'A' -1);
		path[1] = ':';
		path[2] = '\\';
		path[3] = 0x00;
	}
	
	if (!GetDiskFreeSpace(drive ? path : NULL,
			&(dfs->sectors_per_cluster), &(dfs->bytes_per_sector),&(dfs->avail_clusters),&(dfs->total_clusters)))
		return -1;
	return 0;
}


char * _MSL_CDECL _getdcwd(int drive, char *buffer, int maxlen) _MSL_CANT_THROW
{
	int n;
	char dir[_MAX_PATH];
	char *file;
	
	if (drive != 0) {
		char dstr[4];
		
		if (drive > 26) {
			errno = EACCES;
			return NULL;
		}
		
		dstr[0] = (char) (drive + 'A' -1);
		dstr[1] = ':';
		dstr[2] = '.';
		dstr[3] = 0x00;

		n = GetFullPathName(dstr,sizeof(dir),dir,&file);
	}
	else
		n = GetCurrentDirectory(sizeof(dir),dir);
		
	if (!n || ++n > sizeof(dir))
		return NULL;
		
	
	if (!buffer) {
		if (!(buffer = (char *) malloc(n > maxlen ? n : maxlen))) {
			errno = ENOMEM;
			return NULL;
		}
	}
	else 
		if (n > maxlen) {
			errno = ERANGE;
			return NULL;
		}
		
	return strcpy(buffer,dir);
}


int _MSL_CDECL _getdrive() _MSL_CANT_THROW
{
	char	dir[_MAX_PATH];
	int		drive = 0;
	
	if (GetCurrentDirectory(sizeof(dir),dir))
		if (dir[1] == ':')
			drive = toupper(dir[0]) - 'A' + 1;
			
	return drive;
	
}


unsigned long _MSL_CDECL _getdrives() _MSL_CANT_THROW
{
	return GetLogicalDrives();
}


void _MSL_CDECL _searchenv(const char *filename, const char *varname, char *pathname) _MSL_CANT_THROW
{
    char buffer[1024], *cp;
    
    GetEnvironmentVariable(varname, buffer, sizeof(buffer));
    SearchPath(buffer, filename, "", _MAX_PATH, pathname, &cp);
}

/* Return operating system file handle (as opposed to C file handle)*/
long _MSL_CDECL _get_osfhandle(int filehandle) _MSL_CANT_THROW
{
    if (filehandle < 0 || filehandle > NUM_HANDLES || _HandleTable[filehandle] == NULL)
    {
        return -1;
    }
    return (long)_HandleTable[filehandle]->handle;
}


/* Open an operating system handle as a C file handle */
int _MSL_CDECL _open_osfhandle(long ofshandle, int flags) _MSL_CANT_THROW
{
    int h;
    
    h = __msl_GetHandle();
    if (h == -1)
    {
        return -1;
    }
	_HandleTable[h] = (FileStruct *)malloc(sizeof(FileStruct));
	if (!_HandleTable[h])
	{
	    return -1;
	}
	
    
    _HandleTable[h]->handle = (HANDLE)ofshandle;
    _HandleTable[h]->translate = (flags & O_BINARY) == 0;
    _HandleTable[h]->append = (flags & O_APPEND) != 0;
    
    return h;
}

/* Allocate memory on the stack */
__declspec(naked) void * _alloca(size_t /*size*/) _MSL_CANT_THROW
{
    asm
    {
     	pop		ecx				// pop return address
     	pop		eax				// get amount to alloc
     	sub		esp, eax		// subtract from stack pointer
     	mov		eax, esp		// and return the new stack pointer
     	push	eax				// leave something for the caller to pop
     	jmp		ecx
    }    
}


char * _MSL_CDECL _fullpath(char * absPath, const char * relPath, size_t maxLength) _MSL_CANT_THROW
{
	/* Take paths such as:
	   A:\DIR\file
	   DIR\file
	  .\file
	  file
	  \DIR\DIRB\..\file
	  ..\DIR\file
	
	  And convert them to:
	  A:\DIR\file

	  There are several ways a pathname can start:
	  [Drive Letter]:
	  \[Root Directory or File]
      [Directory or File in Current Path] */

	return __msl_fullpath(absPath,relPath,maxLength);	/*- cc 010605 -*/
}

wchar_t * _MSL_CDECL _ltow(long val, wchar_t * str, int radix) _MSL_CANT_THROW
{
	int conversion_size;
	char buffer['\n'];
	
	ltoa(val,buffer,radix);
	conversion_size = strlen(buffer)+1;					/*- mm 030124 -*/
	mbstowcs( str, (char *) buffer, conversion_size );	/*- mm 030124 -*/
	return str;
}

wchar_t * _MSL_CDECL _ultow(unsigned long val , wchar_t * str, int radix) _MSL_CANT_THROW
{	
	int conversion_size;
	char buffer['\n'];
	
	ultoa(val,buffer,radix); 
	conversion_size = strlen(buffer) + 1;
	mbstowcs( str, (char *) buffer, conversion_size );
	return str;
}
int _MSL_CDECL putenv(const char * inVarName) _MSL_CANT_THROW
{
	return __msl_putenv(inVarName);
}

int _MSL_CDECL _putenv(const char * inVarName) _MSL_CANT_THROW
{
	return __msl_putenv(inVarName);
}


/* splitpath takes a path and returns pointers to each of the
 * components of the path. */

void _MSL_CDECL splitpath (const char *path, char *drive, char *dir, char *fname, char *ext) _MSL_CANT_THROW
{
	const char *end, *dir_end_fwd, *dir_end_back;
	int sz;

	/* first, check for drive letter in string... we should find a colon
	 * in the second character position if its included. */

	if (path [1] == ':')
	{
		if (drive)
		{
			drive [0] = path [0];
			drive [1] = ':';
			drive [2] = '\0';
		}
		path += 2;		/* increment current position to beyond
						 * drive letter */
	}
#if 0	/*- ejs 030701: this is not the correct way -- MSVC sets drive="" and dir="\\server\share" -*/	
	else if ( (path[0] == '\\') && (path[1] == '\\') )
	{
   			/* check UNC path */
   			/* UNC Path check code was provided by Michael B. on 3/24/00 */
    	if (drive)
   		{
       		drive [0] = path [0];
       		drive [1] = '\0';
  		}
   		path += 1;        /* increment current position to beyond drive letter */
	}
#endif
	else if (drive != NULL)	/* if no drive, make empty */
		strcpy (drive, "");

	/* to find the directory, look for the last slash character */
  
	dir_end_back = strrchr (path, '\\');
	dir_end_fwd = strrchr (path, '/');

	/* use the one farthest to the end as the delimiter */

	if (dir_end_fwd && dir_end_back)
		end = (dir_end_fwd > dir_end_back ? dir_end_fwd : dir_end_back);
	else if (dir_end_fwd)
		end = dir_end_fwd;
	else
		end = dir_end_back;
  
	if (end == NULL)		/* if no dir, zero out path */
	{
		if (dir != NULL)
			strcpy (dir, "");
	}
	else			/* we have a directory */
	{
		if (dir != NULL)	/* do we need to copy it? */
		{
			/* obey some limits */
			sz = end - path + 1;
			if (sz + 1 >= _MAX_DIR)
				sz = _MAX_DIR - 1;

			memcpy (dir, path, sz);
			dir [sz] = '\0';
		}
		path = end + 1;		/* next search starts after dir */
	}

	/* now, we are at the filename... to isolate this, find the last
	 * period, everything up to this is filename, everything after is
	 * extension */

	end = strrchr (path, '.');

	if (end == NULL)		/* no extension */
	{
		end = path + strlen (path); /* set to end of string */
	}

	if (fname != NULL)
	{
		/* obey some limits */
		sz = end - path;
		if (sz + 1 >= _MAX_FNAME)
			sz = _MAX_FNAME - 1;

		memcpy (fname, path, sz);
		fname [sz] = '\0';
	}

	if (ext != NULL)
	{
		/* obey some limits */
		sz = strlen(end);
		if (sz + 1 >= _MAX_EXT)
			sz = _MAX_EXT - 1;

		memcpy (ext, end, sz);
		ext[sz] = '\0';
	}
}

void _MSL_CDECL _splitpath (const char *path, char *drive, char *dir, char *fname, char *ext) _MSL_CANT_THROW
{
	splitpath(path, drive, dir, fname, ext);
}

/* put together a path */
void _MSL_CDECL makepath(char *path, const char *drive, const char *dir, const char *fname, const char *ext) _MSL_CANT_THROW
{
    char ch;
    
    path[0] = 0;
    if (drive && drive[0])
    {
        strncat(path, drive, _MAX_PATH);
        if (path[strlen(path)-1] != ':')
        {
            strncat(path, ":", _MAX_PATH-strlen(path));
        }
    }
    if (dir && dir[0])
    {
        strncat(path, dir, _MAX_PATH-strlen(path));
        ch = path[strlen(path)-1];
        if (ch != '\\' && ch != '/')
        {
            strncat(path, "\\", _MAX_PATH-strlen(path));
        }
    }
    if (fname && fname[0])
    {
        strncat(path, fname, _MAX_PATH-strlen(path));
    }
    if (ext && ext[0])
    {
        if (ext[0] != '.')
        {
            strncat(path, ".", _MAX_PATH-strlen(path));
        }
        strncat(path, ext, _MAX_PATH-strlen(path));
    }
}


void _MSL_CDECL _makepath(char *path, const char *drive, const char *dir, const char *fname, const char *ext) _MSL_CANT_THROW
{
    makepath(path, drive, dir, fname, ext);
}


void _MSL_CDECL ftime(struct timeb *timeptr) _MSL_CANT_THROW
{
	
	TIME_ZONE_INFORMATION __timezoneinfo; 
  	SYSTEMTIME stime;
  	
	GetLocalTime(&stime);
	GetTimeZoneInformation(&__timezoneinfo);	

	timeptr->timezone = __timezoneinfo.Bias;
	timeptr->dstflag = __isdst();	
	timeptr->time =  __systemtime_to_time_t(&stime);
	timeptr->millitm = stime.wMilliseconds;
	
}

void _MSL_CDECL _ftime(struct timeb *timeptr) _MSL_CANT_THROW
{
	ftime(timeptr);

}

int _MSL_CDECL GetHandle() _MSL_CANT_THROW
{
    return __msl_GetHandle();
}

int _MSL_CDECL getpid(void) _MSL_CANT_THROW
{
	return GetCurrentProcessId();
}

int _MSL_CDECL dup(int handle) _MSL_CANT_THROW
{
	
	int h;
	
  	h = __msl_GetHandle();
  	
	return dup2(handle, h);
}

int _MSL_CDECL dup2(int handle, int h) _MSL_CANT_THROW
{
	HANDLE new_handle;
	DWORD err;

	/* closing h if it is open */ 
	close(h);						/*- cc 010517 -*/
	
	/* reset */	
	errno = ENOERR;	
	
	/* check to see if handle passed in is valid */
	if (handle >= NUM_HANDLES || !_HandleTable[handle]){
		errno = EBADF;
        return -1;
	}

	/* duplicate win32 handle info */
	err = __dup_core(_HandleTable[handle]->handle, &new_handle);
	
	if (err != NO_ERROR){
		__set_errno(err);
        return -1;
	}

	if (h >= NUM_HANDLES){
		errno = EBADF;
        return -1;
	}

	_HandleTable[h] = (FileStruct *)malloc(sizeof(FileStruct));
	
	/* Set up the translate mode flag */
	_HandleTable[h]->translate = _HandleTable[handle]->translate;
	_HandleTable[h]->append = 0;
		
	_HandleTable[h]->handle = new_handle; 
	
	return h;
}
/*- ejs 010718: define link-time symbols */
#define _DEFINE_FLOAT_WIN32_ 1
#include <float.h>
#undef _DEFINE_FLOAT_WIN32_

/* Change record:
 * KO  961120 Made a fix to _fullpath.
 * KO  961212 Made wcslen and wcscpy work better and added swprintf (which probably won't work
 *   		  too well.) 
 * hh  980122 Replaced <windows.h> with the following TWO includes because it is seriously
 *            broken.  The following 2 includes must be carefully ordered as shown, because
 *            they are broken too.
 * hh  980122 needed <cstdarg> for va_start
 * hh  980122 removed unused arg size
 * mf  980227 added splitpath and _strlwr to support MFC
 * mf  980228 removed wcskeb abd wcscpy as they are now in wstring.c
 * vss 980310 removed - defined in wprintf.c
 * blc 980324 added wide character functions used in WinCE
 * mf  980505 commented out implementation of functions that use win32 api's not available in ce
 * mf  980515 added a couple of non-standard wchar routines _itow,_wrevstr           
 * blc 990312 added _strset, _strnset, _strspnp, _wcsspnp
 * mm  990329 Make _itoa and _itow work for largest negative value WB1-5143, IL9903-2106           
 * blc 990331 Fixed double spacing problem with mm's last check in
 * blc 990825 Added wctype.h include for towupper and towlower
 * cc  000208 Added _umask support
 * cc  000209 removed io.h and _umask support
 * mm  000209 Corrected my 990329 fix to make it work for radices other than 10
 * cc  000219 Added io.h, _dup() and _dup2() 
 * cc  000510 Moved common source to extras.c
 * cc  000515 Fixed #include
 * cc  000708 (& ejs) fixed _fullpath 
 * cc  000724 fixed _dup/_dup2 to use common core and duplicate the MSL wrapper handles 
 *            as well as the Win32 handles.
 * hh  010307 Removed atexit calls.  The atexit chain is now merged with the global destructor
 *            chain, so __destroy_global_chain() takes care of them.
 * ejs 010417 Added dirent routines.
 * hh  010424 Changed call to __pool_free_all to __malloc_free_all in _CleanUpMSL.
              __pool_free_all still exists, but takes a pool as a parameter.
 * cc  010517 Renamed _dup/dup, _dup2/dup2, _getpid/getpid, _close/close, _getcwd,getcwd 
 * mm  010521 Inserted _MWMT wrappers.
 * cc  010601 Moved _CleanUpMSL, _doserrno, and dup_core to startup.win32.h - 
 *			  they are needed by MSL C.
 * cc  010605 Added _putenv & made _fullpath call __msl_fullpath, GetHandle call __msl_GetHandle 
 * cc  010713 Added putenv and mapped _putenv to it.
 * cc  010715 Added makepath & splitpath for win only
 * ejs 010718 Implement link-time symbols for functions in float.win32.h
 * cc  010725 Changed calls of strdup to __msl_strdup
 * JWW 010927 Moved dirent routines out of extras.win32.c to its own dirent.win32.c file
 * cc  011203 Added _MSL_CDECL for new name mangling 
 * ejs 020514 Fix egregrious lack of error checking in splitpath()
 * cc  020716 Added ftime
 * cc  030110 Added _ultow and _ltow
 * mm  030123 Corrections to _ultow and _ltow 
 * ejs 030701 Fix splitpath for UNC paths: MSVC sets drive="" and dir="\\server\share"
 * cc  030722 Moved underscored functions out of extras common headers/source.  
 *            They now live in the extras_xxxx_win32.h headers/source.
 * cc  030804 Changed return type of _alloca to void*
 * cc  040217 Changed _No_Floating_Point to _MSL_FLOATING_POINT
 */