/* Metrowerks x86 Runtime Support Library 
 * Copyright  1995-2003 Metrowerks Corporation.  All rights reserved.
 *
 * $Date: 2004/05/13 16:08:51 $
 * $Revision: 1.1 $
 */
 
#include <ansi_parms.h>
#include <stdarg.h>
#include <wchar.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include <ExceptionX86.h>
#include <crtl.h>
#include <ThreadLocalData.h>
#include <abort_exit.h>     /* hh 971207 Added <abort_exit.h> header */

// C++ Exception Tables
static ExceptionTableHeader ExceptionTables =
{
    &_PcToActionStart,
    &_PcToActionEnd,
    0
};

// DLL init/term function for the runtime / MSL DLL.
// On init and term we do nothing more than register our exception
// tables.  The main process or first DLL to use this guy will cause
// the actual initilization.
//
// On thread start we allocate the thread local storage required by
// MSL and on thread termination we deallocat it.

#if UNICODE
BOOL __stdcall _wDllMainCRTStartup(HINSTANCE inst, DWORD fdwReason, LPVOID lpvReserved);     /* hh 971207 Added prototype */
BOOL __stdcall _wDllMainCRTStartup(HINSTANCE inst, DWORD fdwReason, LPVOID lpvReserved)
#else
BOOL __stdcall _DllMainCRTStartup(HINSTANCE inst, DWORD fdwReason, LPVOID lpvReserved);     /* hh 971207 Added prototype */
BOOL __stdcall _DllMainCRTStartup(HINSTANCE inst, DWORD fdwReason, LPVOID lpvReserved)
#endif
{
	switch (fdwReason) {
		case DLL_PROCESS_ATTACH:
			// Register our exception handling tables
			_RegisterExceptionTables(&ExceptionTables);
			
			// Set up runtime and initialize thread data
			if (!_CRTStartup())
				return 0;

			/* Setup the globals __argc and __argv. */
			_tSetupArgs();

			/* Get environment variables */
			_tSetupEnv();

			// Run static initializer code
			_RunInit(&__xc_a);
			break; 

		case DLL_THREAD_ATTACH:
		
			// Get MSL thread local data
			if (!_InitializeThreadData((void *)GetCurrentThread())) {
	        	return 0;		
			}
			break;

		case DLL_THREAD_DETACH:
			// Free thread local data
			_DisposeThreadData();
			break;

		case DLL_PROCESS_DETACH:
			// Cleanup runtime
			_CleanUpMSL();
				
			// Unregister the exception tables
			_UnRegisterExceptionTables(&ExceptionTables);
			break;

	}

	// Success.
	return 1;
}

/* Change record:
 * ejs 000819  Move thread index allocation and destruction into MSL DLL
 * mf  000908  removed call to DisposeThreadData in   should be in DLL_PROCESS_DETACH.
               CleanUPMSL but for now we just assume pool_free_all cleans up this memory.
 * ejs 011206 Cleanup of init/term code
 * ejs 030721 Added UNICODE support
 */
 