/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.sbs.ant.types;

import com.nokia.helium.core.ant.types.VariableSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Reference;

public class SBSMakeOptions
extends VariableSet {
    private static Logger log = Logger.getLogger(SBSMakeOptions.class);
    private String engine;
    private String ppThreads;
    private boolean initialized;

    public SBSMakeOptions createSBSMakeOptions() {
        SBSMakeOptions options = new SBSMakeOptions();
        this.add(options);
        return options;
    }

    public void add(SBSMakeOptions option) {
        super.add((VariableSet)option);
    }

    public void setEngine(String engineName) {
        this.engine = engineName;
    }

    public void setPPThreads(String ppBlock) {
        this.ppThreads = ppBlock;
    }

    public String getPPThreads() {
        if (this.ppThreads == null && !this.initialized) {
            this.initializeAll();
            this.initialized = true;
        }
        return this.ppThreads;
    }

    public String getEngine() {
        if (this.engine == null) {
            if (!this.initialized) {
                this.initializeAll();
                this.initialized = true;
            }
            if (this.engine == null) {
                throw new BuildException("engine should not be null");
            }
        }
        return this.engine;
    }

    private void initializeAll() {
        Object sbsInputObject = null;
        List varSets = this.getVariableSets();
        this.initialize(this);
        for (VariableSet varSet : varSets) {
            this.initialize(varSet);
        }
    }

    private void initialize(VariableSet varSet) {
        SBSMakeOptions makeOptions = null;
        Reference refId = varSet.getRefid();
        if (refId != null) {
            try {
                makeOptions = (SBSMakeOptions)((Object)refId.getReferencedObject());
                if (makeOptions != null) {
                    String refEngine = makeOptions.getEngine();
                    String threads = makeOptions.getPPThreads();
                    if (this.engine != null && !this.engine.equals(refEngine)) {
                        throw new BuildException(" Config's engine type " + this.engine + " not matching with reference : " + refId.getRefId() + ": engine: " + refEngine);
                    }
                    if (this.ppThreads == null && threads != null) {
                        this.ppThreads = threads;
                    }
                    if (this.engine == null) {
                        this.engine = refEngine;
                    }
                }
            }
            catch (Exception ex) {
                throw new BuildException(ex.getMessage());
            }
        }
    }
}

