/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.antlint.checks;

import com.nokia.helium.antlint.checks.AbstractScriptCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class CheckPropertiesInDataModel
extends AbstractScriptCheck {
    @Override
    public void run(Element node) {
        String language;
        if (node.getName().equals("target")) {
            this.checkInScripts(node);
            this.checkInScriptConditions(node);
            this.checkInPythonTasks(node);
        }
        if (node.getName().equals("scriptdef") && ((language = node.attributeValue("language")).equals("jep") || language.equals("jython"))) {
            this.checkJepPropertiesInText(node.getText());
        }
    }

    private void checkInScriptConditions(Element node) {
        String target = node.attributeValue("name");
        List scriptList = node.selectNodes("//target[@name='" + target + "']/descendant::scriptcondition");
        for (Element scriptElement : scriptList) {
            String language = scriptElement.attributeValue("language");
            if (!language.equals("jep") && !language.equals("jython")) continue;
            this.checkJepPropertiesInText(scriptElement.getText());
        }
    }

    private void checkInScripts(Element node) {
        String target = node.attributeValue("name");
        List scriptList = node.selectNodes("//target[@name='" + target + "']/descendant::script");
        for (Element scriptElement : scriptList) {
            String language = scriptElement.attributeValue("language");
            if (!language.equals("jep") && !language.equals("jython")) continue;
            this.checkJepPropertiesInText(scriptElement.getText());
        }
    }

    private void checkInPythonTasks(Element node) {
        String target = node.attributeValue("name");
        List pythonList = node.selectNodes("//target[@name='" + target + "']/descendant::*[name()=\"hlm:python\"]");
        for (Element pythonElement : pythonList) {
            this.checkPropertiesInText(pythonElement.getText());
        }
    }

    private void checkPropertiesInText(String text) {
        Pattern p1 = Pattern.compile("r[\"']\\$\\{([a-zA-Z0-9\\.]*)\\}[\"']");
        Matcher m1 = p1.matcher(text);
        ArrayList<String> props = new ArrayList<String>();
        while (m1.find()) {
            props.add(m1.group(1));
        }
        for (String group : props) {
            this.checkPropertyInModel(group);
        }
    }
}

