/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.util.extendable.DefaultExtendableItem;

public class Configuration
extends DefaultExtendableItem {
    private String name;
    private String description;
    private String[] extendsFrom;
    private Visibility visibility;
    private boolean transitive = true;
    private String deprecated;

    public static Collection findConfigurationExtending(String conf, Configuration[] confs) {
        ArrayList<Configuration> extendingConfs = new ArrayList<Configuration>();
        for (int i = 0; i < confs.length; ++i) {
            if (confs[i] == null || !Arrays.asList(confs[i].getExtends()).contains(conf)) continue;
            extendingConfs.add(confs[i]);
            extendingConfs.addAll(Configuration.findConfigurationExtending(confs[i].getName(), confs));
        }
        return extendingConfs;
    }

    public Configuration(String name) {
        this(name, Visibility.PUBLIC, null, null, true, null);
    }

    public Configuration(String name, Visibility visibility, String description, String[] ext, boolean transitive, String deprecated) {
        if (name == null) {
            throw new NullPointerException("null configuration name not allowed");
        }
        if (visibility == null) {
            throw new NullPointerException("null visibility not allowed");
        }
        this.name = name;
        this.visibility = visibility;
        this.description = description;
        if (ext == null) {
            this.extendsFrom = new String[0];
        } else {
            this.extendsFrom = new String[ext.length];
            for (int i = 0; i < ext.length; ++i) {
                this.extendsFrom[i] = ext[i].trim();
            }
        }
        this.transitive = transitive;
        this.deprecated = deprecated;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getExtends() {
        return this.extendsFrom;
    }

    public String getName() {
        return this.name;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public final boolean isTransitive() {
        return this.transitive;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Configuration)) {
            return false;
        }
        return ((Configuration)obj).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void replaceWildcards(ModuleDescriptor md) {
        if (this != md.getConfiguration(this.name)) {
            throw new IllegalArgumentException("The given ModuleDescriptor doesn't own this configuration!");
        }
        Configuration[] configs = md.getConfigurations();
        LinkedHashSet<String> newExtends = new LinkedHashSet<String>();
        for (int j = 0; j < this.extendsFrom.length; ++j) {
            if ("*".equals(this.extendsFrom[j])) {
                this.addOther(configs, null, newExtends);
                continue;
            }
            if ("*(public)".equals(this.extendsFrom[j])) {
                this.addOther(configs, Visibility.PUBLIC, newExtends);
                continue;
            }
            if ("*(private)".equals(this.extendsFrom[j])) {
                this.addOther(configs, Visibility.PRIVATE, newExtends);
                continue;
            }
            newExtends.add(this.extendsFrom[j]);
        }
        this.extendsFrom = newExtends.toArray(new String[newExtends.size()]);
    }

    private void addOther(Configuration[] allConfigs, Visibility visibility, Set configs) {
        for (int i = 0; i < allConfigs.length; ++i) {
            String currentName = allConfigs[i].getName();
            if (this.name.equals(currentName) || visibility != null && !visibility.equals(allConfigs[i].getVisibility())) continue;
            configs.add(currentName);
        }
    }

    public static final class Visibility {
        public static final Visibility PUBLIC = new Visibility("public");
        public static final Visibility PRIVATE = new Visibility("private");
        private String name;

        public static Visibility getVisibility(String name) {
            if ("private".equals(name)) {
                return PRIVATE;
            }
            if ("public".equals(name)) {
                return PUBLIC;
            }
            throw new IllegalArgumentException("unknwon visibility " + name);
        }

        private Visibility(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

