/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.CopyRowsOperation;
import org.apache.derby.impl.store.raw.data.DeleteOperation;
import org.apache.derby.impl.store.raw.data.InitPageOperation;
import org.apache.derby.impl.store.raw.data.InsertOperation;
import org.apache.derby.impl.store.raw.data.InvalidatePageOperation;
import org.apache.derby.impl.store.raw.data.PageActions;
import org.apache.derby.impl.store.raw.data.PurgeOperation;
import org.apache.derby.impl.store.raw.data.SetReservedSpaceOperation;
import org.apache.derby.impl.store.raw.data.UpdateFieldOperation;
import org.apache.derby.impl.store.raw.data.UpdateOperation;

public class LoggableActions
implements PageActions {
    public void actionDelete(RawTransaction rawTransaction, BasePage basePage, int n, int n2, boolean bl, LogicalUndo logicalUndo) throws StandardException {
        DeleteOperation deleteOperation = new DeleteOperation(rawTransaction, basePage, n, n2, bl, logicalUndo);
        this.doAction(rawTransaction, basePage, deleteOperation);
    }

    public int actionUpdate(RawTransaction rawTransaction, BasePage basePage, int n, int n2, Object[] objectArray, FormatableBitSet formatableBitSet, int n3, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n4, RecordHandle recordHandle) throws StandardException {
        UpdateOperation updateOperation = new UpdateOperation(rawTransaction, basePage, n, n2, objectArray, formatableBitSet, n3, dynamicByteArrayOutputStream, n4, recordHandle);
        this.doAction(rawTransaction, basePage, updateOperation);
        return updateOperation.getNextStartColumn();
    }

    public void actionPurge(RawTransaction rawTransaction, BasePage basePage, int n, int n2, int[] nArray, boolean bl) throws StandardException {
        PurgeOperation purgeOperation = new PurgeOperation(rawTransaction, basePage, n, n2, nArray, bl);
        this.doAction(rawTransaction, basePage, purgeOperation);
    }

    public void actionUpdateField(RawTransaction rawTransaction, BasePage basePage, int n, int n2, int n3, Object object, LogicalUndo logicalUndo) throws StandardException {
        UpdateFieldOperation updateFieldOperation = new UpdateFieldOperation(rawTransaction, basePage, n, n2, n3, object, logicalUndo);
        this.doAction(rawTransaction, basePage, updateFieldOperation);
    }

    public int actionInsert(RawTransaction rawTransaction, BasePage basePage, int n, int n2, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n3, boolean bl, int n4, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n5, int n6) throws StandardException {
        InsertOperation insertOperation = new InsertOperation(rawTransaction, basePage, n, n2, objectArray, formatableBitSet, logicalUndo, by, n3, bl, n4, dynamicByteArrayOutputStream, n5, n6);
        this.doAction(rawTransaction, basePage, insertOperation);
        return insertOperation.getNextStartColumn();
    }

    public void actionCopyRows(RawTransaction rawTransaction, BasePage basePage, BasePage basePage2, int n, int n2, int n3, int[] nArray) throws StandardException {
        CopyRowsOperation copyRowsOperation = new CopyRowsOperation(rawTransaction, basePage, basePage2, n, n2, n3, nArray);
        this.doAction(rawTransaction, basePage, copyRowsOperation);
    }

    public void actionInvalidatePage(RawTransaction rawTransaction, BasePage basePage) throws StandardException {
        InvalidatePageOperation invalidatePageOperation = new InvalidatePageOperation(basePage);
        this.doAction(rawTransaction, basePage, invalidatePageOperation);
    }

    public void actionInitPage(RawTransaction rawTransaction, BasePage basePage, int n, int n2, long l) throws StandardException {
        InitPageOperation initPageOperation = new InitPageOperation(basePage, n, n2, l);
        this.doAction(rawTransaction, basePage, initPageOperation);
    }

    public void actionShrinkReservedSpace(RawTransaction rawTransaction, BasePage basePage, int n, int n2, int n3, int n4) throws StandardException {
        SetReservedSpaceOperation setReservedSpaceOperation = new SetReservedSpaceOperation(basePage, n, n2, n3, n4);
        this.doAction(rawTransaction, basePage, setReservedSpaceOperation);
    }

    private void doAction(RawTransaction rawTransaction, BasePage basePage, Loggable loggable) throws StandardException {
        long l = 0L;
        Object var6_5 = null;
        basePage.preDirty();
        rawTransaction.logAndDo(loggable);
    }
}

