/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.imaker.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ParallelExecutor {
    private ParallelExecutor() {
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                String line;
                ArrayList<String> cmds = new ArrayList<String>();
                BufferedReader in = new BufferedReader(new FileReader(args[0]));
                while ((line = in.readLine()) != null) {
                    if (line.trim().length() <= 0) continue;
                    cmds.add(line);
                }
                ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(cmds.size());
                int numOfProcessor = Runtime.getRuntime().availableProcessors();
                System.out.println("Number of threads: " + numOfProcessor);
                ThreadPoolExecutor executor = new ThreadPoolExecutor(numOfProcessor, numOfProcessor, 100L, TimeUnit.MILLISECONDS, queue);
                for (String cmd : cmds) {
                    executor.execute(new RunCommand(cmd));
                }
                executor.shutdown();
            }
            catch (IOException e) {
                System.err.println("ERROR: " + e.getMessage());
            }
        } else {
            System.out.println("ParallelExecutor: nothing to execute.");
        }
    }

    private static class RunCommand
    implements Runnable {
        private String cmdline;

        public RunCommand(String cmdline) {
            this.cmdline = cmdline;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringTokenizer st = new StringTokenizer(this.cmdline);
            String[] cmdArray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                cmdArray[i] = st.nextToken();
                ++i;
            }
            try {
                String line;
                Process p = new ProcessBuilder(cmdArray).redirectErrorStream(true).start();
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                StringBuffer buffer = new StringBuffer();
                SimpleDateFormat df = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
                Date start = new Date();
                buffer.append("++ Started at " + df.format(start) + "\n");
                buffer.append("+++ HiRes Start " + start.getTime() / 1000L + "\n");
                buffer.append("-- " + this.cmdline + "\n");
                while ((line = in.readLine()) != null) {
                    buffer.append(line + "\n");
                }
                Date end = new Date();
                buffer.append("+++ HiRes End " + end.getTime() / 1000L + "\n");
                buffer.append("++ Finished at " + df.format(end) + "\n");
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.print(buffer);
                }
            }
            catch (IOException e) {
                System.err.println("ERROR: " + e.getMessage());
            }
        }
    }
}

