/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.diamonds;

import com.nokia.helium.diamonds.DiamondsException;
import com.nokia.helium.diamonds.DiamondsProperties;
import com.nokia.helium.diamonds.Stage;
import com.nokia.helium.diamonds.Target;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public final class DiamondsConfig {
    private static DiamondsProperties diamondsProperties;
    private static List<Stage> stages;
    private static Logger log;
    private static Map<String, Target> targets;
    private static String outputDir;
    private static String templateDir;
    private static String initialiserTargetName;

    private DiamondsConfig() {
    }

    public static void parseConfiguration(String configFile) throws DiamondsException {
        if (log == null) {
            log = Logger.getLogger(DiamondsConfig.class);
        }
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            log.debug((Object)"Reading diamonds configuration.");
            document = saxReader.read(configFile);
        }
        catch (Exception e) {
            log.debug((Object)("Diamonds configuration parsing error: " + e.getMessage()));
        }
        DiamondsConfig.parseConfig(document);
        diamondsProperties = DiamondsConfig.parseDiamondsProperties(document);
        stages = DiamondsConfig.parseStages(document);
        targets = DiamondsConfig.parseTargets(document);
    }

    private static void parseConfig(Document document) {
        log.debug((Object)"diamonds:DiamondsConfig:parsing general configuration.");
        Node node = document.selectSingleNode("//output-dir");
        outputDir = node.valueOf("@path");
        node = document.selectSingleNode("//template-dir");
        templateDir = node.valueOf("@path");
    }

    private static DiamondsProperties parseDiamondsProperties(Document document) {
        log.debug((Object)"diamonds:DiamondsConfig:parsing diamonds properties.");
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        DiamondsConfig.loadProperty(document, propertiesMap, "host");
        DiamondsConfig.loadProperty(document, propertiesMap, "port");
        DiamondsConfig.loadProperty(document, propertiesMap, "path");
        DiamondsConfig.loadProperty(document, propertiesMap, "tstampformat");
        DiamondsConfig.loadProperty(document, propertiesMap, "mail");
        DiamondsConfig.loadProperty(document, propertiesMap, "ldapserver");
        DiamondsConfig.loadProperty(document, propertiesMap, "smtpserver");
        DiamondsConfig.loadProperty(document, propertiesMap, "initialiser-target-name");
        DiamondsConfig.loadProperty(document, propertiesMap, "category-property");
        DiamondsConfig.loadProperty(document, propertiesMap, "buildid-property");
        return new DiamondsProperties(propertiesMap);
    }

    private static Map<String, Target> parseTargets(Document document) {
        log.debug((Object)"diamonds:DiamondsConfig:parsing for targets");
        HashMap<String, Target> targets = new HashMap<String, Target>();
        List stageNodes = document.selectNodes("//target");
        initialiserTargetName = diamondsProperties.getProperty("initialiser-target-name");
        targets.put(initialiserTargetName, new Target(initialiserTargetName, "", "", "", ""));
        for (Element stageNode : stageNodes) {
            targets.put(stageNode.valueOf("@name"), new Target(stageNode.valueOf("@name"), stageNode.valueOf("@template-file"), stageNode.valueOf("@logfile"), stageNode.valueOf("@ant-properties"), stageNode.valueOf("@defer")));
        }
        return targets;
    }

    private static List<Stage> parseStages(Document document) {
        ArrayList<Stage> stages = new ArrayList<Stage>();
        List stageNodes = document.selectNodes("//stage");
        log.debug((Object)"diamonds:DiamondsConfig:parsing for stages");
        for (Element stage : stageNodes) {
            stages.add(new Stage(stage.valueOf("@name"), stage.valueOf("@start"), stage.valueOf("@end"), stage.valueOf("@logfile")));
        }
        return stages;
    }

    static List<Stage> getStages() {
        return stages;
    }

    static Map<String, Target> getTargets() {
        return targets;
    }

    public static boolean isStagesInConfig() {
        return stages != null;
    }

    public static boolean isTargetsInConfig() {
        return targets != null;
    }

    public static DiamondsProperties getDiamondsProperties() {
        return diamondsProperties;
    }

    static String getOutputDir() {
        return outputDir;
    }

    static String getTemplateDir() {
        return templateDir;
    }

    public static String getInitialiserTargetName() {
        return initialiserTargetName;
    }

    public static void loadProperty(Document document, Map<String, String> hash, String name) {
        Node node = document.selectSingleNode("//property[@name='" + name + "']");
        if (node == null) {
            throw new BuildException("diamonds: DiamondsConfig:'" + name + "' property definition is missing.");
        }
        hash.put(name, node.valueOf("@value"));
    }
}

