/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.util;

import com.sardak.antform.style.FontConverter;
import com.sardak.antform.style.HexConverter;
import java.awt.Color;
import java.awt.Font;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.JTextComponent;

public class StyleUtil {
    public static void styleComponents(String componentId, Properties props, Collection components) {
        String componentBCString = props.getProperty(componentId + ".background.color", props.getProperty("*.background.color"));
        String componentFCString = props.getProperty(componentId + ".color", props.getProperty("*.color"));
        String componentFFamilyString = props.getProperty(componentId + ".font.family", props.getProperty("*.font.family"));
        String componentFSizeString = props.getProperty(componentId + ".font.size", props.getProperty("*.font.size"));
        String componentFWeightString = props.getProperty(componentId + ".font.weight", props.getProperty("*.font.weight"));
        String componentBStyleString = props.getProperty(componentId + ".border.style", props.getProperty("*.border.style"));
        String componentBWidthString = props.getProperty(componentId + ".border.width", props.getProperty("*.border.width"));
        String componentBColorString = props.getProperty(componentId + ".border.color", props.getProperty("*.border.color"));
        int componentBWidth = 1;
        Color componentBC = null;
        Color componentFC = null;
        Color componentBorderC = null;
        Border componentBorder = null;
        if (componentBCString != null) {
            componentBC = HexConverter.translate(componentBCString, null);
        }
        if (componentFCString != null) {
            componentFC = HexConverter.translate(componentFCString, null);
        }
        if (componentBWidthString != null && componentBColorString != null && componentBStyleString != null) {
            componentBWidth = Integer.parseInt(componentBWidthString);
            componentBorderC = HexConverter.translate(componentBColorString, null);
            componentBorder = BorderFactory.createLineBorder(componentBorderC, componentBWidth);
        }
        Iterator i = components.iterator();
        while (i.hasNext()) {
            Color inverseColor;
            JTextComponent textComp;
            JComponent comp = (JComponent)i.next();
            if (comp == null) continue;
            if (componentBC != null) {
                comp.setBackground(componentBC);
                if (comp instanceof JTextComponent) {
                    textComp = (JTextComponent)comp;
                    inverseColor = new Color(255 - (int)((double)componentBC.getRed() * 0.7), 255 - (int)((double)componentBC.getGreen() * 0.7), 255 - (int)((double)componentBC.getBlue() * 0.7));
                    textComp.setSelectedTextColor(inverseColor);
                }
            }
            if (componentFC != null) {
                comp.setForeground(componentFC);
                if (comp instanceof JTextComponent) {
                    textComp = (JTextComponent)comp;
                    inverseColor = new Color(255 - (int)((double)componentFC.getRed() * 0.7), 255 - (int)((double)componentFC.getGreen() * 0.7), 255 - (int)((double)componentFC.getBlue() * 0.7));
                    textComp.setSelectionColor(inverseColor.darker());
                }
            }
            StyleUtil.setFont(comp, componentFFamilyString, componentFSizeString, componentFWeightString);
            if (componentBorder == null || !componentBStyleString.trim().toLowerCase().equals("solid")) continue;
            if (comp instanceof JButton) {
                comp.setBorder(new CompoundBorder(componentBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
                continue;
            }
            comp.setBorder(componentBorder);
        }
    }

    private static void setFont(JComponent component, String componentFFamilyString, String componentFSizeString, String componentFWeightString) {
        Font currentFont = component.getFont();
        String family = componentFFamilyString == null ? currentFont.getFamily() : componentFFamilyString;
        int size = componentFSizeString == null ? currentFont.getSize() : Integer.parseInt(componentFSizeString);
        int style = componentFWeightString == null ? currentFont.getStyle() : FontConverter.convert(componentFWeightString);
        component.setFont(new Font(family, style, size));
    }
}

