/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.taskdefs;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public class AntConfigurationTask
extends Task {
    private String filepath;
    private ArrayList rcs = new ArrayList();

    public final void setFile(String file) {
        this.filepath = file;
    }

    public final void addFileset(FileSet set) {
        this.add((ResourceCollection)set);
    }

    public final void add(ResourceCollection res) {
        this.rcs.add(res);
    }

    public final void execute() {
        if (this.filepath != null) {
            this.importFile(new File(this.filepath));
        } else {
            for (ResourceCollection resourceCollection : this.rcs) {
                for (FileResource filepath : resourceCollection) {
                    this.importFile(filepath.getFile());
                }
            }
        }
    }

    private void importFile(File file) {
        try {
            String filename = file.getName();
            PropertiesConfiguration config = null;
            if (filename.endsWith(".txt")) {
                config = new PropertiesConfiguration(file);
            } else if (filename.endsWith(".xml")) {
                config = new XMLConfiguration(file);
            }
            Iterator keysIter = config.getKeys();
            while (keysIter.hasNext()) {
                String key = (String)keysIter.next();
                this.getProject().setProperty(key, config.getString(key));
            }
        }
        catch (ConfigurationException e) {
            throw new BuildException("Not able to import the ANT file " + e.getMessage());
        }
    }
}

