/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;

public final class ModifiedControlVariableCheck
extends Check {
    private FastStack<String> mCurrentVariables = FastStack.newInstance();
    private final FastStack<FastStack<String>> mVariableStack = FastStack.newInstance();

    public int[] getDefaultTokens() {
        return new int[]{6, 91, 37, 156, 80, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 129, 25, 130, 26};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void beginTree(DetailAST aRootAST) {
        this.mCurrentVariables.clear();
        this.mVariableStack.clear();
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 6: {
                this.enterBlock();
                break;
            }
            case 37: 
            case 91: 
            case 156: {
                break;
            }
            case 25: 
            case 26: 
            case 80: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 129: 
            case 130: {
                this.checkIdent(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 37: {
                this.leaveForIter(aAST.getParent());
                break;
            }
            case 156: {
                this.leaveForEach(aAST);
                break;
            }
            case 91: {
                this.leaveForDef(aAST);
                break;
            }
            case 6: {
                this.exitBlock();
                break;
            }
            case 25: 
            case 26: 
            case 80: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 129: 
            case 130: {
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    private void enterBlock() {
        this.mVariableStack.push(this.mCurrentVariables);
        this.mCurrentVariables = FastStack.newInstance();
    }

    private void exitBlock() {
        this.mCurrentVariables = this.mVariableStack.pop();
    }

    private void checkIdent(DetailAST aAST) {
        DetailAST identAST;
        if (this.mCurrentVariables != null && !this.mCurrentVariables.isEmpty() && (identAST = aAST.getFirstChild()) != null && identAST.getType() == 58 && this.mCurrentVariables.contains(identAST.getText())) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "modified.control.variable", identAST.getText());
        }
    }

    private void leaveForIter(DetailAST aAST) {
        DetailAST forInitAST = aAST.findFirstToken(35);
        for (DetailAST parameterDefAST = forInitAST.findFirstToken(10); parameterDefAST != null; parameterDefAST = parameterDefAST.getNextSibling()) {
            if (parameterDefAST.getType() != 10) continue;
            DetailAST param = parameterDefAST.findFirstToken(58);
            this.mCurrentVariables.push(param.getText());
        }
    }

    private void leaveForEach(DetailAST aForEach) {
        DetailAST paramDef = aForEach.findFirstToken(10);
        DetailAST paramName = paramDef.findFirstToken(58);
        this.mCurrentVariables.push(paramName.getText());
    }

    private void leaveForDef(DetailAST aAST) {
        DetailAST forInitAST = aAST.findFirstToken(35);
        if (forInitAST != null) {
            for (DetailAST parameterDefAST = forInitAST.findFirstToken(10); parameterDefAST != null; parameterDefAST = parameterDefAST.getNextSibling()) {
                if (parameterDefAST.getType() != 10) continue;
                this.mCurrentVariables.pop();
            }
        } else {
            this.mCurrentVariables.pop();
        }
    }
}

