/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.taskdefs;

import com.nokia.ant.taskdefs.LogRecorderEntry;
import com.nokia.ant.taskdefs.TextLogRecorderEntry;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.LogLevel;

@Deprecated
public class LogRecorderTask
extends Task
implements SubBuildListener {
    private static Hashtable recorderEntries = new Hashtable();
    private String filename;
    private String loggerclass = "nokia.ant.taskdefs.TextLogRecorderEntry";
    private String filterset;
    private boolean append;
    private boolean backup;
    private boolean start;
    private int loglevel = -1;
    private boolean emacsMode;
    private String regexp;

    public void init() {
        this.log("Deprecated Start using hlm:record task", 1);
        this.getProject().addBuildListener((BuildListener)this);
    }

    public void setName(String fname) {
        this.filename = fname;
    }

    public void setClass(String name) {
        this.loggerclass = name;
    }

    public void setAction(ActionChoices action) {
        this.start = action.getValue().equalsIgnoreCase("start");
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public void setLoglevel(VerbosityLevelChoices level) {
        this.loglevel = level.getLevel();
    }

    public void setFilterSet(String filterset) {
        this.filterset = filterset;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    public void execute() {
        if (this.filename == null) {
            throw new BuildException("No filename specified");
        }
        if (this.backup) {
            long timestamp = System.currentTimeMillis();
            File oldFile = new File(this.filename);
            if (oldFile.exists()) {
                oldFile.renameTo(new File(this.filename + "." + timestamp));
                this.getProject().setProperty("backup.file.name", this.filename + "." + timestamp);
            }
        }
        this.getProject().log("setting a recorder for name " + this.filename, 4);
        LogRecorderEntry recorder = this.getRecorder(this.filename, this.getProject());
        recorder.setMessageOutputLevel(this.loglevel);
        recorder.setEmacsMode(this.emacsMode);
        if (this.regexp != null && this.regexp.trim().length() > 0) {
            recorder.setRegexp(this.regexp);
        }
        if (this.start) {
            recorder.reopenFile();
            recorder.setRecordState(true);
        } else {
            recorder.setRecordState(false);
            recorder.closeFile();
        }
    }

    protected LogRecorderEntry getRecorder(String name, Project proj) {
        LogRecorderEntry entry;
        Object o = recorderEntries.get(name);
        if (o == null) {
            try {
                Class[] parameters = new Class[]{String.class};
                Class<?> centry = Class.forName(this.loggerclass);
                Constructor<?> c = centry.getConstructor(parameters);
                Object[] params = new Object[]{this.filename};
                entry = (LogRecorderEntry)c.newInstance(params);
            }
            catch (Exception e) {
                entry = new TextLogRecorderEntry(name);
            }
            entry.openFile(this.append);
            entry.setProject(proj);
            recorderEntries.put(name, entry);
        } else {
            entry = (LogRecorderEntry)o;
        }
        return entry;
    }

    public void buildStarted(BuildEvent event) {
    }

    public void subBuildStarted(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
        this.cleanup();
    }

    public void subBuildFinished(BuildEvent event) {
        if (event.getProject() == this.getProject()) {
            this.cleanup();
        }
    }

    private void cleanup() {
        recorderEntries.clear();
        this.getProject().removeBuildListener((BuildListener)this);
    }

    public static class ActionChoices
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"start", "stop"};

        public String[] getValues() {
            return VALUES;
        }
    }

    public static class VerbosityLevelChoices
    extends LogLevel {
    }
}

