/*
 * Decompiled with CFR 0.152.
 */
package fmpp.dataloaders;

import fmpp.Engine;
import fmpp.tdd.DataLoader;
import fmpp.util.StringUtil;
import freemarker.ext.dom.NodeModel;
import freemarker.template.TemplateNodeModel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlDataLoader
implements DataLoader {
    public static final String OPTION_REMOVE_COMMENTS = "removeComments";
    public static final String OPTION_REMOVE_PIS = "removePIs";
    public static final String OPTION_NAMESPACE_AWARE = "namespaceAware";
    public static final String OPTION_VALIDATE = "validate";
    public static final String OPTION_INDEX = "index";
    public static final String OPTION_XMLNS = "xmlns";
    private static final Set OPTION_NAMES = new HashSet();

    public Object load(Engine engine, List args) throws Exception {
        return this.load(engine, args, null);
    }

    public TemplateNodeModel load(Engine engine, List args, Document preLoadedDoc) throws Exception {
        Document doc;
        String path;
        Object obj;
        boolean removePIs = false;
        boolean removeComments = true;
        boolean namespaceAware = true;
        boolean validate = engine.getValidateXml();
        Map xmlns = new HashMap();
        Object indexOp = null;
        int argCount = args.size();
        if (argCount < 1) {
            throw new IllegalArgumentException("xml(fileName[, options]) needs at least 1 parameter.");
        }
        if (preLoadedDoc == null) {
            obj = args.get(0);
            if (!(obj instanceof String)) {
                throw new IllegalArgumentException("The 1st argument (fileName) must be a string.");
            }
            path = ((String)obj).replace('/', File.separatorChar);
        } else {
            path = null;
        }
        if (argCount > 1) {
            obj = args.get(1);
            if (!(obj instanceof Map)) {
                throw new IllegalArgumentException("The 2nd argument (options) must be a hash.");
            }
            Iterator ops = ((Map)obj).entrySet().iterator();
            while (ops.hasNext()) {
                Map.Entry ent = ops.next();
                String opName = (String)ent.getKey();
                Object opValue = ent.getValue();
                if (OPTION_REMOVE_COMMENTS.equals(opName)) {
                    if (!(opValue instanceof Boolean)) {
                        throw new IllegalArgumentException("The value of option \"removeComments\" must be a boolean.");
                    }
                    removeComments = (Boolean)opValue;
                    continue;
                }
                if (OPTION_REMOVE_PIS.equals(opName)) {
                    if (!(opValue instanceof Boolean)) {
                        throw new IllegalArgumentException("The value of option \"removePIs\" must be a boolean.");
                    }
                    removePIs = (Boolean)opValue;
                    continue;
                }
                if (OPTION_NAMESPACE_AWARE.equals(opName)) {
                    if (!(opValue instanceof Boolean)) {
                        throw new IllegalArgumentException("The value of option \"namespaceAware\" must be a boolean.");
                    }
                    namespaceAware = (Boolean)opValue;
                    continue;
                }
                if (OPTION_VALIDATE.equals(opName)) {
                    if (!(opValue instanceof Boolean)) {
                        throw new IllegalArgumentException("The value of option \"validating\" must be a boolean.");
                    }
                    validate = (Boolean)opValue;
                    continue;
                }
                if (OPTION_INDEX.equals(opName)) {
                    indexOp = opValue;
                    continue;
                }
                if (OPTION_XMLNS.equals(opName)) {
                    if (!(opValue instanceof Map)) {
                        throw new IllegalArgumentException("The value of option \"xmlns\" must be a hash.");
                    }
                    xmlns = (Map)opValue;
                    Iterator it = xmlns.entrySet().iterator();
                    while (it.hasNext()) {
                        ent = it.next();
                        String prefix = (String)ent.getKey();
                        if (prefix.length() == 0) {
                            throw new IllegalArgumentException("The key in xmlns hash can't be emptry string");
                        }
                        obj = ent.getValue();
                        if (!(obj instanceof String)) {
                            throw new IllegalArgumentException("The subvariables of the xmlns hash must be strings.");
                        }
                        String uri = (String)obj;
                        if ((uri = uri.trim()).length() == 0) {
                            throw new IllegalArgumentException("The value for key " + StringUtil.jQuote(prefix) + " in xmlns hash can't be " + "emptry string");
                        }
                        ent.setValue(uri);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Option " + StringUtil.jQuote(opName) + " is unknown. Supported options are: " + " index, removeComments, removePIs, xmlns, " + "validate, namespaceAware.");
            }
        }
        if (preLoadedDoc == null) {
            File xmlFile = new File(path);
            if (!xmlFile.isAbsolute()) {
                xmlFile = new File(engine.getDataRoot(), path);
            }
            doc = XmlDataLoader.loadXmlFile(engine, xmlFile, namespaceAware, validate);
        } else {
            doc = preLoadedDoc;
        }
        if (removePIs) {
            NodeModel.removePIs((Node)doc);
        }
        if (removeComments) {
            NodeModel.removeComments((Node)doc);
        }
        NodeModel.mergeAdjacentText((Node)doc);
        if (indexOp != null) {
            IndexDescriptor[] indices;
            if (indexOp instanceof Map) {
                indices = new IndexDescriptor[]{new IndexDescriptor(indexOp, xmlns, namespaceAware)};
            } else if (indexOp instanceof String) {
                indices = new IndexDescriptor[]{new IndexDescriptor(indexOp, xmlns, namespaceAware)};
            } else if (indexOp instanceof List) {
                List indexCfgs = indexOp;
                indices = new IndexDescriptor[indexCfgs.size()];
                for (int i = 0; i < indexCfgs.size(); ++i) {
                    Object icfg = indexCfgs.get(i);
                    if (icfg instanceof Map) {
                        indices[i] = new IndexDescriptor((Map)icfg, xmlns, namespaceAware);
                        continue;
                    }
                    if (icfg instanceof String) {
                        indices[i] = new IndexDescriptor((String)icfg, xmlns, namespaceAware);
                        continue;
                    }
                    throw new IllegalArgumentException("When the \"index\" sub-option of data loader xml(fileName, options) is a sequence, its subvariables must be hashes and strings.");
                }
            } else {
                throw new IllegalArgumentException("The \"index\" sub-option of data loader xml(fileName, options) must be either hash, string, or sequence.");
            }
            for (int i = 0; i < indices.length; ++i) {
                indices[i].apply(doc);
            }
        }
        return NodeModel.wrap((Node)doc);
    }

    public static boolean isOptionName(String optionName) {
        return OPTION_NAMES.contains(optionName);
    }

    public static Document loadXmlFile(Engine engine, File xmlFile, boolean namespaceAware, boolean validate) throws SAXException, IOException, ParserConfigurationException {
        EntityResolver er;
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setNamespaceAware(namespaceAware);
        f.setValidating(validate);
        DocumentBuilder db = f.newDocumentBuilder();
        if (validate) {
            db.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException e) throws SAXException {
                    throw new FriendlySaxException(XmlDataLoader.buildSAXParseExceptionMessage("XML parsing error: ", e), e.getException());
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    throw new FriendlySaxException(XmlDataLoader.buildSAXParseExceptionMessage("XML parsing error: ", e), e.getException());
                }

                public void warning(SAXParseException exception) throws SAXException {
                }
            });
        }
        if ((er = (EntityResolver)engine.getXmlEntiryResolver()) != null) {
            db.setEntityResolver(er);
        }
        return db.parse(xmlFile);
    }

    private static String buildSAXParseExceptionMessage(String messagePrefix, SAXParseException e) {
        int line = e.getLineNumber();
        int col = e.getColumnNumber();
        String pid = e.getPublicId();
        String sid = e.getSystemId();
        String message = e.getMessage();
        StringBuffer res = new StringBuffer();
        if (messagePrefix != null) {
            res.append(messagePrefix);
        }
        if (message != null) {
            res.append(message);
        }
        if (line != -1 || col != -1 || pid != null || sid != null) {
            boolean needSep = false;
            if (res.length() != 0) {
                res.append(StringUtil.LINE_BREAK);
            }
            res.append("Error location: ");
            if (line != -1) {
                res.append("line ");
                res.append(line);
                needSep = true;
            }
            if (col != -1) {
                if (needSep) {
                    res.append(", ");
                }
                res.append("column ");
                res.append(col);
                needSep = true;
            }
            if (sid != null) {
                if (needSep) {
                    res.append(" in ");
                }
                res.append(sid);
                needSep = true;
            } else if (pid != null) {
                if (needSep) {
                    res.append(" in ");
                }
                res.append(pid);
                needSep = true;
            }
        }
        return res.toString();
    }

    static {
        OPTION_NAMES.add(OPTION_REMOVE_COMMENTS);
        OPTION_NAMES.add(OPTION_REMOVE_PIS);
        OPTION_NAMES.add(OPTION_NAMESPACE_AWARE);
        OPTION_NAMES.add(OPTION_VALIDATE);
        OPTION_NAMES.add(OPTION_INDEX);
        OPTION_NAMES.add(OPTION_XMLNS);
    }

    private static class FriendlySaxException
    extends SAXException {
        public FriendlySaxException(String message) {
            this(message, null);
        }

        public FriendlySaxException(String message, Exception e) {
            super(message, e);
        }
    }

    private static class IndexDescriptor {
        private static final String OP_ELEMENT = "element";
        private static final String OP_ATTRIBUTE = "attribute";
        private static final String OP_VALUE = "value";
        private static final String OP_NUMBERING = "numbering";
        private static final String OPVAL_NUMBERING_SEQUENTIAL = "sequential";
        private static final String OPVAL_NUMBERING_HIERARCHICAL = "hierarchical";
        private static final int NUMBERING_SEQUENTIAL = 1;
        private static final int NUMBERING_HIERARCHICAL = 2;
        private Map elements;
        private int numbering = 1;
        private String attName = "id";
        private String attNSUri = "";
        private char[] attValue = "ppi_%n".toCharArray();
        private boolean namespaceAware;
        private StringBuffer wb = new StringBuffer();
        private int count;

        private IndexDescriptor(Map cfg, Map xmlns, boolean namespaceAware) {
            this.namespaceAware = namespaceAware;
            Iterator it = cfg.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry ent = it.next();
                String opName = (String)ent.getKey();
                Object opValue = ent.getValue();
                String defaultNS = (String)xmlns.get("D");
                if (defaultNS == null) {
                    defaultNS = "";
                }
                if (OP_ELEMENT.equals(opName)) {
                    String[] names;
                    int elementCount;
                    if (opValue instanceof String) {
                        elementCount = 1;
                        names = new String[]{(String)opValue};
                    } else if (opValue instanceof List) {
                        List elements = (List)opValue;
                        elementCount = elements.size();
                        names = new String[elementCount];
                        for (int i = 0; i < elementCount; ++i) {
                            Object obj = elements.get(i);
                            if (!(obj instanceof String)) {
                                throw new IllegalArgumentException("The value of sub-option \"element\", when it is a sequence, must be a sequence of strings.");
                            }
                            names[i] = (String)obj;
                        }
                    } else {
                        throw new IllegalArgumentException("The value of sub-option \"element\" must be a string or a sequence of strings.");
                    }
                    this.elements = new HashMap();
                    for (int i = 0; i < elementCount; ++i) {
                        HashSet<String> nsSet;
                        String uri;
                        String eName = names[i];
                        if (namespaceAware) {
                            int x = eName.indexOf(58);
                            if (x == -1) {
                                uri = defaultNS;
                            } else {
                                String s2 = eName.substring(0, x);
                                if (s2.length() == 0) {
                                    throw new IllegalArgumentException("Illegal element name in sub-option \"element\": " + StringUtil.jQuote(eName) + ". " + "The prefix is missing before " + "the colon.");
                                }
                                eName = eName.substring(x + 1);
                                uri = (String)xmlns.get(s2);
                                if (uri == null) {
                                    throw new IllegalArgumentException("Undefined XML name-space prefix in sub-option \"element\": " + StringUtil.jQuote(s2) + ". You " + "have to define this prefix with " + "option \"xmlns\".");
                                }
                            }
                        } else {
                            uri = "";
                        }
                        if ((nsSet = (HashSet<String>)this.elements.get(eName)) == null) {
                            nsSet = new HashSet<String>();
                            this.elements.put(eName, nsSet);
                        }
                        nsSet.add(uri);
                    }
                    continue;
                }
                if (OP_ATTRIBUTE.equals(opName)) {
                    if (!(opValue instanceof String)) {
                        throw new IllegalArgumentException("The value of option \"attribute\" must be a string.");
                    }
                    this.attName = (String)opValue;
                    if (namespaceAware) {
                        int x = this.attName.indexOf(58);
                        if (x == -1) {
                            this.attNSUri = "";
                            continue;
                        }
                        String s2 = this.attName.substring(0, x);
                        if (s2.length() == 0) {
                            throw new IllegalArgumentException("Illegal element name in sub-option \"attribute\": " + StringUtil.jQuote(this.attName) + ". " + "The prefix is missing before the " + "colon.");
                        }
                        this.attName = this.attName.substring(x + 1);
                        this.attNSUri = (String)xmlns.get(s2);
                        if (this.attNSUri != null) continue;
                        throw new IllegalArgumentException("Undefined XML name-space prefix in sub-option \"attribute\": " + StringUtil.jQuote(s2) + ". You " + "have to define this prefix with " + "option \"xmlns\".");
                    }
                    this.attNSUri = "";
                    continue;
                }
                if (OP_VALUE.equals(opName)) {
                    if (!(opValue instanceof String)) {
                        throw new IllegalArgumentException("The value of option \"value\" must be a string.");
                    }
                    this.attValue = ((String)opValue).toCharArray();
                    continue;
                }
                if (OP_NUMBERING.equals(opName)) {
                    if (!(opValue instanceof String)) {
                        throw new IllegalArgumentException("The value of option \"numbering\" must be a string.");
                    }
                    String s = (String)opValue;
                    if (OPVAL_NUMBERING_SEQUENTIAL.equals(s)) {
                        this.numbering = 1;
                        continue;
                    }
                    if (OPVAL_NUMBERING_HIERARCHICAL.equals(s)) {
                        this.numbering = 2;
                        continue;
                    }
                    throw new IllegalArgumentException("Illegal value for option \"numbering\": " + StringUtil.jQuote(s) + ". " + "Valid values are: \"" + OPVAL_NUMBERING_SEQUENTIAL + "\", \"" + OPVAL_NUMBERING_HIERARCHICAL + "\".");
                }
                throw new IllegalArgumentException("Unknown index option " + StringUtil.jQuote(opName) + ". Valid options are: \"" + OP_ELEMENT + "\", \"" + OP_ATTRIBUTE + "\", \"" + OP_VALUE + "\", \"" + OP_NUMBERING + "\".");
            }
            if (this.elements == null) {
                throw new IllegalArgumentException("Required sub-option \"element\" of option \"index\" is missing.");
            }
        }

        private IndexDescriptor(String element, Map xmlns, boolean namespaceAware) {
            this(IndexDescriptor.createCfgMap(element), xmlns, namespaceAware);
        }

        private static Map createCfgMap(String element) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(OP_ELEMENT, element);
            return map;
        }

        private void apply(Node node) {
            this.count = 0;
            this.apply(node, "");
        }

        private void apply(Node node, String numPrefix) {
            boolean indexed;
            if (node.getNodeType() == 1) {
                String eName = this.namespaceAware ? node.getLocalName() : node.getNodeName();
                Object uris = this.elements.get(eName);
                String domAttNSUri = this.attNSUri.length() == 0 ? null : this.attNSUri;
                if (uris != null) {
                    String nUri = node.getNamespaceURI();
                    boolean match = nUri == null || nUri.length() == 0 ? ((Set)uris).contains("") : ((Set)uris).contains(nUri);
                    if (match) {
                        ++this.count;
                        indexed = true;
                        Element e = (Element)node;
                        NamedNodeMap attrs = e.getAttributes();
                        Attr theAttr = this.namespaceAware ? (Attr)attrs.getNamedItemNS(domAttNSUri, this.attName) : (Attr)attrs.getNamedItem(this.attName);
                        if (theAttr == null) {
                            this.wb.setLength(0);
                            int ln = this.attValue.length;
                            for (int i = 0; i < ln; ++i) {
                                char c = this.attValue[i];
                                if (c != '%') {
                                    this.wb.append(c);
                                    continue;
                                }
                                if (++i == ln) {
                                    throw new IllegalArgumentException("Illegal usage of % in sub-option \"value\" of option \"index\": % at the end of the string");
                                }
                                c = this.attValue[i];
                                if (c == 'n') {
                                    this.wb.append(numPrefix);
                                    this.wb.append(this.count);
                                    continue;
                                }
                                if (c == 'e') {
                                    this.wb.append(eName);
                                    continue;
                                }
                                if (c == '%') {
                                    this.wb.append('%');
                                    continue;
                                }
                                throw new IllegalArgumentException("Illegal usage of % in sub-option \"value\" of option \"index\": %" + c);
                            }
                            if (domAttNSUri == null) {
                                e.setAttribute(this.attName, this.wb.toString());
                            } else {
                                theAttr = node.getOwnerDocument().createAttributeNS(domAttNSUri, "fmpp:" + this.attName);
                                theAttr.setNodeValue(this.wb.toString());
                                e.setAttributeNode(theAttr);
                            }
                        }
                    } else {
                        indexed = false;
                    }
                } else {
                    indexed = false;
                }
            } else {
                indexed = false;
            }
            NodeList children = node.getChildNodes();
            int ln = children.getLength();
            if (ln != 0) {
                if (this.numbering == 2) {
                    String newNumPrefix;
                    int oldCount = this.count;
                    if (!indexed) {
                        newNumPrefix = numPrefix;
                    } else {
                        this.wb.setLength(0);
                        this.wb.append(numPrefix);
                        this.wb.append(Integer.toString(this.count));
                        this.wb.append("_");
                        newNumPrefix = this.wb.toString();
                        this.count = 0;
                    }
                    for (int i = 0; i < ln; ++i) {
                        this.apply(children.item(i), newNumPrefix);
                    }
                    if (indexed) {
                        this.count = oldCount;
                    }
                } else if (this.numbering == 1) {
                    for (int i = 0; i < ln; ++i) {
                        this.apply(children.item(i), numPrefix);
                    }
                }
            }
        }
    }
}

