/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.url;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerRegistry;

public class URLResource
implements Resource {
    private URL _url;
    private boolean _init = false;
    private long _lastModified;
    private long _contentLength;
    private boolean _exists;

    public URLResource(URL url) {
        this._url = url;
    }

    public String getName() {
        return this._url.toExternalForm();
    }

    public Resource clone(String cloneName) {
        try {
            return new URLResource(new URL(cloneName));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("bad clone name provided: not suitable for an URLResource: " + cloneName);
        }
    }

    public long getLastModified() {
        if (!this._init) {
            this.init();
        }
        return this._lastModified;
    }

    private void init() {
        URLHandler.URLInfo info = URLHandlerRegistry.getDefault().getURLInfo(this._url);
        this._contentLength = info.getContentLength();
        this._lastModified = info.getLastModified();
        this._exists = info.isReachable();
        this._init = true;
    }

    public long getContentLength() {
        if (!this._init) {
            this.init();
        }
        return this._contentLength;
    }

    public boolean exists() {
        if (!this._init) {
            this.init();
        }
        return this._exists;
    }

    public URL getURL() {
        return this._url;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isLocal() {
        return false;
    }

    public InputStream openStream() throws IOException {
        return this._url.openStream();
    }
}

