/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandler;

public class HttpClientHandler
extends AbstractURLHandler {
    private static final SimpleDateFormat LAST_MODIFIED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    private int proxyPort;
    private String proxyRealm = null;
    private String proxyHost = null;
    private String proxyUserName = null;
    private String proxyPasswd = null;
    private HttpClientHelper httpClientHelper;

    public HttpClientHandler() {
        this.configureProxy();
    }

    private void configureProxy() {
        this.proxyRealm = null;
        this.proxyHost = System.getProperty("http.proxyHost");
        if (this.useProxy()) {
            this.proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
            this.proxyUserName = System.getProperty("http.proxyUser");
            this.proxyPasswd = System.getProperty("http.proxyPassword");
            Message.verbose("proxy configured: host=" + this.proxyHost + " port=" + this.proxyPort + " user=" + this.proxyUserName);
        } else {
            Message.verbose("no proxy configured");
        }
    }

    public InputStream openStream(URL url) throws IOException {
        GetMethod get = this.doGet(url);
        return new GETInputStream(get);
    }

    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        GetMethod get = this.doGet(src);
        FileUtil.copy(get.getResponseBodyAsStream(), dest, l);
        get.releaseConnection();
    }

    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getURLInfo(url, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLHandler.URLInfo getURLInfo(URL url, int timeout) {
        HeadMethod head = null;
        try {
            head = this.doHead(url, timeout);
            int status = head.getStatusCode();
            head.releaseConnection();
            if (status == 200) {
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, this.getResponseContentLength(head), this.getLastModified(head));
                return uRLInfo;
            }
            if (status == 407) {
                Message.error("Your proxy requires authentication.");
            } else if (String.valueOf(status).startsWith("4")) {
                Message.verbose("CLIENT ERROR: " + head.getStatusText() + " url=" + url);
            } else if (String.valueOf(status).startsWith("5")) {
                Message.warn("SERVER ERROR: " + head.getStatusText() + " url=" + url);
            }
            Message.debug("HTTP response status: " + status + "=" + head.getStatusText() + " url=" + url);
        }
        catch (HttpException e) {
            Message.error("HttpClientHandler: " + e.getMessage() + ":" + e.getReasonCode() + "=" + e.getReason() + " url=" + url);
        }
        catch (UnknownHostException e) {
            Message.warn("Host " + e.getMessage() + " not found. url=" + url);
            Message.info("You probably access the destination server through a proxy server that is not well configured.");
        }
        catch (IOException e) {
            Message.error("HttpClientHandler: " + e.getMessage() + " url=" + url);
        }
        catch (IllegalArgumentException e) {
        }
        finally {
            if (head != null) {
                head.releaseConnection();
            }
        }
        return UNAVAILABLE;
    }

    private long getLastModified(HeadMethod head) {
        Header header = head.getResponseHeader("last-modified");
        if (header != null) {
            String lastModified = header.getValue();
            try {
                return LAST_MODIFIED_FORMAT.parse(lastModified).getTime();
            }
            catch (ParseException e) {
                return System.currentTimeMillis();
            }
        }
        return System.currentTimeMillis();
    }

    private long getResponseContentLength(HeadMethod head) {
        return this.getHttpClientHelper().getResponseContentLength(head);
    }

    private HttpClientHelper getHttpClientHelper() {
        if (this.httpClientHelper == null) {
            try {
                HttpMethodBase.class.getMethod("getResponseContentLength", new Class[0]);
                this.httpClientHelper = new HttpClientHelper3x();
                Message.verbose("using commons httpclient 3.x helper");
            }
            catch (SecurityException e) {
                Message.verbose("unable to get access to getResponseContentLength of commons-httpclient HeadMethod. Please use commons-httpclient 3.0 or use ivy with sufficient security permissions.");
                Message.verbose("exception: " + e.getMessage());
                this.httpClientHelper = new HttpClientHelper2x();
                Message.verbose("using commons httpclient 2.x helper");
            }
            catch (NoSuchMethodException e) {
                this.httpClientHelper = new HttpClientHelper2x();
                Message.verbose("using commons httpclient 2.x helper");
            }
        }
        return this.httpClientHelper;
    }

    public int getHttpClientMajorVersion() {
        HttpClientHelper helper = this.getHttpClientHelper();
        return helper.getHttpClientMajorVersion();
    }

    private GetMethod doGet(URL url) throws IOException {
        HttpClient client = this.getClient(url);
        GetMethod get = new GetMethod(url.toExternalForm());
        get.setDoAuthentication(this.useAuthentication(url) || this.useProxyAuthentication());
        client.executeMethod((HttpMethod)get);
        return get;
    }

    private HeadMethod doHead(URL url, int timeout) throws IOException {
        HttpClient client = this.getClient(url);
        client.setTimeout(timeout);
        HeadMethod head = new HeadMethod(url.toExternalForm());
        head.setDoAuthentication(this.useAuthentication(url) || this.useProxyAuthentication());
        client.executeMethod((HttpMethod)head);
        return head;
    }

    private HttpClient getClient(URL url) {
        Credentials c;
        HttpClient client = new HttpClient();
        ArrayList<String> authPrefs = new ArrayList<String>(2);
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        if (this.useProxy()) {
            client.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
            if (this.useProxyAuthentication()) {
                client.getState().setProxyCredentials(this.proxyRealm, this.proxyHost, (org.apache.commons.httpclient.Credentials)new UsernamePasswordCredentials(this.proxyUserName, this.proxyPasswd));
            }
        }
        if ((c = this.getCredentials(url)) != null) {
            Message.debug("found credentials for " + url + ": " + c);
            client.getState().setCredentials(c.getRealm(), c.getHost(), (org.apache.commons.httpclient.Credentials)new UsernamePasswordCredentials(c.getUserName(), c.getPasswd()));
        }
        return client;
    }

    private boolean useProxy() {
        return this.proxyHost != null && this.proxyHost.trim().length() > 0;
    }

    private boolean useAuthentication(URL url) {
        return this.getCredentials(url) != null;
    }

    private Credentials getCredentials(URL url) {
        return CredentialsStore.INSTANCE.getCredentials(null, url.getHost());
    }

    private boolean useProxyAuthentication() {
        return this.proxyUserName != null && this.proxyUserName.trim().length() > 0;
    }

    public static interface HttpClientHelper {
        public long getResponseContentLength(HeadMethod var1);

        public int getHttpClientMajorVersion();
    }

    private static final class HttpClientHelper2x
    implements HttpClientHelper {
        private static final int VERSION = 2;

        private HttpClientHelper2x() {
        }

        public long getResponseContentLength(HeadMethod head) {
            Header header = head.getResponseHeader("Content-Length");
            if (header != null) {
                try {
                    return Integer.parseInt(header.getValue());
                }
                catch (NumberFormatException e) {
                    Message.verbose("Invalid content-length value: " + e.getMessage());
                }
            }
            return 0L;
        }

        public int getHttpClientMajorVersion() {
            return 2;
        }
    }

    private static final class HttpClientHelper3x
    implements HttpClientHelper {
        private static final int VERSION = 3;

        private HttpClientHelper3x() {
        }

        public long getResponseContentLength(HeadMethod head) {
            return head.getResponseContentLength();
        }

        public int getHttpClientMajorVersion() {
            return 3;
        }
    }

    private static final class GETInputStream
    extends InputStream {
        private InputStream is;
        private GetMethod get;

        private GETInputStream(GetMethod get) throws IOException {
            this.get = get;
            this.is = get.getResponseBodyAsStream();
        }

        public int available() throws IOException {
            return this.is.available();
        }

        public void close() throws IOException {
            this.is.close();
            this.get.releaseConnection();
        }

        public boolean equals(Object obj) {
            return this.is.equals(obj);
        }

        public int hashCode() {
            return this.is.hashCode();
        }

        public void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        public void reset() throws IOException {
            this.is.reset();
        }

        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }

        public String toString() {
            return this.is.toString();
        }
    }
}

