/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.signal.ant.types;

import com.nokia.helium.core.HlmAntLibException;
import com.nokia.helium.core.LogSource;
import com.nokia.helium.core.ant.types.ReferenceType;
import com.nokia.helium.signal.ant.types.LogSourceList;
import com.nokia.helium.signal.ant.types.SignalInput;
import com.nokia.helium.signal.ant.types.TargetCondition;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;

public class SignalConfig
extends DataType {
    private Vector<ReferenceType> signalInputListRef = new Vector();
    private HashMap<String, TargetCondition> targetConditionsMap = new HashMap();
    private Vector<TargetCondition> targetConditions = new Vector();
    private Vector<LogSourceList> sourceList = new Vector();
    private String configID;

    public void setProject(Project project) {
        super.setProject(project);
        this.getProject().log("signalConfig element is now deprecated. Please consider moving to signalListenerConfig element or signal task nested element.", 1);
    }

    public ReferenceType createInputRef() {
        ReferenceType inputRef = new ReferenceType();
        this.add(inputRef);
        return inputRef;
    }

    public void add(ReferenceType input) {
        if (input != null) {
            this.signalInputListRef.add(input);
        }
    }

    public LogSourceList createSources() {
        LogSourceList source = new LogSourceList();
        this.add(source);
        return source;
    }

    public void add(LogSourceList source) {
        if (source != null && this.sourceList.isEmpty()) {
            this.sourceList.add(source);
        }
    }

    public Vector<LogSource> getLogSourceList() {
        Vector<LogSource> logSource = null;
        if (!this.sourceList.isEmpty()) {
            logSource = this.sourceList.elementAt(0).getLogSourceList();
        }
        return logSource;
    }

    public String getSourceType() {
        if (!this.sourceList.isEmpty()) {
            return this.sourceList.elementAt(0).getSourceType();
        }
        return "default";
    }

    public TargetCondition createTargetCondition() {
        TargetCondition condition = new TargetCondition();
        this.add(condition);
        return condition;
    }

    public void setConfigId(String confID) {
        this.configID = confID;
    }

    public String getConfigId() {
        return this.configID;
    }

    public void add(TargetCondition condition) {
        if (condition != null) {
            this.targetConditions.add(condition);
        }
    }

    public SignalInput getSignalInput() {
        if (this.signalInputListRef == null) {
            throw new HlmAntLibException("signaling", "signalInputList null exception");
        }
        ReferenceType inputRef = this.signalInputListRef.elementAt(0);
        Object obj = inputRef.getReferencedObject();
        if (obj instanceof SignalInput) {
            return (SignalInput)((Object)obj);
        }
        throw new HlmAntLibException("signaling", "input type is not of type SignalInput");
    }

    public TargetCondition getTargetCondition(String targetName) {
        if (this.targetConditionsMap.isEmpty()) {
            this.initializeTargetConditionsMap();
        }
        return this.targetConditionsMap.get(targetName);
    }

    public Set<String> getTargetNameSet() {
        if (this.targetConditionsMap.isEmpty()) {
            this.initializeTargetConditionsMap();
        }
        return this.targetConditionsMap.keySet();
    }

    private void initializeTargetConditionsMap() {
        ListIterator<TargetCondition> iter = this.targetConditions.listIterator();
        while (iter.hasNext()) {
            TargetCondition condition = iter.next();
            String name = condition.getName();
            if (name == null) continue;
            this.targetConditionsMap.put(name, condition);
        }
    }
}

