/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.checkin;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.apache.maven.scm.provider.hg.command.status.HgStatusCommand;
import org.apache.maven.scm.provider.hg.repository.HgScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public class HgCheckInCommand
extends AbstractCheckInCommand {
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, ScmVersion tag) throws ScmException {
        if (tag != null && !StringUtils.isEmpty((String)tag.getName())) {
            throw new ScmException("This provider can't handle tags for this operation");
        }
        ArrayList<ScmFile> commitedFiles = new ArrayList<ScmFile>();
        File[] files = fileSet.getFiles();
        if (files.length == 0) {
            HgStatusCommand statusCmd = new HgStatusCommand();
            statusCmd.setLogger(this.getLogger());
            StatusScmResult status = statusCmd.executeStatusCommand(repo, fileSet);
            List statusFiles = status.getChangedFiles();
            Iterator it = statusFiles.iterator();
            while (it.hasNext()) {
                ScmFile file = (ScmFile)it.next();
                if (file.getStatus() != ScmFileStatus.ADDED && file.getStatus() != ScmFileStatus.DELETED && file.getStatus() != ScmFileStatus.MODIFIED) continue;
                commitedFiles.add(new ScmFile(file.getPath(), ScmFileStatus.CHECKED_IN));
            }
        } else {
            for (int i = 0; i < files.length; ++i) {
                commitedFiles.add(new ScmFile(files[i].getPath(), ScmFileStatus.CHECKED_IN));
            }
        }
        String[] commitCmd = new String[]{"commit", "--message", message};
        commitCmd = HgUtils.expandCommandLine(commitCmd, fileSet);
        ScmResult result = HgUtils.execute(new HgConsumer(this.getLogger()), this.getLogger(), fileSet.getBasedir(), commitCmd);
        HgScmProviderRepository repository = (HgScmProviderRepository)repo;
        if (!repository.getURI().equals(fileSet.getBasedir().getAbsolutePath())) {
            String[] pushCmd = new String[]{"push", repository.getURI()};
            result = HgUtils.execute(new HgConsumer(this.getLogger()), this.getLogger(), fileSet.getBasedir(), pushCmd);
        }
        return new CheckInScmResult(commitedFiles, result);
    }
}

