/*
 * Decompiled with CFR 0.152.
 */
package fmpp.util;

import fmpp.util.MiscUtil;
import java.util.List;

public class DataLoaderUtil {
    public static final String OPTION_NAME_ENCODING = "encoding";

    public static String getStringArgument(int index, Object value) {
        return DataLoaderUtil.getStringSomething(DataLoaderUtil.argumentX(index), value);
    }

    public static String getStringOption(String name, Object value) {
        return DataLoaderUtil.getStringSomething(DataLoaderUtil.theXOption(name), value);
    }

    public static char getCharArgument(int index, Object value) {
        return DataLoaderUtil.getCharSomething(DataLoaderUtil.argumentX(index), value);
    }

    public static char getCharOption(String name, Object value) {
        return DataLoaderUtil.getCharSomething(DataLoaderUtil.theXOption(name), value);
    }

    public static boolean getBooleanArgument(int index, Object value) {
        return DataLoaderUtil.getBooleanSomething(DataLoaderUtil.argumentX(index), value);
    }

    public static boolean getBooleanOption(String name, Object value) {
        return DataLoaderUtil.getBooleanSomething(DataLoaderUtil.theXOption(name), value);
    }

    public static int getIntArgument(int index, Object value) {
        return DataLoaderUtil.parseIntSomething(DataLoaderUtil.argumentX(index), value);
    }

    public static int getIntOption(String name, Object value) {
        return DataLoaderUtil.parseIntSomething(DataLoaderUtil.theXOption(name), value);
    }

    public static String[] getStringArrayArgument(int index, Object value) {
        return DataLoaderUtil.getStringArrayArgument(index, value, false);
    }

    public static String[] getStringArrayOption(String name, Object value) {
        return DataLoaderUtil.getStringArrayOption(name, value, false);
    }

    public static String[] getStringArrayArgument(int index, Object value, boolean allowString) {
        return DataLoaderUtil.parseStringArraySomething(DataLoaderUtil.argumentX(index), value, allowString);
    }

    public static String[] getStringArrayOption(String name, Object value, boolean allowString) {
        return DataLoaderUtil.parseStringArraySomething(DataLoaderUtil.theXOption(name), value, allowString);
    }

    private static String theXOption(String name) {
        return "the \"" + name + "\" option";
    }

    private static String argumentX(int index) {
        return "argument " + index;
    }

    private static String getStringSomething(String what, Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("The value of " + what + " must be a string.");
    }

    private static char getCharSomething(String what, Object value) {
        if (value instanceof String) {
            String s = (String)value;
            if (s.equalsIgnoreCase("tab")) {
                return '\t';
            }
            if (s.length() != 1) {
                throw new IllegalArgumentException("The value of " + what + " must be 1 character long or tab.");
            }
            return s.charAt(0);
        }
        throw new IllegalArgumentException("The value of " + what + " must be a character.");
    }

    private static boolean getBooleanSomething(String what, Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalArgumentException("The value of " + what + " must be a boolean.");
    }

    private static int parseIntSomething(String what, Object value) {
        if (value instanceof Number) {
            try {
                return MiscUtil.numberToInt((Number)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The value of " + what + " must be an integer. (Detail: " + e.getMessage() + ")");
            }
        }
        throw new IllegalArgumentException("The value of " + what + " must be an integer.");
    }

    private static String[] parseStringArraySomething(String what, Object value, boolean allowString) {
        if (value instanceof List) {
            List ls = (List)value;
            int ln = ls.size();
            String[] res = new String[ln];
            for (int i = 0; i < ln; ++i) {
                Object o = ls.get(i);
                if (!(o instanceof String)) {
                    throw new IllegalArgumentException("The value of " + what + " must be a sequence of strings, but the item at " + "index " + i + " is not a string.");
                }
                res[i] = (String)o;
            }
            return res;
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Object[]) {
            Object[] ls = (Object[])value;
            String[] res = new String[ls.length];
            for (int i = 0; i < ls.length; ++i) {
                Object o = ls[i];
                if (!(o instanceof String)) {
                    throw new IllegalArgumentException("The value of " + what + " must be a sequence of strings, but the item at " + "index " + i + " is not a string.");
                }
                res[i] = (String)o;
            }
            return res;
        }
        if (allowString && value instanceof String) {
            String[] res = new String[]{(String)value};
            return res;
        }
        if (allowString) {
            throw new IllegalArgumentException("The value of " + what + " must be a sequence of strings or a single string, " + "but it is neither.");
        }
        throw new IllegalArgumentException("The value of " + what + " must be a sequence of strings, but it is not even " + "a sequence.");
    }
}

