/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit.listener;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.ant.antunit.AssertionFailedException;
import org.apache.ant.antunit.listener.BaseAntUnitListener;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.DOMUtils;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLAntUnitListener
extends BaseAntUnitListener {
    private static final String INDENT = "  ";
    private OutputStream out = null;
    private Writer wri;
    private DOMElementWriter domWri = new DOMElementWriter(true);
    private Document doc;
    private Element root;
    private Element currentTest;

    public XMLAntUnitListener() {
        super(new BaseAntUnitListener.SendLogTo("file"), "xml");
    }

    public void startTestSuite(Project testProject, String buildFile) {
        try {
            super.startTestSuite(testProject, buildFile);
            this.out = this.getOut(buildFile);
            this.wri = new OutputStreamWriter(this.out, "UTF8");
            this.doc = DOMUtils.newDocument();
            this.root = this.doc.createElement("testsuite");
            this.root.setAttribute("name", this.normalize(buildFile));
            this.root.setAttribute("buildFile", buildFile);
            String timestamp = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss");
            this.root.setAttribute("timestamp", timestamp);
            this.root.setAttribute("hostname", this.getHostname());
            this.domWri.writeXMLDeclaration(this.wri);
            this.domWri.openElement(this.root, this.wri, 0, INDENT, true);
            this.wri.write(StringUtils.LINE_SEP);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    public void endTestSuite(Project testProject, String buildFile) {
        try {
            Element e = DOMUtils.createChildElement((Element)this.root, (String)"tests");
            DOMUtils.appendText((Element)e, (String)String.valueOf(this.runCount));
            this.domWri.write(e, this.wri, 1, INDENT);
            e = DOMUtils.createChildElement((Element)this.root, (String)"failures");
            DOMUtils.appendText((Element)e, (String)String.valueOf(this.failureCount));
            this.domWri.write(e, this.wri, 1, INDENT);
            e = DOMUtils.createChildElement((Element)this.root, (String)"errors");
            DOMUtils.appendText((Element)e, (String)String.valueOf(this.errorCount));
            this.domWri.write(e, this.wri, 1, INDENT);
            e = DOMUtils.createChildElement((Element)this.root, (String)"time");
            DOMUtils.appendText((Element)e, (String)String.valueOf((double)(System.currentTimeMillis() - this.start) / 1000.0));
            this.domWri.write(e, this.wri, 1, INDENT);
            this.domWri.closeElement(this.root, this.wri, 0, INDENT, true);
            this.wri.flush();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        finally {
            this.close(this.out);
        }
    }

    public void startTest(String target) {
        try {
            super.startTest(target);
            this.currentTest = DOMUtils.createChildElement((Element)this.root, (String)"testcase");
            this.currentTest.setAttribute("name", target);
            this.domWri.openElement(this.currentTest, this.wri, 1, INDENT, true);
            this.wri.write(StringUtils.LINE_SEP);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    public void endTest(String target) {
        try {
            Element e = DOMUtils.createChildElement((Element)this.currentTest, (String)"time");
            DOMUtils.appendText((Element)e, (String)String.valueOf((double)(System.currentTimeMillis() - this.testStart) / 1000.0));
            this.domWri.write(e, this.wri, 2, INDENT);
            this.domWri.closeElement(this.currentTest, this.wri, 1, INDENT, true);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    public void addFailure(String target, AssertionFailedException ae) {
        super.addFailure(target, ae);
        this.formatError("failure", (Throwable)((Object)ae));
    }

    public void addError(String target, Throwable ae) {
        super.addError(target, ae);
        this.formatError("error", ae);
    }

    private void formatError(String type, Throwable t) {
        try {
            String message;
            Element e = DOMUtils.createChildElement((Element)this.currentTest, (String)type);
            Location l = this.getLocation(t);
            if (l.getLineNumber() != 0) {
                e.setAttribute("linenumber", String.valueOf(l.getLineNumber()));
            }
            if (l.getColumnNumber() != 0) {
                e.setAttribute("columnnumber", String.valueOf(l.getColumnNumber()));
            }
            if ((message = t.getMessage()) != null && message.length() > 0) {
                e.setAttribute("message", t.getMessage());
            }
            e.setAttribute("type", t.getClass().getName());
            DOMUtils.appendText((Element)e, (String)StringUtils.getStackTrace((Throwable)t));
            this.domWri.write(e, this.wri, 2, INDENT);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }
}

