/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.scm.ant.taskdefs;

import com.nokia.helium.scm.ant.taskdefs.BaseDirectoryScmAction;
import com.nokia.helium.scm.ant.types.Revision;
import com.nokia.helium.scm.ant.types.Tag;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.tools.ant.BuildException;

public class CheckoutAction
extends BaseDirectoryScmAction {
    private List<Tag> tags = new ArrayList<Tag>();
    private List<Revision> revisions = new ArrayList<Revision>();

    public Tag createTag() {
        Tag tag = new Tag();
        this.add(tag);
        return tag;
    }

    public void add(Tag tag) {
        this.tags.add(tag);
    }

    public Revision createRevision() {
        Revision revision = new Revision();
        this.add(revision);
        return revision;
    }

    public void add(Revision revision) {
        this.revisions.add(revision);
    }

    @Override
    public void execute(ScmRepository repository) throws ScmException {
        CheckOutScmResult result;
        ScmManager scmManager = this.getTask().getScmManager();
        if (this.tags.size() > 1) {
            throw new ScmException("You can only specify one tag nested element.");
        }
        if (this.revisions.size() > 1) {
            throw new ScmException("You can only specify one revision nested element.");
        }
        if (this.tags.size() == 1 && this.revisions.size() == 1) {
            throw new ScmException("You can not specify nested element 'revision' and 'tag' together.");
        }
        try {
            result = this.tags.size() == 1 ? scmManager.checkOut(repository, this.getScmFileSet(), (ScmVersion)new ScmTag(this.tags.get(0).getName())) : (this.revisions.size() == 1 ? scmManager.checkOut(repository, this.getScmFileSet(), (ScmVersion)new ScmRevision(this.revisions.get(0).getName())) : scmManager.checkOut(repository, this.getScmFileSet()));
        }
        catch (ScmException e) {
            throw new BuildException("SCM checkout action failed: " + (Object)((Object)e));
        }
        if (!result.isSuccess()) {
            throw new BuildException("SCM checkout action failed.");
        }
    }
}

