/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.scm.ant.taskdefs;

import com.nokia.helium.scm.ant.taskdefs.BaseDirectoryScmAction;
import com.nokia.helium.scm.ant.types.TagSet;
import com.nokia.maven.scm.command.tags.TagsScmResult;
import com.nokia.maven.scm.manager.ExtendedScmManager;
import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.tools.ant.BuildException;

public class TagsAction
extends BaseDirectoryScmAction {
    private String reference;

    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public void execute(ScmRepository repository) throws ScmException {
        try {
            ExtendedScmManager scmManager = (ExtendedScmManager)this.getTask().getScmManager();
            TagsScmResult result = scmManager.tags(repository, new File(this.getBasedir()));
            if (!result.isSuccess()) {
                throw new BuildException("SCM tags action error: " + result.getProviderMessage());
            }
            List<ScmTag> tags = result.getTags();
            TagSet tagSet = new TagSet();
            tagSet.setProject(this.getProject());
            this.getTask().log("Tag list:");
            for (ScmTag tag : tags) {
                tagSet.createTag().setName(tag.getName());
                this.getTask().log(" * " + tag.getName());
            }
            if (this.reference != null) {
                this.getTask().log("Creating reference: " + this.reference);
                this.getProject().addReference(this.reference, (Object)tagSet);
            }
        }
        catch (ScmException e) {
            throw new BuildException("SCM tags action failed: " + e.getMessage());
        }
    }
}

