/*
 * Decompiled with CFR 0.152.
 */
package fmpp.util;

import fmpp.util.ExceptionCC;
import fmpp.util.InstallationException;
import fmpp.util.RuntimeExceptionCC;
import fmpp.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MiscUtil {
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final BigInteger MAX_INT_AS_BIG_INTEGER = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_INT_AS_BIG_INTEGER = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final String CAUSED_BY_MSG = "Caused by: ";
    private static final String MSG_XML_NOT_AVAIL = "XML support is not available. You need to use Java2 platform 1.4 or later, or you have to install XML support.";

    public static String causeMessages(Throwable e) {
        return MiscUtil.causeTrace_common(e, true);
    }

    public static String causeTrace(Throwable e) {
        return MiscUtil.causeTrace_common(e, false);
    }

    private static String causeTrace_common(Throwable e, boolean looserFriendly) {
        if (e == null) {
            return "??? (the error was described with a null object)";
        }
        StringBuffer res = new StringBuffer();
        String lastShownMsg = null;
        boolean first = true;
        while (true) {
            String msg;
            if ((msg = e.getMessage()) != null) {
                if (lastShownMsg == null || !msg.equals(lastShownMsg)) {
                    if (!first) {
                        res.append(StringUtil.LINE_BREAK);
                        res.append(CAUSED_BY_MSG);
                    }
                    lastShownMsg = msg;
                    String cn = e.getClass().getName();
                    if (!looserFriendly || !cn.startsWith("fmpp.")) {
                        res.append(e.getClass().getName());
                        res.append(": ");
                    }
                    res.append(msg);
                }
            } else {
                if (!first) {
                    res.append(StringUtil.LINE_BREAK);
                    res.append(CAUSED_BY_MSG);
                }
                res.append(e.getClass().getName());
            }
            if ((e = MiscUtil.getCauseException(e)) == null) break;
            first = false;
        }
        return res.toString();
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return Class.forName(className);
    }

    public static Map dictionaryToMap(Dictionary dict) {
        HashMap m = new HashMap(dict.size());
        Enumeration en = dict.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            m.put(key, dict.get(key));
        }
        return m;
    }

    public static Throwable getCauseException(Throwable e) {
        Throwable e2;
        Method m;
        if (e instanceof InvocationTargetException) {
            return ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof ExceptionCC) {
            return ((ExceptionCC)e).getCause();
        }
        if (e instanceof RuntimeExceptionCC) {
            return ((RuntimeExceptionCC)e).getCause();
        }
        try {
            m = e.getClass().getMethod("getCause", EMPTY_CLASS_ARRAY);
            e2 = (Throwable)m.invoke((Object)e, EMPTY_OBJECT_ARRAY);
            if (e2 != null) {
                return e2;
            }
        }
        catch (Throwable exc) {
            // empty catch block
        }
        try {
            m = e.getClass().getMethod("getTarget", EMPTY_CLASS_ARRAY);
            e2 = (Throwable)m.invoke((Object)e, EMPTY_OBJECT_ARRAY);
            if (e2 != null) {
                return e2;
            }
        }
        catch (Throwable exc) {
            // empty catch block
        }
        try {
            m = e.getClass().getMethod("getRootCause", EMPTY_CLASS_ARRAY);
            e2 = (Throwable)m.invoke((Object)e, EMPTY_OBJECT_ARRAY);
            if (e2 != null) {
                return e2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static boolean listContainsObject(List list, Object o) {
        if (list instanceof ArrayList) {
            int i;
            int ln = list.size();
            for (i = 0; i < ln && list.get(i) != o; ++i) {
            }
            return i < ln;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (it.next() != o) continue;
            return true;
        }
        return false;
    }

    public static boolean mapContainsObject(Map map, Object o) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue() != o) continue;
            return true;
        }
        return false;
    }

    public static int findObject(List list, Object o) {
        if (list instanceof ArrayList) {
            int ln = list.size();
            for (int i = 0; i < ln; ++i) {
                if (list.get(i) != o) continue;
                return i;
            }
            return -1;
        }
        int i = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (it.next() == o) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void checkXmlSupportAvailability(String requiredForThis) throws InstallationException {
        Exception error = null;
        try {
            MiscUtil.classForName("javax.xml.parsers.DocumentBuilderFactory");
            MiscUtil.classForName("org.w3c.dom.Element");
            MiscUtil.classForName("org.xml.sax.XMLReader");
        }
        catch (ClassNotFoundException e) {
            error = e;
        }
        catch (SecurityException e) {
            error = e;
        }
        if (error != null) {
            if (requiredForThis != null) {
                throw new InstallationException("XML support is not available. You need to use Java2 platform 1.4 or later, or you have to install XML support. Note that XML support was required for this: " + requiredForThis, error);
            }
            throw new InstallationException(MSG_XML_NOT_AVAIL, error);
        }
    }

    public static int numberToInt(Number value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return value.intValue();
        }
        if (value instanceof Long) {
            long lv = (Long)value;
            if (lv >= Integer.MIN_VALUE && lv <= Integer.MAX_VALUE) {
                return (int)lv;
            }
            throw new IllegalArgumentException("Can't convert this long value to int, because it's out of range: " + lv);
        }
        if (value instanceof Double) {
            double dv = (Double)value;
            int iv = (int)dv;
            if (dv == (double)((int)dv)) {
                return iv;
            }
            throw new IllegalArgumentException("Can't convert this double value to int without loss: " + dv);
        }
        if (value instanceof Float) {
            float fv = ((Float)value).floatValue();
            int iv = (int)fv;
            if (fv == (float)((int)fv)) {
                return iv;
            }
            throw new IllegalArgumentException("Can't convert this float value to int without loss: " + fv);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bv = (BigDecimal)value;
            int iv = bv.intValue();
            if (bv.compareTo(BigDecimal.valueOf(iv)) == 0) {
                return iv;
            }
            throw new IllegalArgumentException("Can't convert this BigDecimal value to int without loss: " + bv);
        }
        if (value instanceof BigInteger) {
            BigInteger bv = (BigInteger)value;
            if (bv.compareTo(MIN_INT_AS_BIG_INTEGER) >= 0 && bv.compareTo(MAX_INT_AS_BIG_INTEGER) <= 0) {
                return bv.intValue();
            }
            throw new IllegalArgumentException("Can't convert this BigInteger value to int without loss: " + bv);
        }
        throw new IllegalArgumentException("Can't convert a " + value.getClass().getName() + " to integer number.");
    }
}

