/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant.taskdefs;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.DateUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CoverageRecorderEntry
implements BuildLogger,
SubBuildListener {
    private static final String BUILD_TAG = "build";
    private static final String TARGET_TAG = "target";
    private static final String TASK_TAG = "task";
    private static final String NAME_ATTR = "name";
    private static final String TIME_ATTR = "time";
    private static final String LOCATION_ATTR = "location";
    private static DocumentBuilder builder = CoverageRecorderEntry.getDocumentBuilder();
    private String recordTaskName;
    private String filename;
    private boolean record = true;
    private int loglevel = 2;
    private PrintStream outStream;
    private long targetStartTime;
    private boolean emacsMode;
    private Project project;
    private Document doc = builder.newDocument();
    private Hashtable tasks = new Hashtable();
    private Hashtable targets = new Hashtable();
    private Hashtable threadStacks = new Hashtable();
    private TimedElement buildElement;

    protected CoverageRecorderEntry(String name, String recordTaskName) {
        this.filename = name;
        this.recordTaskName = recordTaskName;
        this.startBuild();
    }

    protected static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    protected Stack getStack() {
        Stack threadStack = (Stack)this.threadStacks.get(Thread.currentThread());
        if (threadStack == null) {
            threadStack = new Stack();
            this.threadStacks.put(Thread.currentThread(), threadStack);
        }
        return threadStack;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setRecordState(Boolean state) {
        if (state != null) {
            this.record = state;
        }
    }

    public void buildStarted(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
        this.cleanup();
    }

    public void subBuildFinished(BuildEvent event) {
        if (event.getProject() == this.project) {
            this.cleanup();
        }
    }

    public void subBuildStarted(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
        Target target = event.getTarget();
        TimedElement targetElement = new TimedElement();
        targetElement.startTime = System.currentTimeMillis();
        targetElement.element = this.doc.createElement(TARGET_TAG);
        targetElement.element.setAttribute(NAME_ATTR, target.getName());
        this.targets.put(target, targetElement);
        this.getStack().push(targetElement);
    }

    public void targetFinished(BuildEvent event) {
        Target target = event.getTarget();
        TimedElement targetElement = (TimedElement)this.targets.get(target);
        if (targetElement != null) {
            long totalTime = System.currentTimeMillis() - targetElement.startTime;
            targetElement.element.setAttribute(TIME_ATTR, DateUtils.formatElapsedTime((long)totalTime));
            TimedElement parentElement = null;
            Stack threadStack = this.getStack();
            if (!threadStack.empty()) {
                TimedElement poppedStack = (TimedElement)threadStack.pop();
                if (!threadStack.empty()) {
                    parentElement = (TimedElement)threadStack.peek();
                }
            }
            if (parentElement == null) {
                this.buildElement.element.appendChild(targetElement.element);
            } else {
                parentElement.element.appendChild(targetElement.element);
            }
        }
        this.targets.remove(target);
    }

    public void taskStarted(BuildEvent event) {
        TimedElement taskElement = new TimedElement();
        taskElement.startTime = System.currentTimeMillis();
        taskElement.element = this.doc.createElement(TASK_TAG);
        Task task = event.getTask();
        String name = event.getTask().getTaskName();
        if (name == null) {
            name = "";
        }
        taskElement.element.setAttribute(NAME_ATTR, name);
        taskElement.element.setAttribute(LOCATION_ATTR, event.getTask().getLocation().toString());
        this.tasks.put(task, taskElement);
        this.getStack().push(taskElement);
    }

    public void taskFinished(BuildEvent event) {
        Task task = event.getTask();
        TimedElement taskElement = (TimedElement)this.tasks.get(task);
        if (taskElement != null) {
            long totalTime = System.currentTimeMillis() - taskElement.startTime;
            taskElement.element.setAttribute(TIME_ATTR, DateUtils.formatElapsedTime((long)totalTime));
            Target target = task.getOwningTarget();
            TimedElement targetElement = null;
            if (target != null) {
                targetElement = (TimedElement)this.targets.get(target);
            }
            if (targetElement == null) {
                this.buildElement.element.appendChild(taskElement.element);
            } else {
                targetElement.element.appendChild(taskElement.element);
            }
            Stack threadStack = this.getStack();
            if (!threadStack.empty()) {
                TimedElement poppedStack = (TimedElement)threadStack.pop();
            }
            this.tasks.remove(task);
        }
    }

    protected TimedElement getTaskElement(Task task) {
        TimedElement element = (TimedElement)this.tasks.get(task);
        if (element != null) {
            return element;
        }
        Enumeration e = this.tasks.keys();
        while (e.hasMoreElements()) {
            Task key = (Task)e.nextElement();
            if (!(key instanceof UnknownElement) || ((UnknownElement)key).getTask() != task) continue;
            return (TimedElement)this.tasks.get(key);
        }
        return null;
    }

    public void messageLogged(BuildEvent event) {
    }

    public void setMessageOutputLevel(int level) {
        if (level >= 0 && level <= 4) {
            this.loglevel = level;
        }
    }

    public void setOutputPrintStream(PrintStream output) {
        this.outStream = output;
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public void setErrorPrintStream(PrintStream err) {
        this.setOutputPrintStream(err);
    }

    public void setProject(Project project) {
        this.project = project;
        if (project != null) {
            project.addBuildListener((BuildListener)this);
        }
    }

    public void cleanup() {
        this.closeFile();
        if (this.project != null) {
            this.project.removeBuildListener((BuildListener)this);
        }
        this.project = null;
    }

    void closeFile() {
        this.finishBuild();
        Writer out = null;
        try {
            OutputStream stream = this.outStream;
            if (stream == null) {
                stream = new FileOutputStream(this.filename);
            }
            out = new OutputStreamWriter(stream, "UTF8");
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            new DOMElementWriter().write(this.buildElement.element, out, 0, "\t");
            out.flush();
        }
        catch (IOException exc) {
            throw new BuildException("Unable to write log file", (Throwable)exc);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e2) {
                    Object e2 = null;
                }
            }
        }
        this.buildElement = null;
    }

    void startBuild() {
        this.buildElement = new TimedElement();
        this.buildElement.startTime = System.currentTimeMillis();
        this.buildElement.element = this.doc.createElement(BUILD_TAG);
    }

    void finishBuild() {
        long totalTime = System.currentTimeMillis() - this.buildElement.startTime;
        this.buildElement.element.setAttribute(TIME_ATTR, DateUtils.formatElapsedTime((long)totalTime));
    }

    protected static class TimedElement {
        private long startTime;
        private Element element;

        protected TimedElement() {
        }

        public String toString() {
            return this.element.getTagName() + ":" + this.element.getAttribute(CoverageRecorderEntry.NAME_ATTR);
        }
    }
}

