/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant;

import info.bliki.wiki.model.WikiModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class ModelPropertiesParser {
    private String inputPath;
    private String outputPath;
    private Document doc;

    public ModelPropertiesParser(String inputPath, String outputPath) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
    }

    public void parsePropertiesDescription() throws IOException, DocumentException {
        SAXReader xmlReader = new SAXReader();
        this.doc = xmlReader.read(new File(this.inputPath));
        List importNodes = this.doc.selectNodes("//description");
        for (Element importCurrentNode : importNodes) {
            importCurrentNode.setText(this.renderWikiModel(importCurrentNode.getText()));
            this.writeXMLFile();
        }
    }

    private void writeXMLFile() {
        try {
            if (this.outputPath != null) {
                XMLWriter out = new XMLWriter((OutputStream)new FileOutputStream(new File(this.outputPath)), OutputFormat.createPrettyPrint());
                out.write(this.doc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String renderWikiModel(String descriptionText) throws IOException, DocumentException {
        if (descriptionText != null) {
            WikiModel wikiModel = new WikiModel("", "");
            if (descriptionText.contains("**") || descriptionText.contains("==") || descriptionText.contains("- -")) {
                descriptionText = descriptionText.replace("**", "").replace("==", "").replace("- -", "").trim();
            }
            if (descriptionText.startsWith("-")) {
                descriptionText = descriptionText.replace("-", "");
            }
            descriptionText = descriptionText.trim();
            descriptionText = wikiModel.render(descriptionText);
        } else {
            descriptionText = "";
        }
        return descriptionText;
    }
}

