/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.ant;

import com.nokia.ant.Database;
import com.nokia.helium.core.ant.types.HlmPostDefImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.io.SAXReader;

public class BuildStatusDef
extends HlmPostDefImpl {
    private Logger log;
    private HashSet<String> output = new HashSet();

    public BuildStatusDef() {
        this.log = Logger.getLogger(BuildStatusDef.class);
    }

    public void execute(Project prj, String module, String[] targetNames) {
        for (int i = 0; i < targetNames.length; ++i) {
            String[] array = new String[]{targetNames[i]};
            Target target = this.findTarget(targetNames[i], this.project, array);
            this.targetCallsHeliumTarget(target, this.project);
        }
        this.checkTargetsProperties(this.project);
        if (!this.output.isEmpty()) {
            System.out.println("*** Configuration report ***");
            for (String x : this.output) {
                System.out.println(x);
            }
        }
    }

    public Target findTarget(String desiredTarget, Project project, String[] targetNames) {
        Target t = new Target();
        boolean matchFound = false;
        Hashtable targets = project.getTargets();
        Vector sorted = project.topoSort(targetNames[0], targets);
        for (int i = 0; i < sorted.size(); ++i) {
            t = (Target)sorted.get(i);
            if (!t.getName().equals(desiredTarget)) continue;
            matchFound = true;
            break;
        }
        if (matchFound) {
            return t;
        }
        throw new BuildException("Could not find target matching " + desiredTarget + "\n");
    }

    public void targetCallsHeliumTarget(Target target, Project project) {
        String location = target.getLocation().getFileName();
        try {
            String heliumpath = new File(project.getProperty("helium.dir")).getCanonicalPath();
            String targetpath = new File(location).getCanonicalPath();
            if (!targetpath.contains(heliumpath)) {
                Object x2;
                Target depTarget;
                String[] array;
                ArrayList antcallTargets = new ArrayList();
                AntTargetVisitor visitorTarget = new AntTargetVisitor(antcallTargets, project);
                Element element = this.findTargetElement(target, project);
                if (element != null) {
                    element.accept((Visitor)visitorTarget);
                }
                for (String depTargetString : antcallTargets) {
                    array = new String[]{depTargetString};
                    try {
                        depTarget = this.findTarget(depTargetString, project, array);
                        this.targetCallsHeliumTarget(depTarget, project);
                    }
                    catch (BuildException x2) {
                        x2 = null;
                    }
                }
                Enumeration e = target.getDependencies();
                while (e.hasMoreElements()) {
                    String depTargetString;
                    depTargetString = (String)e.nextElement();
                    array = new String[]{depTargetString};
                    try {
                        depTarget = this.findTarget(depTargetString, project, array);
                        this.targetCallsHeliumTarget(depTarget, project);
                    }
                    catch (BuildException x3) {
                        x2 = null;
                    }
                }
            } else {
                this.checkIfTargetPrivate(target, project);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Element findTargetElement(Target target, Project project) {
        SAXReader xmlReader = new SAXReader();
        Document antDoc = null;
        String location = target.getLocation().getFileName();
        try {
            File file = new File(location);
            antDoc = xmlReader.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String projectName = antDoc.valueOf("/project/@name");
        for (Element e : antDoc.selectNodes("//target")) {
            String targetName = e.attributeValue("name");
            if (!targetName.equals(target.getName()) && !(projectName + "." + targetName).equals(target.getName())) continue;
            return e;
        }
        return null;
    }

    public void checkIfTargetPrivate(Target target, Project project) {
        List children;
        Element targetElement = this.findTargetElement(target, project);
        if (targetElement != null && (children = targetElement.selectNodes("preceding-sibling::node()")).size() > 0) {
            int index = children.size() - 1;
            Node child = (Node)children.get(index);
            while (index > 0 && child.getNodeType() == 3) {
                child = (Node)children.get(--index);
            }
            String commentText = null;
            if (child.getNodeType() == 8) {
                Comment macroComment = (Comment)child;
                commentText = macroComment.getStringValue().trim();
            }
            if (commentText != null) {
                if (commentText.contains("Private:")) {
                    this.output.add("Warning: " + target.getName() + " is private and should only be called by helium");
                }
                if (commentText.contains("<deprecated>")) {
                    this.output.add("Warning: " + target.getName() + "\n" + commentText);
                }
            }
        }
    }

    public void checkTargetsProperties(Project project) {
        if (project.getProperty("data.model.file") != null) {
            SAXReader xmlReader = new SAXReader();
            Document antDoc = null;
            ArrayList customerProps = this.getCustomerProperties(project);
            try {
                File model = new File(project.getProperty("data.model.file"));
                antDoc = xmlReader.read(model);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List statements = antDoc.selectNodes("//property");
            for (Node statement : statements) {
                if (!statement.valueOf("editStatus").equals("never") || !customerProps.contains(statement.valueOf("name"))) continue;
                this.output.add("Warning: " + statement.valueOf("name") + " property has been overridden");
            }
        }
    }

    public ArrayList getCustomerProperties(Project project) {
        ArrayList<String> props = new ArrayList<String>();
        Database db = new Database(null, null, null);
        try {
            String heliumpath = new File(project.getProperty("helium.dir")).getCanonicalPath();
            for (Object o : db.getAntFiles(project)) {
                String antFile = (String)o;
                if ((antFile = new File(antFile).getCanonicalPath()).contains(heliumpath)) continue;
                SAXReader xmlReader = new SAXReader();
                Document antDoc = xmlReader.read(new File(antFile));
                List propertyNodes = antDoc.selectNodes("//property | //param");
                for (Element propertyNode : propertyNodes) {
                    String propertyName = propertyNode.attributeValue("name");
                    props.add(propertyName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    private class AntTargetVisitor
    extends VisitorSupport {
        private List targetList;
        private Project project;

        public AntTargetVisitor(List targetList, Project project) {
            this.targetList = targetList;
            this.project = project;
        }

        public void visit(Element node) {
            String name = node.getName();
            if (name.equals("antcall") || name.equals("runtarget")) {
                String text = node.attributeValue("target");
                this.extractTarget(text);
            }
        }

        private void extractTarget(String text) {
            String iText = this.project.replaceProperties(text);
            this.targetList.add(iText);
        }
    }
}

