/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.cmt;

import com.nokia.ant.types.Variable;
import com.nokia.ant.types.VariableSet;
import com.nokia.tools.Tool;
import com.nokia.tools.ToolsProcessException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Enumeration;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.FileSet;

public class CMTTool
implements Tool {
    @Override
    public void execute(VariableSet varSet, Project prj) throws ToolsProcessException {
        String input = null;
        String output = null;
        String config = null;
        String pattern = null;
        String keepGoing = "false";
        Enumeration e = varSet.getVariables().elements();
        while (e.hasMoreElements()) {
            Variable variable = (Variable)((Object)e.nextElement());
            String varName = variable.getName();
            String value = variable.getValue();
            if (varName.equals("input")) {
                input = value;
                continue;
            }
            if (varName.equals("config")) {
                config = value;
                continue;
            }
            if (varName.equals("output")) {
                output = value;
                continue;
            }
            if (!varName.equals("pattern")) continue;
            pattern = value;
        }
        if (input == null || output == null || pattern == null) {
            throw new ToolsProcessException("CMTTool Parameter missing");
        }
        this.generateFileList(input, output, pattern, prj);
        try {
            ExecTask task = new ExecTask();
            task.setDir(new File(prj.getProperty("build.drive")));
            task.setTaskName("cmttool");
            task.setExecutable("cmt.exe");
            task.createArg().setValue("-f");
            task.createArg().setValue(input + System.getProperty("file.separator") + "files.lst");
            task.createArg().setValue("-o");
            task.createArg().setValue(output);
            task.execute();
            ExecTask cmt2task = new ExecTask();
            cmt2task.setDir(new File(output).getParentFile());
            cmt2task.setTaskName("cmt2html");
            cmt2task.setExecutable("cmt2html.bat");
            cmt2task.createArg().setValue("-i");
            cmt2task.createArg().setValue(output);
            cmt2task.createArg().setValue("-nsb");
            cmt2task.execute();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void generateFileList(String input, String output, String pattern, Project prj) {
        FileSet fileset = new FileSet();
        String[] includes = pattern.split(",");
        fileset.setDir(new File(input));
        fileset.setProject(prj);
        fileset.appendIncludes(includes);
        DirectoryScanner ds = fileset.getDirectoryScanner();
        ds.scan();
        String[] filelist = ds.getIncludedFiles();
        String fileSeparator = System.getProperty("file.separator");
        File fileList = new File(input + fileSeparator + "files.lst");
        try {
            BufferedWriter outputFile = new BufferedWriter(new FileWriter(fileList));
            for (int i = 0; i < filelist.length; ++i) {
                outputFile.write(input + fileSeparator + filelist[i] + "\n");
            }
            outputFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

