/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CSVReader {
    private String separator;
    private String escape;
    private String doubleEscape;

    public CSVReader(String separator, String escape) {
        this.separator = separator;
        this.escape = escape;
        this.doubleEscape = escape + escape;
    }

    private String cleanEscapes(String s) {
        int start = 0;
        while ((start = s.indexOf(this.escape, start)) != -1) {
            String prefix = s.substring(0, start);
            String suffix = s.substring(start);
            if (suffix.startsWith(this.doubleEscape)) {
                suffix = this.escape + suffix.substring(this.doubleEscape.length());
                start = prefix.length() + this.escape.length();
            } else {
                suffix = suffix.substring(this.escape.length());
                start = prefix.length();
            }
            s = prefix + suffix;
        }
        return s;
    }

    private boolean endsWithEscape(String s) {
        int start = 0;
        int lastIndexOfDoubleEscape = 0;
        while ((start = s.indexOf(this.doubleEscape, start)) != -1) {
            lastIndexOfDoubleEscape = start += this.doubleEscape.length();
        }
        return s.substring(lastIndexOfDoubleEscape).endsWith(this.escape);
    }

    public List digest(String s, boolean lastLevel) {
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        while ((start = s.indexOf(this.separator, start)) != -1) {
            String prefix = s.substring(0, start);
            if (!this.endsWithEscape(prefix)) {
                String atom = prefix;
                if (lastLevel) {
                    atom = this.cleanEscapes(prefix);
                }
                list.add(atom);
                s = s.substring(start + this.separator.length());
                start = 0;
                continue;
            }
            start += this.separator.length();
        }
        if (lastLevel) {
            s = this.cleanEscapes(s);
        }
        list.add(s);
        return list;
    }

    public List digest(List lines, boolean lastLevel) {
        ArrayList<List> list = new ArrayList<List>();
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            String line = (String)iter.next();
            list.add(this.digest(line, lastLevel));
        }
        return list;
    }

    public static void main(String[] args) {
        CSVReader reader = new CSVReader("|", "*");
        CSVReader reader2 = new CSVReader(";", "*");
        System.out.println(reader.digest("ha|ho**|hi", true));
        System.out.println("" + reader.digest(reader2.digest("ha|ho|hi;ha|ho|hi", false), true));
        System.out.println("" + reader.digest(reader2.digest("ha|ho|hi**;ha|ho|hi", false), true));
    }
}

