/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.synergy.repository;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;

public class SynergyScmProviderRepository
extends ScmProviderRepository {
    private String projectSpec;
    private String projectName;
    private String projectVersion;
    private String projectRelease;
    private String projectPurpose;
    private String delimiter;

    public SynergyScmProviderRepository(String url) throws ScmRepositoryException {
        try {
            this.parseUrl(url);
        }
        catch (MalformedURLException e) {
            throw new ScmRepositoryException("Illegal URL: " + url + "(" + e.getMessage() + ")");
        }
        catch (URISyntaxException e) {
            throw new ScmRepositoryException("Illegal URL: " + url + "(" + e.getMessage() + ")");
        }
        catch (UnknownHostException e) {
            throw new ScmRepositoryException("Illegal URL: " + url + "(" + e.getMessage() + ")");
        }
    }

    private void parseUrl(String url) throws MalformedURLException, URISyntaxException, UnknownHostException {
        if (url.indexOf(124) != -1) {
            StringTokenizer tokenizer = new StringTokenizer(url, "|");
            this.fillInProperties(tokenizer);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(url, ":");
            this.fillInProperties(tokenizer);
        }
    }

    private void fillInProperties(StringTokenizer tokenizer) throws UnknownHostException, URISyntaxException, MalformedURLException {
        if (tokenizer.countTokens() != 5) {
            throw new MalformedURLException();
        }
        this.projectName = tokenizer.nextToken();
        this.delimiter = tokenizer.nextToken();
        this.projectVersion = tokenizer.nextToken();
        this.projectRelease = tokenizer.nextToken();
        this.projectPurpose = tokenizer.nextToken();
        this.projectSpec = this.projectName + this.delimiter + this.projectVersion;
    }

    public String getProjectSpec() {
        return this.projectSpec;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public String getProjectPurpose() {
        return this.projectPurpose;
    }

    public String getProjectRelease() {
        return this.projectRelease;
    }
}

