/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;

public abstract class PrintCodeVisitor
implements CodeVisitor {
    protected final List text;
    protected final StringBuffer buf = new StringBuffer();
    public static final String[] OPCODES;

    static {
        String[] stringArray = new String[202];
        stringArray[0] = "NOP";
        stringArray[1] = "ACONST_NULL";
        stringArray[2] = "ICONST_M1";
        stringArray[3] = "ICONST_0";
        stringArray[4] = "ICONST_1";
        stringArray[5] = "ICONST_2";
        stringArray[6] = "ICONST_3";
        stringArray[7] = "ICONST_4";
        stringArray[8] = "ICONST_5";
        stringArray[9] = "LCONST_0";
        stringArray[10] = "LCONST_1";
        stringArray[11] = "FCONST_0";
        stringArray[12] = "FCONST_1";
        stringArray[13] = "FCONST_2";
        stringArray[14] = "DCONST_0";
        stringArray[15] = "DCONST_1";
        stringArray[16] = "BIPUSH";
        stringArray[17] = "SIPUSH";
        stringArray[18] = "LDC";
        stringArray[21] = "ILOAD";
        stringArray[22] = "LLOAD";
        stringArray[23] = "FLOAD";
        stringArray[24] = "DLOAD";
        stringArray[25] = "ALOAD";
        stringArray[46] = "IALOAD";
        stringArray[47] = "LALOAD";
        stringArray[48] = "FALOAD";
        stringArray[49] = "DALOAD";
        stringArray[50] = "AALOAD";
        stringArray[51] = "BALOAD";
        stringArray[52] = "CALOAD";
        stringArray[53] = "SALOAD";
        stringArray[54] = "ISTORE";
        stringArray[55] = "LSTORE";
        stringArray[56] = "FSTORE";
        stringArray[57] = "DSTORE";
        stringArray[58] = "ASTORE";
        stringArray[79] = "IASTORE";
        stringArray[80] = "LASTORE";
        stringArray[81] = "FASTORE";
        stringArray[82] = "DASTORE";
        stringArray[83] = "AASTORE";
        stringArray[84] = "BASTORE";
        stringArray[85] = "CASTORE";
        stringArray[86] = "SASTORE";
        stringArray[87] = "POP";
        stringArray[88] = "POP2";
        stringArray[89] = "DUP";
        stringArray[90] = "DUP_X1";
        stringArray[91] = "DUP_X2";
        stringArray[92] = "DUP2";
        stringArray[93] = "DUP2_X1";
        stringArray[94] = "DUP2_X2";
        stringArray[95] = "SWAP";
        stringArray[96] = "IADD";
        stringArray[97] = "LADD";
        stringArray[98] = "FADD";
        stringArray[99] = "DADD";
        stringArray[100] = "ISUB";
        stringArray[101] = "LSUB";
        stringArray[102] = "FSUB";
        stringArray[103] = "DSUB";
        stringArray[104] = "IMUL";
        stringArray[105] = "LMUL";
        stringArray[106] = "FMUL";
        stringArray[107] = "DMUL";
        stringArray[108] = "IDIV";
        stringArray[109] = "LDIV";
        stringArray[110] = "FDIV";
        stringArray[111] = "DDIV";
        stringArray[112] = "IREM";
        stringArray[113] = "LREM";
        stringArray[114] = "FREM";
        stringArray[115] = "DREM";
        stringArray[116] = "INEG";
        stringArray[117] = "LNEG";
        stringArray[118] = "FNEG";
        stringArray[119] = "DNEG";
        stringArray[120] = "ISHL";
        stringArray[121] = "LSHL";
        stringArray[122] = "ISHR";
        stringArray[123] = "LSHR";
        stringArray[124] = "IUSHR";
        stringArray[125] = "LUSHR";
        stringArray[126] = "IAND";
        stringArray[127] = "LAND";
        stringArray[128] = "IOR";
        stringArray[129] = "LOR";
        stringArray[130] = "IXOR";
        stringArray[131] = "LXOR";
        stringArray[132] = "IINC";
        stringArray[133] = "I2L";
        stringArray[134] = "I2F";
        stringArray[135] = "I2D";
        stringArray[136] = "L2I";
        stringArray[137] = "L2F";
        stringArray[138] = "L2D";
        stringArray[139] = "F2I";
        stringArray[140] = "F2L";
        stringArray[141] = "F2D";
        stringArray[142] = "D2I";
        stringArray[143] = "D2L";
        stringArray[144] = "D2F";
        stringArray[145] = "I2B";
        stringArray[146] = "I2C";
        stringArray[147] = "I2S";
        stringArray[148] = "LCMP";
        stringArray[149] = "FCMPL";
        stringArray[150] = "FCMPG";
        stringArray[151] = "DCMPL";
        stringArray[152] = "DCMPG";
        stringArray[153] = "IFEQ";
        stringArray[154] = "IFNE";
        stringArray[155] = "IFLT";
        stringArray[156] = "IFGE";
        stringArray[157] = "IFGT";
        stringArray[158] = "IFLE";
        stringArray[159] = "IF_ICMPEQ";
        stringArray[160] = "IF_ICMPNE";
        stringArray[161] = "IF_ICMPLT";
        stringArray[162] = "IF_ICMPGE";
        stringArray[163] = "IF_ICMPGT";
        stringArray[164] = "IF_ICMPLE";
        stringArray[165] = "IF_ACMPEQ";
        stringArray[166] = "IF_ACMPNE";
        stringArray[167] = "GOTO";
        stringArray[168] = "JSR";
        stringArray[169] = "RET";
        stringArray[170] = "TABLESWITCH";
        stringArray[171] = "LOOKUPSWITCH";
        stringArray[172] = "IRETURN";
        stringArray[173] = "LRETURN";
        stringArray[174] = "FRETURN";
        stringArray[175] = "DRETURN";
        stringArray[176] = "ARETURN";
        stringArray[177] = "RETURN";
        stringArray[178] = "GETSTATIC";
        stringArray[179] = "PUTSTATIC";
        stringArray[180] = "GETFIELD";
        stringArray[181] = "PUTFIELD";
        stringArray[182] = "INVOKEVIRTUAL";
        stringArray[183] = "INVOKESPECIAL";
        stringArray[184] = "INVOKESTATIC";
        stringArray[185] = "INVOKEINTERFACE";
        stringArray[187] = "NEW";
        stringArray[188] = "NEWARRAY";
        stringArray[189] = "ANEWARRAY";
        stringArray[190] = "ARRAYLENGTH";
        stringArray[191] = "ATHROW";
        stringArray[192] = "CHECKCAST";
        stringArray[193] = "INSTANCEOF";
        stringArray[194] = "MONITORENTER";
        stringArray[195] = "MONITOREXIT";
        stringArray[197] = "MULTIANEWARRAY";
        stringArray[198] = "IFNULL";
        stringArray[199] = "IFNONNULL";
        OPCODES = stringArray;
    }

    protected PrintCodeVisitor() {
        this.text = new ArrayList();
    }

    public void visitInsn(int opcode) {
        this.buf.setLength(0);
        this.printInsn(opcode);
        this.text.add(this.buf.toString());
    }

    public void visitIntInsn(int opcode, int operand) {
        this.buf.setLength(0);
        this.printIntInsn(opcode, operand);
        this.text.add(this.buf.toString());
    }

    public void visitVarInsn(int opcode, int var) {
        this.buf.setLength(0);
        this.printVarInsn(opcode, var);
        this.text.add(this.buf.toString());
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.buf.setLength(0);
        this.printTypeInsn(opcode, desc);
        this.text.add(this.buf.toString());
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.buf.setLength(0);
        this.printFieldInsn(opcode, owner, name, desc);
        this.text.add(this.buf.toString());
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.buf.setLength(0);
        this.printMethodInsn(opcode, owner, name, desc);
        this.text.add(this.buf.toString());
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.buf.setLength(0);
        this.printJumpInsn(opcode, label);
        this.text.add(this.buf.toString());
    }

    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.printLabel(label);
        this.text.add(this.buf.toString());
    }

    public void visitLdcInsn(Object cst) {
        this.buf.setLength(0);
        this.printLdcInsn(cst);
        this.text.add(this.buf.toString());
    }

    public void visitIincInsn(int var, int increment) {
        this.buf.setLength(0);
        this.printIincInsn(var, increment);
        this.text.add(this.buf.toString());
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.buf.setLength(0);
        this.printTableSwitchInsn(min, max, dflt, labels);
        this.text.add(this.buf.toString());
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.buf.setLength(0);
        this.printLookupSwitchInsn(dflt, keys, labels);
        this.text.add(this.buf.toString());
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.buf.setLength(0);
        this.printMultiANewArrayInsn(desc, dims);
        this.text.add(this.buf.toString());
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.buf.setLength(0);
        this.printTryCatchBlock(start, end, handler, type);
        this.text.add(this.buf.toString());
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.buf.setLength(0);
        this.printMaxs(maxStack, maxLocals);
        this.text.add(this.buf.toString());
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        this.buf.setLength(0);
        this.printLocalVariable(name, desc, start, end, index);
        this.text.add(this.buf.toString());
    }

    public void visitLineNumber(int line, Label start) {
        this.buf.setLength(0);
        this.printLineNumber(line, start);
        this.text.add(this.buf.toString());
    }

    public void visitAttribute(Attribute attr) {
        this.buf.setLength(0);
        this.printAttribute(attr);
        this.text.add(this.buf.toString());
    }

    public List getText() {
        return this.text;
    }

    public abstract void printInsn(int var1);

    public abstract void printIntInsn(int var1, int var2);

    public abstract void printVarInsn(int var1, int var2);

    public abstract void printTypeInsn(int var1, String var2);

    public abstract void printFieldInsn(int var1, String var2, String var3, String var4);

    public abstract void printMethodInsn(int var1, String var2, String var3, String var4);

    public abstract void printJumpInsn(int var1, Label var2);

    public abstract void printLabel(Label var1);

    public abstract void printLdcInsn(Object var1);

    public abstract void printIincInsn(int var1, int var2);

    public abstract void printTableSwitchInsn(int var1, int var2, Label var3, Label[] var4);

    public abstract void printLookupSwitchInsn(Label var1, int[] var2, Label[] var3);

    public abstract void printMultiANewArrayInsn(String var1, int var2);

    public abstract void printTryCatchBlock(Label var1, Label var2, Label var3, String var4);

    public abstract void printMaxs(int var1, int var2);

    public abstract void printLocalVariable(String var1, String var2, Label var3, Label var4, int var5);

    public abstract void printLineNumber(int var1, Label var2);

    public abstract void printAttribute(Attribute var1);
}

