/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.imaker.ant.engines;

import com.nokia.helium.core.plexus.StreamRecorder;
import com.nokia.helium.imaker.IMaker;
import com.nokia.helium.imaker.IMakerException;
import com.nokia.helium.imaker.ant.Command;
import com.nokia.helium.imaker.ant.Engine;
import com.nokia.helium.imaker.ant.taskdefs.IMakerTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JavaEngine
extends DataType
implements Engine {
    private IMakerTask task;
    private OutputStreamWriter output;
    private int threads = 1;

    @Override
    public void setTask(IMakerTask task) {
        this.task = task;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    @Override
    public void build(List<List<Command>> cmds) throws IMakerException {
        this.task.log("Building with Ant engine.");
        if (this.threads <= 0) {
            throw new BuildException("'threads' must be >= 0. (current value: " + this.threads + ")");
        }
        this.openLog();
        for (List<Command> cmdlist : cmds) {
            this.task.log("Building command list in parallel.");
            if (cmdlist.size() <= 0) continue;
            ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(cmdlist.size());
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(this.threads, this.threads, 10L, TimeUnit.MILLISECONDS, queue);
            this.task.log("Adding " + cmdlist.size() + " to queue.");
            for (final Command cmd : cmdlist) {
                threadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JavaEngine.this.buildCommand(cmd);
                        }
                        catch (IMakerException e) {
                            JavaEngine.this.task.log(e.getMessage(), 0);
                        }
                    }
                });
            }
            threadPool.shutdown();
            try {
                while (!threadPool.isTerminated()) {
                    threadPool.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.closeLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildCommand(Command cmd) throws IMakerException {
        IMaker imaker = this.task.getIMaker();
        StreamRecorder rec = new StreamRecorder();
        imaker.addOutputLineHandler((StreamConsumer)rec);
        imaker.addErrorLineHandler((StreamConsumer)rec);
        rec.consumeLine("-- " + cmd.getCmdLine());
        rec.consumeLine("++ Started at " + new Date());
        rec.consumeLine("+++ HiRes Start " + new Date().getTime());
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(cmd.getArguments());
        File tempDir = imaker.createWorkDir();
        args.add("WORKDIR=" + tempDir.getAbsolutePath());
        for (Map.Entry<String, String> e : cmd.getVariables().entrySet()) {
            if (e.getKey().equals("WORKDIR")) {
                this.task.log("WORKDIR cannot be defined by the user, the value will be ignored.", 1);
                continue;
            }
            args.add(e.getKey() + "=" + e.getValue());
        }
        args.add(cmd.getTarget());
        try {
            imaker.execute(args.toArray(new String[args.size()]));
        }
        catch (IMakerException e) {
            this.task.log(e.getMessage(), 0);
            rec.consumeLine(e.getMessage());
        }
        finally {
            rec.consumeLine("+++ HiRes End " + new Date().getTime());
            rec.consumeLine("++ Finished at " + new Date());
        }
        this.writeLog(rec.getBuffer().toString());
    }

    private void openLog() throws IMakerException {
        if (this.task.getOutput() != null) {
            try {
                this.output = new OutputStreamWriter(new FileOutputStream(this.task.getOutput()));
            }
            catch (FileNotFoundException e) {
                throw new IMakerException(e.getMessage(), e);
            }
        }
    }

    private synchronized void writeLog(String str) throws IMakerException {
        if (this.output != null) {
            try {
                this.output.write(str);
            }
            catch (IOException e) {
                throw new IMakerException(e.getMessage(), e);
            }
        }
    }

    private void closeLog() throws IMakerException {
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException e) {
                throw new IMakerException(e.getMessage(), e);
            }
        }
    }
}

