/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.metadata.ant.types.MetaDataFilter;
import fmpp.models.CsvSequence;
import fmpp.util.StringUtil;
import freemarker.template.TemplateSequenceModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class MetaDataFilterSet
extends DataType {
    private Vector<MetaDataFilter> filters = new Vector();
    private Vector<MetaDataFilterSet> filterSets = new Vector();
    private String filterFile;
    private Logger log = Logger.getLogger(MetaDataFilterSet.class);

    public void setFilterFile(String file) throws Exception {
        this.filterFile = file;
        this.addCSVFromFile(file);
    }

    public String getFilterFile() {
        return this.filterFile;
    }

    public Vector<MetaDataFilter> getAllFilters() throws Exception {
        Vector<MetaDataFilter> allFilters = new Vector<MetaDataFilter>();
        if (this.filters.size() > 0) {
            allFilters.addAll(this.filters);
            return allFilters;
        }
        Reference refId = this.getRefid();
        Object filterSetObject = null;
        if (refId != null) {
            try {
                filterSetObject = refId.getReferencedObject();
            }
            catch (Exception ex) {
                this.log.info((Object)"Reference id of the filter is not valid");
                throw ex;
            }
            if (filterSetObject != null && filterSetObject instanceof MetaDataFilterSet) {
                allFilters.addAll(((MetaDataFilterSet)((Object)filterSetObject)).getAllFilters());
                return allFilters;
            }
            throw new Exception("filterset object is not instance of MetaDataFilterSet");
        }
        for (MetaDataFilterSet filterSet : this.filterSets) {
            allFilters.addAll(filterSet.getAllFilters());
        }
        return this.removeInvalidFilters(allFilters);
    }

    private Vector<MetaDataFilter> removeInvalidFilters(Vector<MetaDataFilter> filterList) {
        ListIterator<MetaDataFilter> iter = filterList.listIterator();
        while (iter.hasNext()) {
            MetaDataFilter filter = iter.next();
            String priority = filter.getPriority();
            String regEx = filter.getRegex();
            if (priority != null && regEx != null) continue;
            this.log.info((Object)"Warning: invalid filter removed");
            this.log.debug((Object)"Warning: some filter is invalid removing it");
            iter.remove();
        }
        return filterList;
    }

    public MetaDataFilter createMetaDataFilter() {
        MetaDataFilter filter = new MetaDataFilter();
        this.add(filter);
        return filter;
    }

    public void add(MetaDataFilter filter) {
        MetaDataFilterSet filterSet = this.createMetaDataFilterSet();
        filterSet.getFilterList().add(filter);
    }

    Vector<MetaDataFilter> getFilterList() {
        return this.filters;
    }

    public MetaDataFilterSet createMetaDataFilterSet() {
        MetaDataFilterSet filterSet = new MetaDataFilterSet();
        this.add(filterSet);
        return filterSet;
    }

    public void add(MetaDataFilterSet filterSet) {
        if (filterSet != null) {
            this.filterSets.add(filterSet);
        }
    }

    private void addCSVFromFile(String csvPath) throws Exception {
        CsvSequence csvs = new CsvSequence();
        csvs.setSeparator(',');
        this.log.debug((Object)("filter file: " + this.filterFile));
        try {
            csvs.load((Reader)new FileReader(new File(this.filterFile)));
        }
        catch (FileNotFoundException fex) {
            this.log.error((Object)("File not found:" + this.filterFile));
            throw fex;
        }
        catch (StringUtil.ParseException pex) {
            this.log.error((Object)"parser exception");
            throw pex;
        }
        catch (IOException iex) {
            this.log.error((Object)"I/O exception");
            throw iex;
        }
        int size = 0;
        try {
            this.log.debug((Object)("filter CSV record size: " + csvs.size()));
            size = csvs.size();
        }
        catch (Exception ex) {
            this.log.info((Object)"Warning: filter parsing error");
            this.log.debug((Object)"Exception in processing csv file");
        }
        for (int i = 0; i < size; ++i) {
            try {
                TemplateSequenceModel model = (TemplateSequenceModel)csvs.get(i);
                int modelSize = model.size();
                if (modelSize != 3) {
                    this.log.debug((Object)("csv row size:" + size));
                    throw new Exception("filter format is invalid");
                }
                MetaDataFilter filter = new MetaDataFilter();
                filter.setPriority(model.get(0).toString());
                filter.setRegex(model.get(1).toString());
                filter.setDescription(model.get(2).toString());
                this.filters.add(filter);
                continue;
            }
            catch (Exception ex) {
                this.log.info((Object)"Warning: filter parsing error");
                this.log.debug((Object)"Exception in processing csv file");
            }
        }
    }
}

